/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class LoadOWLDeprecatedClassTestCase
extends AbstractJenaTestCase {
    public void testLoadSimpleDeprecatedClass() throws Exception {
        this.loadRemoteOntology("deprecated.owl");
        RDFSNamedClass carClass = this.owlModel.getRDFSNamedClass("Car");
        LoadOWLDeprecatedClassTestCase.assertNotNull((Object)carClass);
        LoadOWLDeprecatedClassTestCase.assertTrue((boolean)carClass.isDeprecated());
    }

    public void testLoadDeprecatedClassWithRestriction() throws Exception {
        this.loadRemoteOntology("owlDeprecatedClass.owl");
        RDFSNamedClass cls = this.owlModel.getRDFSNamedClass("Class");
        LoadOWLDeprecatedClassTestCase.assertTrue((boolean)cls.isDeprecated());
        LoadOWLDeprecatedClassTestCase.assertSize(2, cls.getRDFTypes());
        LoadOWLDeprecatedClassTestCase.assertContains((Object)this.owlModel.getOWLDeprecatedClassClass(), cls.getRDFTypes());
        LoadOWLDeprecatedClassTestCase.assertContains((Object)this.owlModel.getOWLNamedClassClass(), cls.getRDFTypes());
        LoadOWLDeprecatedClassTestCase.assertTrue((boolean)(cls instanceof OWLNamedClass));
        this.dumpRDF();
    }
}

