/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class LoadOWLEnumeratedClassTestCase
extends AbstractJenaTestCase {
    public void testLoadEnumerationWithClass() throws Exception {
        this.loadRemoteOntology("enum-with-class.owl");
        OWLNamedClass cls = this.owlModel.getOWLNamedClass("Cls");
        OWLNamedClass enumCls = this.owlModel.getOWLNamedClass("Enum");
        OWLObjectProperty slot = (OWLObjectProperty)this.owlModel.getSlot("slot");
        LoadOWLEnumeratedClassTestCase.assertNotNull((Object)cls);
        LoadOWLEnumeratedClassTestCase.assertNotNull((Object)enumCls);
        LoadOWLEnumeratedClassTestCase.assertNotNull((Object)slot);
        OWLEnumeratedClass e = (OWLEnumeratedClass)enumCls.getDefinition();
        LoadOWLEnumeratedClassTestCase.assertSize(2, e.getOneOf());
        LoadOWLEnumeratedClassTestCase.assertContains((Object)cls, e.getOneOf());
        LoadOWLEnumeratedClassTestCase.assertContains((Object)slot, e.getOneOf());
    }

    public void testLoadInlineEnumeratedClass() throws Exception {
        this.loadRemoteOntology("colors.owl");
        OWLNamedClass c = this.owlModel.getOWLNamedClass("TrafficLightColors");
        LoadOWLEnumeratedClassTestCase.assertNotNull((Object)c);
        LoadOWLEnumeratedClassTestCase.assertTrue((boolean)(c.getDefinition() instanceof OWLEnumeratedClass));
    }
}

