/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collection;

public class LoadOWLEquivalentClassTestCase
extends AbstractJenaTestCase {
    public void testLoadInlineEquivalentClass() throws Exception {
        this.loadRemoteOntology("inlineEquivalentClass.owl");
        OWLNamedClass a = this.owlModel.getOWLNamedClass("A");
        OWLNamedClass b = this.owlModel.getOWLNamedClass("B");
        OWLNamedClass c = this.owlModel.getOWLNamedClass("C");
        Collection superclasses = c.getSuperclasses(false);
        LoadOWLEquivalentClassTestCase.assertSize(4, superclasses);
        LoadOWLEquivalentClassTestCase.assertContains((Object)a, superclasses);
        LoadOWLEquivalentClassTestCase.assertContains((Object)b, superclasses);
        LoadOWLEquivalentClassTestCase.assertContains((Object)this.owlThing, superclasses);
        OWLIntersectionClass intersectionClass = (OWLIntersectionClass)c.getDefinition();
        LoadOWLEquivalentClassTestCase.assertSize(2, intersectionClass.getOperands());
        LoadOWLEquivalentClassTestCase.assertContains((Object)a, intersectionClass.getOperands());
        LoadOWLEquivalentClassTestCase.assertContains((Object)b, intersectionClass.getOperands());
        RDFProperty owlEquivalentProperty = this.owlModel.getOWLEquivalentClassProperty();
        LoadOWLEquivalentClassTestCase.assertSize(0, a.getPropertyValues(owlEquivalentProperty));
        LoadOWLEquivalentClassTestCase.assertSize(0, b.getPropertyValues(owlEquivalentProperty));
        LoadOWLEquivalentClassTestCase.assertSize(1, c.getPropertyValues(owlEquivalentProperty));
        LoadOWLEquivalentClassTestCase.assertEquals((Object)intersectionClass, (Object)c.getPropertyValue(owlEquivalentProperty));
    }
}

