/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.triplestore;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.protege2jena.Protege2Jena;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class JenaMemoryTripleWriter
implements TripleWriter {
    private Node defaultOntologyNode;
    private OntModel ontModel;
    private OutputStream os;

    public JenaMemoryTripleWriter() {
        this(null);
    }

    public JenaMemoryTripleWriter(OutputStream os) {
        this(os, ModelFactory.createOntologyModel());
    }

    public JenaMemoryTripleWriter(OutputStream os, OntModel ontModel) {
        this.ontModel = ontModel;
        this.os = os;
    }

    public void addImport(String uri) {
        this.addTriple(this.defaultOntologyNode, OWL.imports.getNode(), Node.create((String)uri));
    }

    public void addTriple(Node subject, Node predicate, Node object) {
        this.ontModel.getBaseModel().getGraph().add(new Triple(subject, predicate, object));
    }

    public void close() throws Exception {
        String lang = "RDF/XML-ABBREV";
        RDFWriter writer = this.ontModel.getWriter(lang);
        String defaultNamespace = this.ontModel.getNsPrefixURI("");
        Jena.prepareWriter(writer, lang, defaultNamespace);
        OutputStreamWriter ow = new OutputStreamWriter(this.os, "UTF-8");
        String baseURI = defaultNamespace;
        if (baseURI.endsWith("#")) {
            baseURI = baseURI.substring(0, baseURI.length() - 1);
        }
        Protege2Jena.removeRedundantRDFLists((Model)this.ontModel);
        writer.write(this.ontModel.getBaseModel(), (Writer)ow, baseURI);
        this.os.close();
    }

    private Node createNodeFromRDFResource(RDFResource resource) {
        if (resource.isAnonymous()) {
            AnonId anonId = new AnonId("_:" + resource.getName());
            return Node.createAnon((AnonId)anonId);
        }
        return Node.create((String)resource.getURI());
    }

    private Node createNodeFromRDFSLiteral(RDFSLiteral literal, OWLModel owlModel) {
        String language = literal.getLanguage();
        if (language != null) {
            String value = literal.getString();
            return Node.createLiteral((String)value, (String)language, (RDFDatatype)XMLSchemaDatatypes.getXSDDatatype(owlModel.getXSDstring()));
        }
        XSDDatatype datatype = XMLSchemaDatatypes.getXSDDatatype(literal.getDatatype());
        if (datatype == null && owlModel.getRDFXMLLiteralType().equals(literal.getDatatype())) {
            datatype = XMLLiteralType.theXMLLiteralType;
        }
        return Node.createLiteral((String)literal.getString(), (String)"", (RDFDatatype)datatype);
    }

    public OntModel getOntModel() {
        return this.ontModel;
    }

    public void init(String baseURI) {
        this.defaultOntologyNode = Node.create((String)baseURI);
        this.addTriple(this.defaultOntologyNode, RDF.type.getNode(), OWL.Ontology.getNode());
    }

    public void write(RDFResource tsubject, RDFProperty tpredicate, Object tobject) {
        Node subject = this.createNodeFromRDFResource(tsubject);
        Node predicate = this.createNodeFromRDFResource(tpredicate);
        Node object = null;
        if (tobject instanceof RDFResource) {
            object = this.createNodeFromRDFResource((RDFResource)tobject);
        } else if (tobject instanceof RDFSLiteral) {
            object = this.createNodeFromRDFSLiteral((RDFSLiteral)tobject, tsubject.getOWLModel());
        } else {
            OWLModel owlModel = tsubject.getOWLModel();
            RDFSLiteral literal = owlModel.asRDFSLiteral(tobject);
            object = this.createNodeFromRDFSLiteral(literal, owlModel);
        }
        this.addTriple(subject, predicate, object);
    }

    public void writePrefix(String prefix, String namespace) {
        this.ontModel.setNsPrefix(prefix, namespace);
    }
}

