/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.framestore.DeleteSimplificationFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.framestore.AllValuesFromRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.framestore.CardinalityRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.framestore.HasValueRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.framestore.RestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLHasValue;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class OWLFrameStore
extends FrameStoreAdapter {
    private Hashtable class2Updater = new Hashtable();
    private Hashtable facet2Updater = new Hashtable();
    protected boolean facetHandlingBlocked;
    private AllValuesFromRestrictionUpdater allValuesFromRestrictionUpdater;
    private CardinalityRestrictionUpdater cardinalityRestrictionUpdater;
    private HasValueRestrictionUpdater hasValueRestrictionUpdater;
    private AbstractOWLModel owlModel;
    protected boolean superclassHandlingBlocked;
    private boolean suppressUpdateTemplateSlots = false;
    public static final String IGNORE_PREFIXES_IN_SEARCH = "OWL-TOLERATE-PREFIXES-IN-SEARCH";
    private boolean superclassSynchronizationBlocked = false;
    private boolean deletingRDFSDatatype = false;
    public static boolean autoDeleteOfAnonymousClses = true;
    public static boolean allowDuplicateOwnSlotValues = false;
    public boolean suppressUpdateRDFSDomain = false;

    public OWLFrameStore(AbstractOWLModel owlModel) {
        this.owlModel = owlModel;
        this.initRestrictionUpdaters();
    }

    public void addDirectSuperclass(Cls cls, Cls superCls) {
        if (!cls.hasDirectSuperclass(superCls)) {
            super.addDirectSuperclass(cls, superCls);
            if (superCls instanceof OWLIntersectionClass && cls instanceof OWLNamedClass && superCls.hasDirectSuperclass(cls)) {
                this.addNamedOperandsToDirectSuperclasses((OWLNamedClass)cls, (OWLIntersectionClass)superCls);
            } else if (cls instanceof OWLIntersectionClass && superCls instanceof OWLNamedClass && superCls.hasDirectSuperclass(cls)) {
                this.addNamedOperandsToDirectSuperclasses((OWLNamedClass)superCls, (OWLIntersectionClass)cls);
            }
            if (!this.superclassHandlingBlocked && cls instanceof OWLNamedClass) {
                OWLNamedClass namedCls = (OWLNamedClass)cls;
                if (superCls instanceof OWLRestriction) {
                    this.copyFacetValuesIntoOWLNamedClass(namedCls, (OWLRestriction)superCls);
                }
            }
            if (cls instanceof OWLNamedClass && superCls instanceof OWLNamedClass && cls.isEditable() && ((OWLNamedClass)superCls).getSubclassesDisjoint()) {
                OWLUtil.ensureSubclassesDisjoint((OWLNamedClass)superCls);
            }
            if (!this.superclassSynchronizationBlocked) {
                if (cls instanceof RDFSNamedClass) {
                    this.updateRDFSSubClassOf((RDFSNamedClass)cls);
                }
                if (superCls instanceof RDFSNamedClass) {
                    this.updateRDFSSubClassOf((RDFSNamedClass)superCls);
                }
            }
        }
    }

    public void addDirectSuperslot(Slot slot, Slot superSlot) {
        super.addDirectSuperslot(slot, superSlot);
        if (slot instanceof RDFProperty) {
            RDFProperty property = (RDFProperty)slot;
            if (property instanceof OWLProperty && superSlot instanceof OWLProperty && ((OWLProperty)superSlot).isAnnotationProperty()) {
                this.addDirectType((Instance)slot, this.owlModel.getCls("owl:AnnotationProperty"));
            }
            if (property.getRange() == null) {
                slot.setDirectOwnSlotValue(this.owlModel.getSlot(":SLOT-VALUE-TYPE"), null);
            }
            if (!property.isDomainDefined()) {
                slot.setDirectOwnSlotValue(this.owlModel.getSlot(":DIRECT-DOMAIN"), null);
            }
        }
    }

    public void addDirectType(Instance instance, Cls type) {
        if (instance instanceof RDFProperty && type.equals(this.owlModel.getOWLFunctionalPropertyClass())) {
            ((Slot)instance).setAllowsMultipleValues(false);
        }
        if (instance instanceof RDFResource && !instance.getDirectOwnSlotValues((Slot)this.owlModel.getRDFTypeProperty()).contains(type) && !type.equals(this.owlModel.getRDFUntypedResourcesClass())) {
            instance.addOwnSlotValue((Slot)this.owlModel.getRDFTypeProperty(), (Object)type);
        }
        super.addDirectType(instance, type);
    }

    private void addNamedOperandsToDirectSuperclasses(OWLNamedClass cls, OWLIntersectionClass superCls) {
        for (RDFSClass operand : superCls.getOperands()) {
            if (!(operand instanceof OWLNamedClass)) continue;
            cls.addSuperclass(operand);
        }
    }

    private List convertInternalFormatToRDFSLiterals(Collection values) {
        LinkedList<DefaultRDFSLiteral> result = new LinkedList<DefaultRDFSLiteral>();
        for (Object o : values) {
            if (o instanceof String) {
                String str = (String)o;
                if (DefaultRDFSLiteral.isRawValue(str)) {
                    result.add(new DefaultRDFSLiteral(this.owlModel, str));
                    continue;
                }
                result.add((DefaultRDFSLiteral)o);
                continue;
            }
            result.add((DefaultRDFSLiteral)o);
        }
        return result;
    }

    private List convertRDFSLiteralsToInternalFormat(Collection values) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object o : values) {
            if (o instanceof RDFSLiteral) {
                DefaultRDFSLiteral literal = (DefaultRDFSLiteral)o;
                Object optimized = literal.getPlainValue();
                if (optimized != null) {
                    result.add(optimized);
                    continue;
                }
                result.add(literal.getRawValue());
                continue;
            }
            result.add(o);
        }
        return result;
    }

    private void copyFacetValuesIntoOWLNamedClass(RDFSNamedClass cls, OWLRestriction restriction) {
        Class<?> clazz = restriction.getClass();
        RestrictionUpdater ru = (RestrictionUpdater)this.class2Updater.get(clazz);
        if (ru != null) {
            this.facetHandlingBlocked = true;
            ru.copyFacetValuesIntoNamedClass(cls, restriction);
            this.facetHandlingBlocked = false;
        }
    }

    private void copyFacetValuesIntoOWLNamedClass(OWLRestriction restriction) {
        if (restriction.getSubclasses(false).size() == 1) {
            RDFSNamedClass namedCls = (RDFSNamedClass)restriction.getSubclasses(false).toArray()[0];
            this.copyFacetValuesIntoOWLNamedClass(namedCls, restriction);
        }
    }

    public void copyFacetValuesIntoNamedClses() {
        boolean oldUndo = this.owlModel.isUndoEnabled();
        this.owlModel.setUndoEnabled(false);
        for (Cls cls : this.owlModel.getRDFSClasses()) {
            if (!(cls instanceof OWLRestriction)) continue;
            this.copyFacetValuesIntoOWLNamedClass((OWLRestriction)cls);
        }
        this.owlModel.setUndoEnabled(oldUndo);
    }

    public Cls createCls(FrameID id, String name, Collection directTypes, Collection directSuperclasses, boolean loadDefaults) {
        Cls cls = super.createCls(id, name, directTypes, directSuperclasses, loadDefaults);
        if (cls instanceof OWLNamedClass && cls.isEditable()) {
            for (Cls superCls : directSuperclasses) {
                if (!(superCls instanceof OWLNamedClass) || !((OWLNamedClass)superCls).getSubclassesDisjoint()) continue;
                OWLUtil.ensureSubclassesDisjoint((OWLNamedClass)superCls);
            }
        }
        if (cls instanceof RDFSNamedClass) {
            ((RDFSNamedClass)cls).setPropertyValues(this.owlModel.getRDFSSubClassOfProperty(), directSuperclasses);
            cls.setDirectOwnSlotValues((Slot)this.owlModel.getRDFTypeProperty(), directTypes);
        } else if (cls instanceof OWLRestriction) {
            cls.setDirectOwnSlotValue((Slot)this.owlModel.getRDFTypeProperty(), (Object)this.owlModel.getRDFSNamedClass("owl:Restriction"));
        } else if (cls instanceof OWLAnonymousClass) {
            cls.setDirectOwnSlotValue((Slot)this.owlModel.getRDFTypeProperty(), (Object)this.owlModel.getOWLNamedClassClass());
        }
        return cls;
    }

    public Slot createSlot(FrameID id, String name, Collection directTypes, Collection directSuperslots, boolean loadDefaults) {
        Slot slot = super.createSlot(id, name, directTypes, directSuperslots, loadDefaults);
        if (slot instanceof RDFProperty) {
            RDFProperty rdfProperty = (RDFProperty)slot;
            slot.setAllowsMultipleValues(true);
            if (slot instanceof OWLObjectProperty && directSuperslots.isEmpty()) {
                rdfProperty.setValueType(ValueType.INSTANCE);
            }
            slot.setDirectOwnSlotValues((Slot)this.owlModel.getRDFTypeProperty(), directTypes);
            rdfProperty.setDomainDefined(false);
        }
        return slot;
    }

    public SimpleInstance createSimpleInstance(FrameID id, String name, Collection directTypes, boolean loadDefaults) {
        SimpleInstance instance = super.createSimpleInstance(id, name, directTypes, loadDefaults);
        if (instance instanceof RDFResource && !directTypes.contains(this.owlModel.getRDFUntypedResourcesClass())) {
            instance.setDirectOwnSlotValues((Slot)this.owlModel.getRDFTypeProperty(), directTypes);
        }
        return instance;
    }

    private void deleteAnonymousClass(OWLAnonymousClass cls) {
        Set refs = cls.getReferringAnonymousClasses();
        this.deleteDependingListInstances(cls);
        if (refs.size() > 0) {
            this.deleteAnonymousClses(refs);
        } else {
            this.deleteAnonymousClses(Collections.singleton(cls));
        }
    }

    private void deleteAnonymousClses(Collection clses) {
        this.deleteAnonymousClasses(clses, Collections.EMPTY_LIST);
    }

    private void deleteAnonymousClasses(Collection clses, Collection survivors) {
        if (!clses.isEmpty()) {
            HashSet<OWLAnonymousClass> roots = new HashSet<OWLAnonymousClass>();
            for (Object next : clses) {
                if (next instanceof OWLAnonymousClass) {
                    OWLAnonymousClass root = ((OWLAnonymousClass)next).getExpressionRoot();
                    if (survivors.contains(root)) continue;
                    roots.add(root);
                    continue;
                }
                if (!(next instanceof OWLDataRange)) continue;
                ((OWLDataRange)next).delete();
            }
            for (OWLAnonymousClass anonymousCls : roots) {
                this.deleteAnonymousTree(anonymousCls);
            }
        }
    }

    private void deleteAnonymousTree(OWLAnonymousClass anonymousClass) {
        RDFResource filler;
        if (anonymousClass instanceof OWLIntersectionClass) {
            OWLIntersectionClass intersectionClass = (OWLIntersectionClass)anonymousClass;
            this.ensureRDFSSubClassOfStatementsExistForNamedOperands(intersectionClass);
        }
        Collection dependants = anonymousClass.getDependingClasses();
        for (OWLAnonymousClass dependentCls : dependants) {
            this.deleteAnonymousTree(dependentCls);
        }
        this.deleteRDFListsThatArePropertyValues(anonymousClass);
        if (anonymousClass instanceof OWLQuantifierRestriction && (filler = ((OWLQuantifierRestriction)anonymousClass).getFiller()) instanceof RDFSDatatype && filler.isAnonymous()) {
            this.deletingRDFSDatatype = true;
            filler.delete();
            this.deletingRDFSDatatype = false;
        }
        super.deleteCls((Cls)anonymousClass);
    }

    public void deleteCls(Cls cls) {
        if (cls instanceof OWLAnonymousClass) {
            this.deleteAnonymousClass((OWLAnonymousClass)cls);
        } else if (cls instanceof RDFSNamedClass) {
            this.deleteNamedClass((RDFSNamedClass)cls);
        } else {
            this.deleteDependingListInstances((Instance)cls);
            super.deleteCls(cls);
        }
    }

    private void deleteDependingAnonymousClses(Cls cls) {
        Collection ds = this.getClsesToDelete(cls);
        for (Cls dc : ds) {
            if (!(dc instanceof RDFSNamedClass)) continue;
            Set refs = ((RDFSNamedClass)dc).getReferringAnonymousClasses();
            this.deleteAnonymousClses(refs);
            for (Cls superCls : new ArrayList(dc.getDirectSuperclasses())) {
                if (!(superCls instanceof OWLAnonymousClass)) continue;
                superCls.delete();
            }
        }
    }

    private void deleteDependingAnonymousClses(Slot slot) {
        Collection ds = this.getSlotsToDelete(slot);
        for (Slot dc : ds) {
            if (!(dc instanceof RDFProperty)) continue;
            Set refs = ((RDFProperty)dc).getReferringAnonymousClasses();
            this.deleteAnonymousClses(refs);
        }
    }

    private void deleteDependingListInstances(Instance instance) {
        RDFList nil = this.owlModel.getRDFNil();
        Set refs = this.getReferences(instance);
        RDFProperty firstSlot = this.owlModel.getRDFFirstProperty();
        for (Reference reference : refs) {
            RDFList li;
            if (!firstSlot.equals(reference.getSlot()) || nil.equals(li = (RDFList)reference.getFrame())) continue;
            this.deleteListInstance(li);
        }
        if (instance instanceof RDFResource) {
            this.deleteRDFListsThatArePropertyValues((RDFResource)instance);
        }
    }

    private void deleteRDFListsThatArePropertyValues(RDFResource resource) {
        RDFList nil = this.owlModel.getRDFNil();
        for (RDFProperty property : resource.getPossibleRDFProperties()) {
            ArrayList values = new ArrayList(resource.getPropertyValues(property));
            for (Object o : values) {
                if (!(o instanceof RDFList) || nil.equals(o)) continue;
                RDFList l = (RDFList)o;
                resource.removePropertyValue(property, l);
                l.delete();
            }
        }
    }

    private void deleteListInstance(RDFList li) {
        RDFList rest = li.getRest();
        if (this.owlModel.getRDFNil().equals(rest)) {
            rest = null;
        }
        li.setRest(null);
        if (rest != null) {
            RDFProperty restProperty = this.owlModel.getRDFRestProperty();
            for (Reference reference : this.getReferences(li)) {
                Frame frame = reference.getFrame();
                Slot slot = reference.getSlot();
                if (slot.isSystem() && !slot.equals(restProperty) && !slot.equals(this.owlModel.getOWLIntersectionOfProperty()) && !slot.equals(this.owlModel.getOWLUnionOfProperty()) && !slot.equals(this.owlModel.getOWLOneOfProperty()) && !slot.equals(this.owlModel.getOWLDistinctMembersProperty())) continue;
                frame.addOwnSlotValue(slot, (Object)rest);
            }
        }
        li.delete();
    }

    private void deleteNamedClass(RDFSNamedClass cls) {
        this.deleteNamedClassFromDomainsAndRanges(cls);
        this.deleteDependingAnonymousClses(cls);
        this.deleteAnonymousClses(cls.getSuperclasses(false));
        this.deleteAnonymousClses(cls.getReferringAnonymousClasses());
        this.deleteDependingListInstances(cls);
        super.deleteCls((Cls)cls);
    }

    private void deleteNamedClassFromDomainsAndRanges(RDFSNamedClass cls) {
        Set anons = cls.getReferringAnonymousClasses();
        for (OWLAnonymousClass anon : anons) {
            if (!(anon instanceof OWLUnionClass)) continue;
            for (Reference reference : this.owlModel.getReferences((Frame)anon)) {
                if (!(reference.getFrame() instanceof RDFProperty)) continue;
                RDFProperty property = (RDFProperty)reference.getFrame();
                if (reference.getSlot().equals(this.owlModel.getRDFSDomainProperty())) {
                    property.removeUnionDomainClass(cls);
                    continue;
                }
                if (!reference.getSlot().equals(this.owlModel.getRDFSRangeProperty())) continue;
                ArrayList remainingClasses = new ArrayList(property.getUnionRangeClasses());
                remainingClasses.remove(cls);
                property.setUnionRangeClasses(remainingClasses);
            }
        }
        Collection refs = this.owlModel.getReferences((Frame)cls);
        for (Reference ref : refs) {
            if (!ref.getSlot().equals(this.owlModel.getRDFSDomainProperty())) continue;
            RDFProperty prop = (RDFProperty)ref.getFrame();
            prop.removeUnionDomainClass(cls);
        }
    }

    public void deleteQuantifierRestrictions(OWLProperty property) {
        HashSet<OWLAnonymousClass> roots = new HashSet<OWLAnonymousClass>();
        for (Reference reference : this.owlModel.getReferences((Frame)property)) {
            if (!(reference.getFrame() instanceof OWLQuantifierRestriction)) continue;
            OWLQuantifierRestriction r = (OWLQuantifierRestriction)reference.getFrame();
            roots.add(r.getExpressionRoot());
        }
        for (OWLAnonymousClass cls : roots) {
            OWLFrameStore.log("- Deleting quantifier restriction root " + cls.getBrowserText());
            cls.delete();
        }
    }

    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        if (simpleInstance instanceof RDFList) {
            this.deleteListChain((RDFList)simpleInstance);
        }
        this.deleteDependingListInstances((Instance)simpleInstance);
        if (simpleInstance instanceof RDFResource && !this.deletingRDFSDatatype) {
            RDFResource resource = (RDFResource)simpleInstance;
            this.deleteAnonymousClses(resource.getReferringAnonymousClasses());
        }
        super.deleteSimpleInstance(simpleInstance);
    }

    private void deleteListChain(RDFList list) {
        RDFList rest;
        Object first = list.getFirst();
        if (first instanceof OWLAnonymousClass) {
            list.setFirst(null);
            ((OWLAnonymousClass)first).delete();
        }
        if ((rest = list.getRest()) != null && !this.owlModel.getRDFNil().equals(rest)) {
            rest.delete();
        }
    }

    public void deleteSlot(Slot slot) {
        this.deleteDependingListInstances((Instance)slot);
        if (slot instanceof RDFProperty) {
            RDFProperty rdfProperty = (RDFProperty)slot;
            this.deleteDependingAnonymousClses(rdfProperty);
            if (rdfProperty.hasObjectRange()) {
                this.deleteAnonymousClses(rdfProperty.getPropertyValues(this.owlModel.getRDFSRangeProperty()));
            }
            Collection domain = slot.getDirectDomain();
            this.deleteAnonymousClses(domain);
            RDFResource range = rdfProperty.getRange();
            if (range instanceof RDFSDatatype && range.isAnonymous()) {
                range.delete();
            }
        }
        super.deleteSlot(slot);
    }

    private void ensureRDFSSubClassOfStatementsExistForNamedOperands(OWLIntersectionClass intersectionClass) {
        Collection superclasses = intersectionClass.getSuperclasses(false);
        if (superclasses.size() == 1) {
            RDFSNamedClass namedClass = (RDFSNamedClass)superclasses.iterator().next();
            RDFProperty scp = this.owlModel.getRDFSSubClassOfProperty();
            Iterator operands = intersectionClass.listOperands();
            while (operands.hasNext()) {
                RDFSClass operand = (RDFSClass)operands.next();
                if (!(operand instanceof RDFSNamedClass) || namedClass.getPropertyValues(scp).contains(operand)) continue;
                namedClass.addPropertyValue(scp, operand);
            }
        }
    }

    public Collection getClsesToDelete(Cls cls) {
        Set subclasses = this.getSubclasses(cls);
        HashSet<Cls> clsesToBeDeleted = new HashSet<Cls>(subclasses);
        clsesToBeDeleted.add(cls);
        for (Cls subclass : subclasses) {
            if (subclass.equals(cls) || !this.isReachableByAnotherRoute(subclass, clsesToBeDeleted)) continue;
            clsesToBeDeleted.remove(subclass);
            HashSet subsubclasses = new HashSet(this.getSubclasses(subclass));
            subsubclasses.remove(cls);
            clsesToBeDeleted.removeAll(subsubclasses);
        }
        return clsesToBeDeleted;
    }

    private DeleteSimplificationFrameStore getDeleteSimplificationFrameStore() {
        for (FrameStore frameStore : this.owlModel.getFrameStores()) {
            if (!(frameStore instanceof DeleteSimplificationFrameStore)) continue;
            return (DeleteSimplificationFrameStore)frameStore;
        }
        return null;
    }

    public List getDirectOwnSlotValuesConverting(Frame frame, Slot slot) {
        List values = super.getDirectOwnSlotValues(frame, slot);
        if (!values.isEmpty() && frame instanceof RDFResource && slot instanceof RDFProperty) {
            for (Object o : values) {
                if (!(o instanceof String) || !DefaultRDFSLiteral.isRawValue((String)o)) continue;
                return this.convertInternalFormatToRDFSLiterals(values);
            }
        }
        return values;
    }

    public List getPropertyValueLiterals(RDFResource frame, RDFProperty slot) {
        ArrayList values = new ArrayList(OWLUtil.getPropertyValues(frame, slot, false));
        if (!values.isEmpty()) {
            return this.getLiteralValues(values);
        }
        return values;
    }

    public List getLiteralValues(List values) {
        ArrayList result = new ArrayList();
        for (Object o : values) {
            if (o instanceof RDFSLiteral) {
                result.add(o);
                continue;
            }
            result.add(this.owlModel.createRDFSLiteral(o));
        }
        return result;
    }

    public Collection getOwnSlotValuesConverting(Frame frame, Slot slot) {
        Collection values = super.getOwnSlotValues(frame, slot);
        return this.getConvertedValues(values);
    }

    public Collection getConvertedValues(Collection values) {
        if (!values.isEmpty()) {
            for (Object o : values) {
                if (!(o instanceof String) || !DefaultRDFSLiteral.isRawValue((String)o)) continue;
                return this.convertInternalFormatToRDFSLiterals(values);
            }
        }
        return values;
    }

    public Set getClsesWithMatchingBrowserText(String value, Collection superclasses, int maxMatches) {
        HashSet results = new HashSet();
        results.addAll(super.getClsesWithMatchingBrowserText(value, superclasses, maxMatches));
        if (OWLFrameStore.isIgnorePrefixesInSearch(this.owlModel)) {
            for (String prefix : this.owlModel.getNamespaceManager().getPrefixes()) {
                results.addAll(super.getClsesWithMatchingBrowserText(String.valueOf(prefix) + ":" + value, superclasses, maxMatches));
            }
        }
        return results;
    }

    public Set getFramesWithMatchingDirectOwnSlotValue(Slot slot, String value, int maxMatches) {
        Set results = super.getFramesWithMatchingDirectOwnSlotValue(slot, value, maxMatches);
        if (OWLFrameStore.isIgnorePrefixesInSearch(this.owlModel)) {
            for (String prefix : this.owlModel.getNamespaceManager().getPrefixes()) {
                results.addAll(super.getFramesWithMatchingDirectOwnSlotValue(slot, String.valueOf(prefix) + ":" + value, maxMatches));
            }
        }
        return results;
    }

    public Set getMatchingReferences(String value, int maxMatches) {
        HashSet results = new HashSet();
        results.addAll(super.getMatchingReferences(value, maxMatches));
        if (OWLFrameStore.isIgnorePrefixesInSearch(this.owlModel)) {
            for (String prefix : this.owlModel.getNamespaceManager().getPrefixes()) {
                results.addAll(super.getMatchingReferences(String.valueOf(prefix) + ":" + value, maxMatches));
            }
        }
        return results;
    }

    private Collection getSlotsToDelete(Slot slot) {
        DeleteSimplificationFrameStore fs = this.getDeleteSimplificationFrameStore();
        return fs.getSlotsToDelete(slot);
    }

    private void initRestrictionUpdaters() {
        this.allValuesFromRestrictionUpdater = new AllValuesFromRestrictionUpdater(this.owlModel);
        this.cardinalityRestrictionUpdater = new CardinalityRestrictionUpdater(this.owlModel);
        this.hasValueRestrictionUpdater = new HasValueRestrictionUpdater(this.owlModel);
        this.facet2Updater.put(this.owlModel.getFacet(":VALUE-TYPE"), this.allValuesFromRestrictionUpdater);
        this.facet2Updater.put(this.owlModel.getFacet(":MAXIMUM-CARDINALITY"), this.cardinalityRestrictionUpdater);
        this.facet2Updater.put(this.owlModel.getFacet(":MINIMUM-CARDINALITY"), this.cardinalityRestrictionUpdater);
        this.facet2Updater.put(this.owlModel.getFacet(":VALUES"), this.hasValueRestrictionUpdater);
        this.class2Updater.put(DefaultOWLAllValuesFrom.class, this.allValuesFromRestrictionUpdater);
        this.class2Updater.put(DefaultOWLCardinality.class, this.cardinalityRestrictionUpdater);
        this.class2Updater.put(DefaultOWLHasValue.class, this.hasValueRestrictionUpdater);
        this.class2Updater.put(DefaultOWLMaxCardinality.class, this.cardinalityRestrictionUpdater);
        this.class2Updater.put(DefaultOWLMinCardinality.class, this.cardinalityRestrictionUpdater);
    }

    public static boolean isIgnorePrefixesInSearch(OWLModel owlModel) {
        return Boolean.TRUE.equals(owlModel.getOWLProject().getSettingsMap().getBoolean(IGNORE_PREFIXES_IN_SEARCH));
    }

    private boolean isReachableByAnotherRoute(Cls subclass, Collection classesToBeDeleted) {
        ArrayList superclasses = new ArrayList(this.getDirectSuperclasses(subclass));
        superclasses.remove(this.owlModel.getAnonymousRootCls());
        if (superclasses.size() > 1) {
            for (Cls superCls : superclasses) {
                if (!(superCls instanceof RDFSNamedClass) || classesToBeDeleted.contains(superCls)) continue;
                return true;
            }
        }
        return false;
    }

    private static void log(String str) {
    }

    public void removeDirectSuperclass(Cls cls, Cls superCls) {
        boolean wasEquivalentCls = superCls.hasDirectSuperclass(cls);
        super.removeDirectSuperclass(cls, superCls);
        if (cls instanceof OWLNamedClass && superCls instanceof OWLIntersectionClass && wasEquivalentCls) {
            this.removeNamedOperandsFromDirectSuperclasses((OWLNamedClass)cls, (OWLIntersectionClass)superCls, this.owlModel.getSlot(":DIRECT-SUPERCLASSES"));
        } else if (superCls instanceof OWLNamedClass && cls instanceof OWLIntersectionClass && wasEquivalentCls) {
            this.removeNamedOperandsFromDirectSuperclasses((OWLNamedClass)superCls, (OWLIntersectionClass)cls, this.owlModel.getSlot(":DIRECT-SUBCLASSES"));
        }
        if (!this.superclassHandlingBlocked && cls instanceof OWLNamedClass && superCls instanceof OWLRestriction) {
            this.copyFacetValuesIntoOWLNamedClass((OWLNamedClass)cls, (OWLRestriction)superCls);
        }
        if (superCls instanceof OWLAnonymousClass && autoDeleteOfAnonymousClses) {
            superCls.delete();
        }
        if (cls instanceof RDFSNamedClass) {
            this.updateRDFSSubClassOf((RDFSNamedClass)cls);
        } else if (superCls instanceof RDFSNamedClass) {
            this.updateRDFSSubClassOf((RDFSNamedClass)superCls);
        }
    }

    public void removeDirectSuperslot(Slot slot, Slot superslot) {
        super.removeDirectSuperslot(slot, superslot);
        if (slot instanceof OWLObjectProperty && slot.getDirectSuperslotCount() == 0 && slot.getAllowedClses().isEmpty()) {
            slot.setValueType(ValueType.INSTANCE);
        }
        if (slot instanceof RDFProperty && slot.getDirectDomain().isEmpty() && slot.getDirectSuperslotCount() == 0) {
            this.owlModel.getOWLThingClass().addDirectTemplateSlot(slot);
        }
    }

    public void removeDirectType(Instance instance, Cls directType) {
        if (instance instanceof RDFProperty && directType.equals(this.owlModel.getOWLFunctionalPropertyClass())) {
            ((Slot)instance).setAllowsMultipleValues(true);
        }
        if (instance instanceof RDFResource) {
            instance.removeOwnSlotValue((Slot)this.owlModel.getRDFTypeProperty(), (Object)directType);
        }
        super.removeDirectType(instance, directType);
    }

    private void removeNamedOperandsFromDirectSuperclasses(OWLNamedClass cls, OWLIntersectionClass intersectionCls, Slot slot) {
        Collection toRemove = intersectionCls.getNamedOperands();
        if (!toRemove.isEmpty()) {
            for (RDFSClass superClass : cls.getDirectOwnSlotValues(slot)) {
                if (!(superClass instanceof OWLIntersectionClass)) continue;
                toRemove.removeAll(((OWLIntersectionClass)superClass).getNamedOperands());
            }
            for (RDFSNamedClass namedCls : toRemove) {
                if (namedCls.hasEquivalentClass(cls)) continue;
                cls.removeSuperclass(namedCls);
            }
        }
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection values) {
        List oldValues;
        int valueCount = values.size();
        if (valueCount > 0) {
            for (Object o : values) {
                if (!(o instanceof RDFSLiteral)) continue;
                values = this.convertRDFSLiteralsToInternalFormat(values);
                break;
            }
        }
        if (!allowDuplicateOwnSlotValues && valueCount > 1 && valueCount != new HashSet(values).size()) {
            System.err.println("[OWLFrameStore] Warning: Attempted to assign duplicate value to " + frame.getBrowserText() + "." + slot.getBrowserText());
            for (Object o : values) {
                System.err.println("[OWLFrameStore]  - " + o);
            }
            values = new HashSet(values);
        }
        if (frame instanceof RDFProperty && slot.equals(this.owlModel.getRDFSRangeProperty())) {
            oldValues = frame.getDirectOwnSlotValues(slot);
            if (values.size() > 0 && values.iterator().next() instanceof RDFSClass) {
                this.updatePropertyAllowedClasses((RDFProperty)frame, values);
            } else {
                this.updatePropertyValueType((RDFProperty)frame, values);
            }
            super.setDirectOwnSlotValues(frame, slot, (Collection)values);
            this.deleteAnonymousClasses(oldValues, values);
        } else if (frame instanceof RDFProperty && slot.equals(this.owlModel.getRDFSDomainProperty())) {
            if (values.size() > 1 && values.contains(this.owlModel.getOWLThingClass())) {
                values = new ArrayList(values);
                values.remove(this.owlModel.getOWLThingClass());
            }
            oldValues = frame.getDirectOwnSlotValues(slot);
            super.setDirectOwnSlotValues(frame, slot, (Collection)values);
            if (!this.suppressUpdateTemplateSlots) {
                this.updateSlotDomain((Slot)frame, values);
            }
            this.deleteAnonymousClasses(oldValues, values);
        } else {
            super.setDirectOwnSlotValues(frame, slot, (Collection)values);
        }
    }

    public void setSuperclassSynchronizationBlocked(boolean value) {
        this.superclassSynchronizationBlocked = value;
    }

    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        super.addDirectTemplateSlot(cls, slot);
        if (!this.suppressUpdateRDFSDomain && slot instanceof RDFProperty && cls instanceof RDFSClass) {
            this.updateRDFSDomain((RDFProperty)slot);
        }
    }

    private void printDeprecationWarning(String methodName) {
        System.out.println("Warning: The method " + methodName + " is not recommended in OWL.");
        System.out.println("         Please use the rdfs:domain methods in RDFProperty.");
        System.out.println("         The following stack trace helps you replace your code.");
        System.out.println("         This message may be deleted in future versions.");
        try {
            throw new Exception();
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            return;
        }
    }

    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        super.removeDirectTemplateSlot(cls, slot);
        if (!this.suppressUpdateRDFSDomain && slot instanceof RDFProperty && cls instanceof RDFSClass) {
            this.updateRDFSDomain((RDFProperty)slot);
        }
    }

    private void updateRDFSDomain(RDFProperty property) {
        Collection domainClses = property.getDirectDomain();
        RDFSClass newDomain = null;
        newDomain = domainClses.size() == 1 ? (RDFSClass)domainClses.iterator().next() : this.owlModel.createOWLUnionClass(domainClses);
        this.suppressUpdateTemplateSlots = true;
        property.setDomain(newDomain);
        this.suppressUpdateTemplateSlots = false;
    }

    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection values) {
        super.setDirectTemplateFacetValues(cls, slot, facet, values);
        if (!this.facetHandlingBlocked && cls instanceof OWLNamedClass && slot instanceof RDFProperty) {
            this.updateRestrictions((OWLNamedClass)cls, (RDFProperty)slot, facet);
        }
        if (!this.superclassHandlingBlocked && cls instanceof OWLRestriction) {
            OWLRestriction restriction = (OWLRestriction)cls;
            this.copyFacetValuesIntoOWLNamedClass(restriction);
        }
    }

    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection values) {
        super.setDirectTemplateSlotValues(cls, slot, values);
        if (!this.facetHandlingBlocked && cls instanceof OWLNamedClass && slot instanceof RDFProperty) {
            this.updateRestrictions((OWLNamedClass)cls, (RDFProperty)slot, this.owlModel.getFacet(":VALUES"));
        }
    }

    private void updatePropertyAllowedClasses(RDFProperty property, Collection values) {
        property.setValueType(ValueType.INSTANCE);
        RDFSClass rangeClass = (RDFSClass)values.iterator().next();
        if (rangeClass instanceof OWLUnionClass) {
            property.setAllowedClses(((OWLUnionClass)rangeClass).getOperands());
        } else {
            property.setAllowedClses(Collections.singleton(rangeClass));
        }
    }

    private void updatePropertyValueType(RDFProperty property, Collection values) {
        ValueType newValueType = ValueType.ANY;
        if (property instanceof OWLObjectProperty && property.getSuperpropertyCount() == 0) {
            newValueType = ValueType.INSTANCE;
        }
        if (!values.isEmpty()) {
            RDFSDatatype datatype;
            Object range = values.iterator().next();
            if (range instanceof RDFSDatatype) {
                newValueType = XMLSchemaDatatypes.getValueType(((RDFSDatatype)range).getURI());
            } else if (range instanceof RDFSClass) {
                newValueType = ValueType.INSTANCE;
            } else if (range instanceof OWLDataRange && (datatype = ((OWLDataRange)range).getRDFDatatype()) != null) {
                newValueType = XMLSchemaDatatypes.getValueType(datatype.getURI());
            }
        }
        if (newValueType != property.getValueType()) {
            property.setValueType(newValueType);
        }
        if (newValueType == ValueType.INSTANCE) {
            property.setAllowedClses(Collections.EMPTY_LIST);
        }
    }

    private void updateRestrictions(OWLNamedClass cls, RDFProperty slot, Facet facet) {
        RestrictionUpdater ru = (RestrictionUpdater)this.facet2Updater.get(facet);
        if (ru != null) {
            this.superclassHandlingBlocked = true;
            ru.updateRestrictions(cls, slot, facet);
            this.superclassHandlingBlocked = false;
        }
    }

    private void updateRDFSSubClassOf(RDFSNamedClass cls) {
        Slot directSuperclassesSlot = this.owlModel.getSlot(":DIRECT-SUPERCLASSES");
        RDFProperty rdfsSubClassOfProperty = this.owlModel.getRDFSSubClassOfProperty();
        RDFProperty owlEquivalentClassProperty = this.owlModel.getOWLEquivalentClassProperty();
        HashSet oldSuperclasses = new HashSet(cls.getPropertyValues(rdfsSubClassOfProperty));
        HashSet oldEquivalentClasses = new HashSet(cls.getPropertyValues(owlEquivalentClassProperty));
        ArrayList<Cls> newSuperclasses = new ArrayList<Cls>();
        ArrayList<Cls> newEquivalentClasses = new ArrayList<Cls>();
        for (Cls superClass : cls.getDirectSuperclasses()) {
            TripleStore ts;
            if (!(superClass instanceof RDFSClass)) continue;
            if (superClass.hasDirectSuperclass((Cls)cls)) {
                newEquivalentClasses.add(superClass);
                if (!oldEquivalentClasses.contains(superClass)) {
                    ts = TripleStoreUtil.getTripleStoreOf(cls, directSuperclassesSlot, superClass);
                    TripleStoreUtil.addToTripleStore(this.owlModel, ts, cls, owlEquivalentClassProperty, superClass);
                }
                if (!(superClass instanceof RDFSNamedClass)) continue;
                newSuperclasses.add(superClass);
                if (oldSuperclasses.contains(superClass)) continue;
                ts = TripleStoreUtil.getTripleStoreOf(cls, directSuperclassesSlot, superClass);
                TripleStoreUtil.addToTripleStore(this.owlModel, ts, cls, rdfsSubClassOfProperty, superClass);
                continue;
            }
            newSuperclasses.add(superClass);
            if (oldSuperclasses.contains(superClass)) continue;
            ts = TripleStoreUtil.getTripleStoreOf(cls, directSuperclassesSlot, superClass);
            TripleStoreUtil.addToTripleStore(this.owlModel, ts, cls, rdfsSubClassOfProperty, superClass);
        }
        oldSuperclasses.removeAll(newSuperclasses);
        for (RDFSClass oldSuperclass : oldSuperclasses) {
            cls.removePropertyValue(rdfsSubClassOfProperty, oldSuperclass);
        }
        oldEquivalentClasses.removeAll(newEquivalentClasses);
        for (RDFSClass oldEquivalentClass : oldEquivalentClasses) {
            cls.removePropertyValue(owlEquivalentClassProperty, oldEquivalentClass);
        }
    }

    private void updateSlotDomain(Slot slot, Collection values) {
        this.suppressUpdateRDFSDomain = true;
        ArrayList<RDFSClass> clses = new ArrayList<RDFSClass>();
        if (values.size() == 1) {
            RDFSClass cls = (RDFSClass)values.iterator().next();
            if (cls instanceof OWLUnionClass) {
                clses.addAll(((OWLUnionClass)cls).getOperands());
            } else {
                clses.add(cls);
            }
        }
        for (Cls oldDomainCls : new ArrayList(slot.getDirectDomain())) {
            if (clses.contains(oldDomainCls)) continue;
            oldDomainCls.removeDirectTemplateSlot(slot);
        }
        ArrayList oldDomain = new ArrayList(slot.getDirectDomain());
        for (Cls cls : clses) {
            if (oldDomain.contains(cls)) continue;
            cls.addDirectTemplateSlot(slot);
        }
        this.suppressUpdateRDFSDomain = false;
    }
}

