/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLLogicalClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFList;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AbstractOWLNAryLogicalClass
extends AbstractOWLLogicalClass
implements OWLNAryLogicalClass {
    protected AbstractOWLNAryLogicalClass(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    protected AbstractOWLNAryLogicalClass() {
    }

    public void addOperand(RDFSClass operand) {
        RDFList list = (RDFList)this.getPropertyValue(this.getOperandsProperty());
        if (list == null || this.getOWLModel().getRDFNil().equals(list)) {
            list = this.getOWLModel().createRDFList();
            this.setOwnSlotValue(this.getOperandsProperty(), list);
        }
        list.append(operand);
    }

    public boolean equalsStructurally(RDFObject object) {
        if (object instanceof AbstractOWLNAryLogicalClass) {
            AbstractOWLNAryLogicalClass compCls = (AbstractOWLNAryLogicalClass)object;
            if (this.getOperatorSymbol() == compCls.getOperatorSymbol()) {
                return OWLUtil.equalsStructurally(this.getOperands(), compCls.getOperands());
            }
        }
        return false;
    }

    public Collection getNamedOperands() {
        HashSet<RDFSClass> result = new HashSet<RDFSClass>();
        for (RDFSClass operand : this.getOperands()) {
            if (!(operand instanceof RDFSNamedClass)) continue;
            result.add(operand);
        }
        return result;
    }

    public String getNestedBrowserText() {
        return "(" + this.getBrowserText() + ")";
    }

    public Collection getOperands() {
        RDFList list = (RDFList)this.getPropertyValue(this.getOperandsProperty());
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list.getValues();
    }

    public boolean hasOperandWithBrowserText(String browserText) {
        for (RDFSClass operand : this.getOperands()) {
            if (!browserText.equals(operand.getBrowserText())) continue;
            return true;
        }
        return false;
    }

    public boolean hasSameOperands(OWLNAryLogicalClass other) {
        HashSet<String> setA = new HashSet<String>();
        for (RDFSClass operand : this.getOperands()) {
            setA.add(operand.getBrowserText());
        }
        HashSet<String> setB = new HashSet<String>();
        for (RDFSClass operand : other.getOperands()) {
            setB.add(operand.getBrowserText());
        }
        if (setA.size() == setB.size()) {
            setA.removeAll(setB);
            return setA.isEmpty();
        }
        return false;
    }

    public Iterator listOperands() {
        return this.getOperands().iterator();
    }

    public void removeOperand(RDFSClass operand) {
        DefaultRDFList.removeListValue(this, this.getOperandsProperty(), operand);
    }
}

