/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DefaultOWLNamedClass
extends DefaultRDFSNamedClass
implements OWLNamedClass {
    public DefaultOWLNamedClass(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    public DefaultOWLNamedClass() {
    }

    public void addDisjointClass(RDFSClass aClass) {
        RDFProperty disjointClassesSlot = this.getOWLModel().getOWLDisjointWithProperty();
        this.addOwnSlotValue(disjointClassesSlot, aClass);
    }

    public void addEquivalentClass(RDFSClass aClass) {
        if (!this.hasDirectSuperclass(aClass)) {
            this.addDirectSuperclass(aClass);
        }
        if (!aClass.isSubclassOf(this)) {
            aClass.addSuperclass(this);
        }
    }

    public void addInferredSuperclass(RDFSClass superclass) {
        RDFProperty superclassesSlot = this.getAbstractOWLModel().getProtegeInferredSuperclassesProperty();
        this.addOwnSlotValue(superclassesSlot, superclass);
        if (superclass instanceof OWLNamedClass) {
            RDFProperty subclassesSlot = this.getAbstractOWLModel().getProtegeInferredSubclassesProperty();
            superclass.addOwnSlotValue(subclassesSlot, this);
        }
    }

    public OWLIndividual createOWLIndividual(String name) {
        return (OWLIndividual)this.createInstance(name);
    }

    public boolean equalsStructurally(RDFSClass cls) {
        return this.getName().equals(cls.getName());
    }

    public RDFResource getAllValuesFrom(RDFProperty property) {
        Collection restrictions = this.getRestrictions(property, true);
        for (OWLRestriction restriction : restrictions) {
            if (!(restriction instanceof OWLAllValuesFrom)) continue;
            return ((OWLAllValuesFrom)restriction).getAllValuesFrom();
        }
        return property.getRange();
    }

    public Set getAssociatedProperties() {
        Set set = super.getAssociatedProperties();
        HashSet<Object> maxZeroProperties = new HashSet<Object>();
        for (OWLRestriction restriction : this.getRestrictions(true)) {
            RDFProperty property = restriction.getOnProperty();
            if ((restriction instanceof OWLCardinality || restriction instanceof OWLMaxCardinality) && ((OWLCardinalityBase)restriction).getCardinality() == 0) {
                maxZeroProperties.add(property);
                maxZeroProperties.add(property.getSubproperties(true));
                continue;
            }
            set.add(property);
            set.addAll(property.getSubproperties(true));
        }
        set.removeAll(maxZeroProperties);
        return set;
    }

    public int getClassificationStatus() {
        RDFProperty slot = this.getAbstractOWLModel().getProtegeClassificationStatusProperty();
        List values = this.getDirectOwnSlotValues(slot);
        if (values.size() == 0) {
            return 0;
        }
        return (Integer)values.iterator().next();
    }

    public Collection getDirectRestrictions() {
        ArrayList result = new ArrayList();
        this.getDirectRestrictions(result, this.getDirectSuperclasses().iterator());
        return result;
    }

    public Object getHasValue(RDFProperty property) {
        for (OWLRestriction restriction : this.getRestrictions(property, true)) {
            if (!(restriction instanceof OWLHasValue)) continue;
            OWLHasValue hasValue = (OWLHasValue)restriction;
            return hasValue.getHasValue();
        }
        return null;
    }

    public Collection getInferredEquivalentClasses() {
        HashSet<Cls> result = new HashSet<Cls>();
        for (Cls superCls : this.getInferredSuperclasses()) {
            if (!this.getInferredSubclasses().contains(superCls)) continue;
            result.add(superCls);
        }
        return result;
    }

    private void getDirectRestrictions(Collection results, Iterator clses) {
        while (clses.hasNext()) {
            Cls cls = (Cls)clses.next();
            if (cls instanceof OWLRestriction) {
                results.add(cls);
                continue;
            }
            if (!(cls instanceof OWLIntersectionClass)) continue;
            OWLIntersectionClass logicalCls = (OWLIntersectionClass)cls;
            this.getDirectRestrictions(results, logicalCls.getOperands().iterator());
        }
    }

    public Collection getInferredSubclasses() {
        RDFProperty slot = this.getAbstractOWLModel().getProtegeInferredSubclassesProperty();
        return this.getDirectOwnSlotValues(slot);
    }

    public Collection getInferredSuperclasses() {
        RDFProperty slot = this.getAbstractOWLModel().getProtegeInferredSuperclassesProperty();
        return this.getDirectOwnSlotValues(slot);
    }

    public int getMaxCardinality(RDFProperty property) {
        if (property.isFunctional()) {
            return 1;
        }
        Collection restrictions = this.getRestrictions(property, true);
        for (OWLRestriction restriction : restrictions) {
            OWLCardinalityBase base;
            if (!(restriction instanceof OWLCardinalityBase) || (base = (OWLCardinalityBase)restriction).isQualified()) continue;
            if (restriction instanceof OWLMaxCardinality) {
                return ((OWLMaxCardinality)restriction).getCardinality();
            }
            if (!(restriction instanceof OWLCardinality)) continue;
            return ((OWLCardinality)restriction).getCardinality();
        }
        return -1;
    }

    public int getMinCardinality(RDFProperty property) {
        Collection restrictions = this.getRestrictions(property, true);
        for (OWLRestriction restriction : restrictions) {
            if (restriction instanceof OWLMinCardinality) {
                return ((OWLMinCardinality)restriction).getCardinality();
            }
            if (!(restriction instanceof OWLCardinality)) continue;
            return ((OWLCardinality)restriction).getCardinality();
        }
        return 0;
    }

    public Collection getRestrictions() {
        return this.getRestrictions(false);
    }

    public Icon getIcon() {
        if (!this.getOWLModel().getProject().isMultiUserClient() && this.isMetaCls()) {
            return super.getIcon();
        }
        ImageIcon ii = this.getImageIconForNonMetaclass();
        if (this.isEditable()) {
            return ii;
        }
        return OWLIcons.getReadOnlyClsIcon(ii);
    }

    public String getIconName() {
        if (this.isMetaclass()) {
            return super.getIconName();
        }
        return this.getImageIconNameForNonMetaclass();
    }

    public ImageIcon getImageIcon() {
        if (this.isMetaCls()) {
            return super.getImageIcon();
        }
        return this.getImageIconForNonMetaclass();
    }

    private ImageIcon getImageIconForNonMetaclass() {
        String str = this.getImageIconNameForNonMetaclass();
        return OWLIcons.getImageIcon(str);
    }

    private String getImageIconNameForNonMetaclass() {
        String str = null;
        str = this.getPropertyValueCount(this.getOWLModel().getOWLEquivalentClassProperty()) == 0 ? "PrimitiveClass" : "DefinedOWLClass";
        if (!this.getOWLModel().getProject().isMultiUserClient()) {
            if (!this.isConsistent()) {
                str = String.valueOf(str) + "Inconsistent";
            }
            if (this.getSubclassesDisjoint()) {
                str = String.valueOf(str) + "SD";
            }
        }
        return str;
    }

    public Collection getRestrictions(boolean includingSuperclassRestrictions) {
        if (includingSuperclassRestrictions) {
            HashSet reached = new HashSet();
            ArrayList restrictions = new ArrayList();
            DefaultOWLNamedClass.getRestrictions(this, reached, restrictions);
            return restrictions;
        }
        return this.getDirectRestrictions();
    }

    public Collection getRestrictions(RDFProperty property, boolean includingSuperclassRestrictions) {
        ArrayList<OWLRestriction> result = new ArrayList<OWLRestriction>();
        Collection rs = this.getRestrictions(includingSuperclassRestrictions);
        for (OWLRestriction restriction : rs) {
            if (!property.equals(restriction.getOnProperty())) continue;
            result.add(restriction);
        }
        return result;
    }

    private static void getRestrictions(OWLNamedClass cls, Set reached, Collection results) {
        reached.add(cls);
        Collection restrictions = cls.getRestrictions(false);
        for (OWLRestriction restriction : restrictions) {
            if (restriction instanceof OWLAllValuesFrom) {
                if (DefaultOWLNamedClass.isOverloadedAllValuesFrom((OWLAllValuesFrom)restriction, results)) continue;
                results.add(restriction);
                continue;
            }
            if (restriction instanceof OWLMinCardinality) {
                if (DefaultOWLNamedClass.isOverloadedMinCardinality((OWLMinCardinality)restriction, results)) continue;
                results.add(restriction);
                continue;
            }
            if (restriction instanceof OWLMaxCardinality) {
                if (DefaultOWLNamedClass.isOverloadedMaxCardinality((OWLMaxCardinality)restriction, results)) continue;
                results.add(restriction);
                continue;
            }
            if (restriction instanceof OWLCardinality) {
                if (DefaultOWLNamedClass.isOverloadedCardinality((OWLCardinality)restriction, results)) continue;
                results.add(restriction);
                continue;
            }
            results.add(restriction);
        }
        for (RDFSNamedClass superclass : cls.getNamedSuperclasses()) {
            if (!(superclass instanceof OWLNamedClass) || reached.contains(superclass)) continue;
            DefaultOWLNamedClass.getRestrictions((OWLNamedClass)superclass, reached, results);
        }
    }

    public RDFResource getSomeValuesFrom(RDFProperty property) {
        Collection restrictions = this.getRestrictions(property, true);
        for (OWLRestriction restriction : restrictions) {
            if (!(restriction instanceof OWLSomeValuesFrom)) continue;
            return ((OWLSomeValuesFrom)restriction).getSomeValuesFrom();
        }
        return null;
    }

    public boolean isConsistent() {
        return !this.getInferredSuperclasses().contains(this.getOWLModel().getOWLNothing());
    }

    private static boolean isOverloadedAllValuesFrom(OWLAllValuesFrom restriction, Collection restrictions) {
        RDFProperty property = restriction.getOnProperty();
        for (OWLRestriction owlRestriction : restrictions) {
            if (!(owlRestriction instanceof OWLAllValuesFrom) || !owlRestriction.getOnProperty().equals(property)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOverloadedCardinality(OWLCardinality restriction, Collection restrictions) {
        RDFProperty property = restriction.getOnProperty();
        for (OWLRestriction owlRestriction : restrictions) {
            if (!property.equals(owlRestriction.getOnProperty()) || !(owlRestriction instanceof OWLCardinality)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOverloadedMaxCardinality(OWLMaxCardinality restriction, Collection restrictions) {
        RDFProperty property = restriction.getOnProperty();
        for (OWLRestriction owlRestriction : restrictions) {
            if (!property.equals(owlRestriction.getOnProperty()) || !(owlRestriction instanceof OWLCardinality) && !(owlRestriction instanceof OWLMaxCardinality)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOverloadedMinCardinality(OWLMinCardinality restriction, Collection restrictions) {
        RDFProperty property = restriction.getOnProperty();
        for (OWLRestriction owlRestriction : restrictions) {
            if (!property.equals(owlRestriction.getOnProperty()) || !(owlRestriction instanceof OWLCardinality) && !(owlRestriction instanceof OWLMinCardinality)) continue;
            return true;
        }
        return false;
    }

    public boolean getSubclassesDisjoint() {
        Object value;
        RDFProperty slot = this.getOWLModel().getProtegeSubclassesDisjointProperty();
        if (slot != null && (value = this.getDirectOwnSlotValue(slot)) instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public boolean hasNamedSuperclass() {
        return this.getNamedSuperclasses().size() > 0;
    }

    public boolean isDefinedClass() {
        return this.getDefinition() != null;
    }

    public boolean isFunctionalProperty(RDFProperty property) {
        int max = this.getMaxCardinality(property);
        return max == 0 || max == 1;
    }

    public boolean hasNamedSuperClass() {
        return this.hasNamedSuperclass();
    }

    public boolean isProbeClass() {
        Slot slot = this.getKnowledgeBase().getSlot(ProtegeNames.getProbeClassSlotName());
        if (slot instanceof OWLDatatypeProperty) {
            return Boolean.TRUE.equals(this.getDirectOwnSlotValue(slot));
        }
        return false;
    }

    public void removeDisjointClass(RDFSClass aClass) {
        RDFProperty disjointClassesSlot = this.getOWLModel().getOWLDisjointWithProperty();
        this.removeOwnSlotValue(disjointClassesSlot, aClass);
        if (aClass.isAnonymous()) {
            this.getKnowledgeBase().deleteCls((Cls)aClass);
        }
    }

    public void removeEquivalentClass(RDFSClass equivalentClass) {
        if (equivalentClass instanceof OWLAnonymousClass) {
            this.removeDirectSuperclass(equivalentClass);
        } else {
            this.removeDirectSuperclass(equivalentClass);
            equivalentClass.removeSuperclass(this);
        }
    }

    public void removeInferredSuperclass(RDFSClass superclass) {
        RDFProperty superclassesSlot = this.getAbstractOWLModel().getProtegeInferredSuperclassesProperty();
        RDFProperty subclassesSlot = this.getAbstractOWLModel().getProtegeInferredSubclassesProperty();
        this.removeOwnSlotValue(superclassesSlot, superclass);
        superclass.removeOwnSlotValue(subclassesSlot, this);
    }

    public void setClassificationStatus(int value) {
        if (value != this.getClassificationStatus()) {
            RDFProperty slot = this.getAbstractOWLModel().getProtegeClassificationStatusProperty();
            this.setOwnSlotValue(slot, new Integer(value));
        }
    }

    public void setDefinition(RDFSClass definingClass) {
        for (RDFSClass cls : this.getEquivalentClasses()) {
            this.removeEquivalentClass(cls);
        }
        if (definingClass != null) {
            this.addEquivalentClass(definingClass);
        }
        if (!this.hasNamedSuperClass()) {
            this.addDirectSuperclass(this.getKnowledgeBase().getRootCls());
        }
    }

    public void setSubclassesDisjoint(boolean value) {
        RDFProperty slot = this.getOWLModel().getProtegeSubclassesDisjointProperty();
        if (slot == null) {
            throw new RuntimeException("Could not find slot " + ProtegeNames.getSubclassesDisjointSlotName());
        }
        if (value) {
            this.setDirectOwnSlotValue(slot, Boolean.TRUE);
            OWLUtil.ensureSubclassesDisjoint(this);
        } else {
            this.setDirectOwnSlotValues(slot, Collections.EMPTY_LIST);
            OWLUtil.removeSubclassesDisjoint(this);
        }
    }

    public void accept(OWLModelVisitor visitor) {
        visitor.visitOWLNamedClass(this);
    }
}

