/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultSlot;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DefaultRDFProperty
extends DefaultSlot
implements RDFProperty {
    public DefaultRDFProperty(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    public DefaultRDFProperty() {
    }

    public void addPropertyListener(PropertyListener listener) {
        if (!(listener instanceof PropertyAdapter)) {
            throw new IllegalArgumentException("Listener must be subclass of PropertyAdapter");
        }
        this.addSlotListener(listener);
    }

    public void addSuperproperty(RDFProperty superProperty) {
        this.getKnowledgeBase().addDirectSuperslot((Slot)this, (Slot)superProperty);
    }

    public void addEquivalentProperty(RDFProperty property) {
        RDFProperty equivalentClassesSlot = this.getOWLModel().getOWLEquivalentPropertyProperty();
        this.addOwnSlotValue(equivalentClassesSlot, property);
    }

    public void addUnionDomainClass(RDFSClass domainClass) {
        Collection directDomain = this.getDirectDomain();
        if (directDomain.isEmpty()) {
            this.setDomain(domainClass);
        } else {
            OWLUnionClass unionClass = this.getOWLModel().createOWLUnionClass(directDomain);
            unionClass.addOperand(domainClass);
            this.setDomain(unionClass);
        }
    }

    public boolean equalsStructurally(RDFObject object) {
        return this.equals(object);
    }

    public ImageIcon getBaseImageIcon() {
        return OWLIcons.getImageIcon("RDFProperty");
    }

    public RDFSClass getDomain(boolean includingSuperproperties) {
        Collection domains = this.getDomains(includingSuperproperties);
        if (domains.isEmpty()) {
            return null;
        }
        return (RDFSClass)domains.iterator().next();
    }

    public Collection getDomains(boolean includingSuperproperties) {
        if (includingSuperproperties) {
            List values = this.getDirectOwnSlotValues(this.getOWLModel().getRDFSDomainProperty());
            if (values.isEmpty()) {
                ArrayList result = new ArrayList();
                for (RDFProperty superproperty : this.getSuperproperties(false)) {
                    Collection superDomains = superproperty.getDomains(true);
                    result.addAll(superDomains);
                }
                return result;
            }
            return values;
        }
        return this.getDirectOwnSlotValues(this.getOWLModel().getRDFSDomainProperty());
    }

    public Collection getEquivalentProperties() {
        RDFProperty equivalentClassesSlot = this.getOWLModel().getOWLEquivalentPropertyProperty();
        return this.getOwnSlotValues(equivalentClassesSlot);
    }

    public RDFProperty getFirstSuperproperty() {
        return (RDFProperty)this.getPropertyValue(this.getOWLModel().getRDFSSubPropertyOfProperty());
    }

    public Icon getInheritedIcon() {
        return OWLIcons.getImageIcon("RDFPropertyInherited");
    }

    public Icon getIcon() {
        if (this.isEditable()) {
            return this.getBaseImageIcon();
        }
        return OWLIcons.getReadOnlyPropertyIcon(OWLIcons.getImageIcon("RDFProperty"));
    }

    public String getIconName() {
        return "RDFProperty";
    }

    public RDFProperty getInverseProperty() {
        return (RDFProperty)this.getKnowledgeBase().getInverseSlot((Slot)this);
    }

    public RDFResource getRange() {
        return this.getRange(false);
    }

    public RDFResource getRange(boolean includingSuperproperties) {
        Object r = this.getPropertyValue(this.getOWLModel().getRDFSRangeProperty());
        if (r instanceof RDFResource) {
            return (RDFResource)r;
        }
        if (r == null && includingSuperproperties) {
            for (RDFProperty superproperty : this.getSuperproperties(false)) {
                RDFResource range = superproperty.getRange(true);
                if (range == null) continue;
                return range;
            }
        }
        return null;
    }

    public RDFSDatatype getRangeDatatype() {
        RDFResource range = this.getRange();
        if (range instanceof RDFSDatatype) {
            return (RDFSDatatype)range;
        }
        if (range instanceof OWLDataRange) {
            return ((OWLDataRange)range).getRDFDatatype();
        }
        return null;
    }

    public Collection getRanges(boolean includingSuperproperties) {
        Collection ranges = this.getPropertyValues(this.getOWLModel().getRDFSRangeProperty());
        if (ranges.isEmpty() && includingSuperproperties) {
            for (RDFProperty superproperty : this.getSuperproperties(false)) {
                ranges = superproperty.getRanges(true);
                if (ranges == null) continue;
                return ranges;
            }
        }
        return ranges;
    }

    public Collection getSubproperties(boolean transitive) {
        if (transitive) {
            return this.getKnowledgeBase().getSubslots((Slot)this);
        }
        return this.getKnowledgeBase().getDirectSubslots((Slot)this);
    }

    public int getSubpropertyCount() {
        return this.getKnowledgeBase().getDirectSubslotCount((Slot)this);
    }

    public Collection getSuperproperties(boolean transitive) {
        if (transitive) {
            return this.getKnowledgeBase().getSuperslots((Slot)this);
        }
        return this.getKnowledgeBase().getDirectSuperslots((Slot)this);
    }

    public int getSuperpropertyCount() {
        return this.getKnowledgeBase().getDirectSuperslotCount((Slot)this);
    }

    public Collection getUnionDomain() {
        return this.getKnowledgeBase().getDirectDomain((Slot)this);
    }

    public Collection getUnionDomain(boolean includingSuperproperties) {
        if (includingSuperproperties) {
            return this.getKnowledgeBase().getDomain((Slot)this);
        }
        return this.getKnowledgeBase().getDirectDomain((Slot)this);
    }

    public Collection getUnionRangeClasses() {
        return AbstractOWLModel.getRDFResources(this.getOWLModel(), this.getKnowledgeBase().getAllowedClses((Slot)this));
    }

    public boolean hasDatatypeRange() {
        RDFResource range = this.getRange(true);
        return range instanceof RDFSDatatype || range instanceof OWLDataRange;
    }

    public boolean hasObjectRange() {
        RDFResource range = this.getRange(true);
        return range instanceof RDFSClass;
    }

    public boolean hasRange(boolean includingSuperproperties) {
        Collection ranges = this.getRanges(includingSuperproperties);
        return !ranges.isEmpty();
    }

    public boolean isSubpropertyOf(RDFProperty superProperty, boolean transitive) {
        if (transitive) {
            return this.getKnowledgeBase().hasSuperslot((Slot)this, (Slot)superProperty);
        }
        return this.getKnowledgeBase().hasDirectSuperslot((Slot)this, (Slot)superProperty);
    }

    public boolean isAnnotationProperty() {
        return this.hasProtegeType(this.getOWLModel().getOWLAnnotationPropertyClass());
    }

    public boolean isDomainDefined() {
        if (this.getDirectOwnSlotValue(this.getKnowledgeBase().getSlot(":DIRECT-DOMAIN")) == null) {
            return this.getDirectSuperslotCount() == 0;
        }
        return !this.getKnowledgeBase().getRootCls().getDirectTemplateSlots().contains(this);
    }

    public boolean isDomainDefined(boolean transitive) {
        if (!transitive) {
            return this.isDomainDefined();
        }
        if (this.getDirectOwnSlotValue(this.getKnowledgeBase().getSlot(":DIRECT-DOMAIN")) == null) {
            if (this.getDirectSuperslotCount() == 0) {
                return false;
            }
            return this.isDomainDefined(new HashSet());
        }
        return !this.getKnowledgeBase().getRootCls().hasDirectTemplateSlot((Slot)this);
    }

    private boolean isDomainDefined(Set reached) {
        reached.add(this);
        if (this.getDirectOwnSlotValue(this.getKnowledgeBase().getSlot(":DIRECT-DOMAIN")) == null) {
            for (Slot superSlot : this.getDirectSuperslots()) {
                if (reached.contains(superSlot) || !(superSlot instanceof DefaultRDFProperty) || !((DefaultRDFProperty)superSlot).isDomainDefined(reached)) continue;
                return true;
            }
            return false;
        }
        return !this.getKnowledgeBase().getRootCls().hasDirectTemplateSlot((Slot)this);
    }

    public boolean isFunctional() {
        if (this.hasProtegeType(this.getOWLModel().getOWLFunctionalPropertyClass())) {
            return true;
        }
        for (RDFProperty property : this.getSuperproperties(false)) {
            if (!property.isFunctional()) continue;
            return true;
        }
        return false;
    }

    public boolean isRangeDefined() {
        return this.getDirectOwnSlotValue(this.getKnowledgeBase().getSlot(":SLOT-VALUE-TYPE")) != null;
    }

    public boolean isReadOnly() {
        OWLDatatypeProperty readOnlySlot = ((OWLModel)this.getKnowledgeBase()).getProtegeReadOnlyProperty();
        if (readOnlySlot != null) {
            Object value = this.getDirectOwnSlotValue(readOnlySlot);
            return Boolean.TRUE.equals(value);
        }
        return false;
    }

    public void removeEquivalentProperty(OWLProperty property) {
        RDFProperty equivalentClassesSlot = this.getOWLModel().getOWLEquivalentPropertyProperty();
        this.removeOwnSlotValue(equivalentClassesSlot, property);
    }

    public void removePropertyListener(PropertyListener listener) {
        if (!(listener instanceof PropertyAdapter)) {
            throw new IllegalArgumentException("Listener must be subclass of PropertyAdapter");
        }
        this.removeSlotListener(listener);
    }

    public void removeSuperproperty(RDFProperty property) {
        this.getKnowledgeBase().removeDirectSuperslot((Slot)this, (Slot)property);
    }

    public void removeUnionDomainClass(RDFSClass domainClass) {
        ArrayList directDomain = new ArrayList(this.getDirectDomain());
        directDomain.remove(domainClass);
        if (directDomain.isEmpty()) {
            OWLNamedClass owlThing = domainClass.getOWLModel().getOWLThingClass();
            if (domainClass != owlThing && this.getSuperpropertyCount() == 0) {
                this.setDomain(owlThing);
            } else {
                this.setDomain(null);
            }
        } else if (directDomain.size() == 1) {
            this.setDomain((RDFSClass)directDomain.iterator().next());
        } else {
            OWLUnionClass unionClass = this.getOWLModel().createOWLUnionClass(directDomain);
            this.setDomain(unionClass);
        }
    }

    public void setDomainDefined(boolean value) {
        if (value != this.isDomainDefined()) {
            if (value) {
                this.setDomain(null);
            } else if (this.getSuperpropertyCount() > 0) {
                this.setDomain(null);
            } else {
                this.setDomain(this.getOWLModel().getOWLThingClass());
            }
        } else if (!value && this.getSuperpropertyCount() > 0) {
            this.setDomain(null);
        }
    }

    public void setEquivalentProperties(Collection slots) {
        RDFProperty equivalentClassesSlot = this.getOWLModel().getOWLEquivalentPropertyProperty();
        this.setOwnSlotValues(equivalentClassesSlot, slots);
    }

    public void setFunctional(boolean value) {
        this.updateRDFType(value, this.getOWLModel().getOWLFunctionalPropertyClass());
    }

    public void setInverseProperty(RDFProperty inverseProperty) {
        this.getKnowledgeBase().setInverseSlot((Slot)this, (Slot)inverseProperty);
    }

    public void setRange(RDFResource range) {
        this.setPropertyValue(this.getOWLModel().getRDFSRangeProperty(), range);
    }

    public void setRanges(Collection ranges) {
        this.setPropertyValues(this.getOWLModel().getRDFSRangeProperty(), ranges);
    }

    public void setRDFTypeOfSubproperties(RDFSNamedClass type) {
        this.getKnowledgeBase().setDirectTypeOfSubslots((Slot)this, (Cls)type);
    }

    public void setUnionRangeClasses(Collection classes) {
        RDFResource newRange = null;
        if (classes.size() == 1) {
            newRange = (RDFResource)classes.iterator().next();
        } else if (classes.size() > 1) {
            newRange = this.getOWLModel().createOWLUnionClass(classes);
        }
        this.setRange(newRange);
    }

    public void synchronizeDomainAndRangeOfInverse() {
        Slot inverse;
        if (this.getValueType() == ValueType.INSTANCE && (inverse = this.getInverseSlot()) != null && inverse.getValueType() == ValueType.INSTANCE) {
            this.synchronizeRangeOfInverseWithDomainOfThis();
            this.synchronizeDomainOfInverseWithRangeOfThis();
        }
    }

    private void synchronizeDomainOfInverseWithRangeOfThis() {
        RDFProperty inverseProperty = this.getInverseProperty();
        Slot domainSlot = this.getKnowledgeBase().getSlot(":DIRECT-DOMAIN");
        Collection range = this.getUnionRangeClasses();
        if (range.isEmpty() && inverseProperty.getSuperpropertyCount() == 0) {
            range = Collections.singleton(this.getOWLModel().getOWLThingClass());
        }
        ArrayList inverseDomain = new ArrayList(inverseProperty.getDirectOwnSlotValues(domainSlot));
        if (range.isEmpty()) {
            for (RDFSClass oldDomainCls : inverseDomain) {
                inverseProperty.removeUnionDomainClass(oldDomainCls);
            }
        } else {
            for (RDFSClass inverseRangeCls : inverseDomain) {
                if (range.contains(inverseRangeCls)) continue;
                inverseProperty.removeUnionDomainClass(inverseRangeCls);
            }
            for (RDFSClass rangeCls : range) {
                if (rangeCls.hasDirectTemplateSlot(inverseProperty)) continue;
                inverseProperty.addUnionDomainClass(rangeCls);
            }
        }
    }

    private void synchronizeRangeOfInverseWithDomainOfThis() {
        RDFProperty inverse = this.getInverseProperty();
        Slot domainSlot = this.getKnowledgeBase().getSlot(":DIRECT-DOMAIN");
        ArrayList domain = new ArrayList(this.getDirectOwnSlotValues(domainSlot));
        domain.remove(this.getKnowledgeBase().getRootCls());
        Collection inverseRange = inverse.getUnionRangeClasses();
        if (domain.isEmpty()) {
            inverse.setRange(null);
        } else {
            HashSet newRange = new HashSet(inverseRange);
            for (Cls inverseRangeCls : inverseRange) {
                if (domain.contains(inverseRangeCls)) continue;
                newRange.remove(inverseRangeCls);
            }
            newRange.addAll(domain);
            inverse.setUnionRangeClasses(newRange);
        }
    }

    protected void updateRDFType(boolean value, RDFSClass metaclass) {
        if (this.hasProtegeType(metaclass) != value) {
            if (value) {
                this.addProtegeType(metaclass);
            } else {
                this.removeProtegeType(metaclass);
            }
        }
    }

    public void addComment(String comment) {
        OWLUtil.addComment(this, comment);
    }

    public void addDifferentFrom(RDFResource resource) {
        OWLUtil.addDifferentFrom(this, resource);
    }

    public void addIsDefinedBy(RDFResource instance) {
        OWLUtil.addIsDefinedBy(this, instance);
    }

    public void addLabel(String label, String language) {
        OWLUtil.addLabel(this, label, language);
    }

    public void addPropertyValue(RDFProperty property, Object value) {
        OWLUtil.addPropertyValue(this, property, value);
    }

    public void addPropertyValueListener(PropertyValueListener listener) {
        OWLUtil.addPropertyValueListener(this, listener);
    }

    public void addProtegeType(RDFSClass type) {
        OWLUtil.addProtegeType(this, type);
    }

    public void addRDFType(RDFSClass type) {
        OWLUtil.addRDFType(this, type);
    }

    public void addResourceListener(ResourceListener listener) {
        OWLUtil.addResourceListener(this, listener);
    }

    public void addSameAs(RDFResource resource) {
        OWLUtil.addSameAs(this, resource);
    }

    public void addVersionInfo(String versionInfo) {
        OWLUtil.addVersionInfo(this, versionInfo);
    }

    public RDFResource as(Class javaInterface) {
        return OWLUtil.as(this, javaInterface);
    }

    public boolean canAs(Class javaInterface) {
        return OWLUtil.canAs(this, javaInterface);
    }

    public RDFResource getAllValuesFromOnTypes(RDFProperty property) {
        return OWLUtil.getAllValuesFromOnTypes(this, property);
    }

    public Collection getComments() {
        return OWLUtil.getComments(this);
    }

    public Collection getDifferentFrom() {
        return OWLUtil.getDifferentFrom(this);
    }

    public Collection getHasValuesOnTypes(RDFProperty property) {
        return OWLUtil.getHasValuesOnTypes(this, property);
    }

    public Class getIconLocation() {
        return OWLIcons.class;
    }

    public RDFSClass getProtegeType() {
        return OWLUtil.getDirectRDFType(this);
    }

    public Collection getProtegeTypes() {
        return OWLUtil.getDirectRDFTypes(this);
    }

    public Collection getDocumentation() {
        return OWLUtil.getComments(this);
    }

    public Collection getInferredTypes() {
        return OWLUtil.getInferredDirectTypes(this);
    }

    public Collection getIsDefinedBy() {
        return OWLUtil.getIsDefinedBy(this);
    }

    public Collection getLabels() {
        return OWLUtil.getLabels(this);
    }

    public String getLocalName() {
        String name = this.getName();
        OWLModel nskb = (OWLModel)this.getKnowledgeBase();
        return nskb.getLocalNameForResourceName(name);
    }

    public String getNamespace() {
        OWLModel nskb = (OWLModel)this.getKnowledgeBase();
        String name = this.getName();
        return nskb.getNamespaceForResourceName(name);
    }

    public String getNamespacePrefix() {
        OWLModel nskb = (OWLModel)this.getKnowledgeBase();
        String name = this.getName();
        return nskb.getPrefixForResourceName(name);
    }

    public OWLModel getOWLModel() {
        return (OWLModel)this.getKnowledgeBase();
    }

    public Collection getPossibleRDFProperties() {
        return OWLUtil.getPossibleRDFProperties(this);
    }

    public Object getPropertyValue(RDFProperty property) {
        return OWLUtil.getPropertyValue(this, property, false);
    }

    public RDFResource getPropertyValueAs(RDFProperty property, Class javaInterface) {
        return OWLUtil.getPropertyValueAs(this, property, javaInterface);
    }

    public Object getPropertyValue(RDFProperty property, boolean includingSubproperties) {
        return OWLUtil.getPropertyValue(this, property, includingSubproperties);
    }

    public int getPropertyValueCount(RDFProperty property) {
        return OWLUtil.getPropertyValueCount(this, property);
    }

    public RDFSLiteral getPropertyValueLiteral(RDFProperty property) {
        return OWLUtil.getPropertyValueLiteral(this, property);
    }

    public Collection getPropertyValueLiterals(RDFProperty property) {
        return OWLUtil.getPropertyValueLiterals(this, property);
    }

    public Collection getPropertyValues(RDFProperty property) {
        return OWLUtil.getPropertyValues(this, property, false);
    }

    public Collection getPropertyValuesAs(RDFProperty property, Class javaInterface) {
        return OWLUtil.getPropertyValuesAs(this, property, javaInterface);
    }

    public Collection getPropertyValues(RDFProperty property, boolean includingSubproperties) {
        return OWLUtil.getPropertyValues(this, property, includingSubproperties);
    }

    public Collection getRDFProperties() {
        return OWLUtil.getRDFProperties(this);
    }

    public RDFSClass getRDFType() {
        return OWLUtil.getRDFType(this);
    }

    public Collection getRDFTypes() {
        return OWLUtil.getRDFTypes(this);
    }

    public Set getReferringAnonymousClasses() {
        return OWLUtil.getReferringAnonymousClses(this);
    }

    public Collection getSameAs() {
        return OWLUtil.getSameAs(this);
    }

    public String getURI() {
        return this.getOWLModel().getURIForResourceName(this.getName());
    }

    public Collection getVersionInfo() {
        return OWLUtil.getVersionInfo(this);
    }

    public boolean hasPropertyValue(RDFProperty property) {
        return OWLUtil.hasPropertyValue(this, property);
    }

    public boolean hasPropertyValue(RDFProperty property, boolean includingSubproperties) {
        return OWLUtil.hasPropertyValue(this, property, includingSubproperties);
    }

    public boolean hasPropertyValue(RDFProperty property, Object value) {
        return this.hasPropertyValue(property, value, false);
    }

    public boolean hasPropertyValue(RDFProperty property, Object value, boolean includingSuperproperties) {
        return OWLUtil.hasPropertyValue(this, property, value, includingSuperproperties);
    }

    public boolean hasProtegeType(RDFSClass type) {
        return OWLUtil.hasProtegeType(this, type);
    }

    public boolean hasProtegeType(RDFSClass type, boolean includingSuperclasses) {
        return OWLUtil.hasProtegeType(this, type, includingSuperclasses);
    }

    public boolean hasRDFType(RDFSClass type) {
        return OWLUtil.hasRDFType(this, type);
    }

    public boolean hasRDFType(RDFSClass type, boolean includingSuperclasses) {
        return OWLUtil.hasRDFType(this, type, includingSuperclasses);
    }

    public boolean isAnonymous() {
        return this.getOWLModel().isAnonymousResourceName(this.getName());
    }

    public boolean isValidPropertyValue(RDFProperty property, Object object) {
        return OWLUtil.isValidPropertyValue(this, property, object);
    }

    public Iterator listPropertyValues(RDFProperty property) {
        return OWLUtil.listPropertyValues(this, property, false);
    }

    public Iterator listPropertyValuesAs(RDFProperty property, Class javaInterface) {
        return OWLUtil.listPropertyValuesAs(this, property, javaInterface);
    }

    public Iterator listPropertyValues(RDFProperty property, boolean includingSubproperties) {
        return OWLUtil.listPropertyValues(this, property, includingSubproperties);
    }

    public Iterator listRDFTypes() {
        return this.getRDFTypes().iterator();
    }

    public void removeComment(String value) {
        OWLUtil.removeComment(this, value);
    }

    public void removeDifferentFrom(RDFResource resource) {
        OWLUtil.removeDifferentFrom(this, resource);
    }

    public void removeIsDefinedBy(RDFResource resource) {
        OWLUtil.removeIsDefinedBy(this, resource);
    }

    public void removeLabel(String label, String language) {
        OWLUtil.removeLabel(this, label, language);
    }

    public void removePropertyValue(RDFProperty property, Object value) {
        OWLUtil.removePropertyValue(this, property, value);
    }

    public void removePropertyValueListener(PropertyValueListener listener) {
        OWLUtil.removePropertyValueListener(this, listener);
    }

    public void removeProtegeType(RDFSClass type) {
        OWLUtil.removeProtegeType(this, type);
    }

    public void removeRDFType(RDFSClass type) {
        OWLUtil.removeRDFType(this, type);
    }

    public void removeResourceListener(ResourceListener listener) {
        OWLUtil.removeResourceListener(this, listener);
    }

    public void removeSameAs(RDFResource resource) {
        OWLUtil.removeSameAs(this, resource);
    }

    public void removeVersionInfo(String versionInfo) {
        OWLUtil.removeVersionInfo(this, versionInfo);
    }

    public void setComment(String comment) {
        OWLUtil.setComment(this, comment);
    }

    public void setComments(Collection comments) {
        OWLUtil.setComments(this, comments);
    }

    public void setDomain(RDFSClass domainClass) {
        if (domainClass == null) {
            this.setDomains(Collections.EMPTY_LIST);
        } else {
            this.setDomains(Collections.singleton(domainClass));
        }
    }

    public void setDomains(Collection domainClasses) {
        this.setDirectOwnSlotValues(this.getOWLModel().getRDFSDomainProperty(), domainClasses);
    }

    public void setInferredTypes(Collection types) {
        OWLUtil.setInferredTypes(this, types);
    }

    public void setDocumentation(String value) {
        OWLUtil.setComment(this, value);
    }

    public void setPropertyValue(RDFProperty property, Object value) {
        OWLUtil.setPropertyValue(this, property, value);
    }

    public void setPropertyValues(RDFProperty property, Collection values) {
        OWLUtil.setPropertyValues(this, property, values);
    }

    public void setProtegeType(RDFSClass type) {
        OWLUtil.setProtegeType(this, type);
    }

    public void setProtegeTypes(Collection types) {
        OWLUtil.setProtegeTypes(this, types);
    }

    public void setRDFType(RDFSClass type) {
        OWLUtil.setRDFType(this, type);
    }

    public void setRDFTypes(Collection types) {
        OWLUtil.setRDFTypes(this, types);
    }

    public boolean isDeprecated() {
        RDFSNamedClass c = this.getOWLModel().getRDFSNamedClass("owl:DeprecatedProperty");
        return this.getProtegeTypes().contains(c);
    }

    public void setDeprecated(boolean value) {
        if (this.isDeprecated() != value) {
            RDFSNamedClass c = this.getOWLModel().getRDFSNamedClass("owl:DeprecatedProperty");
            if (value) {
                this.addProtegeType(c);
            } else {
                this.removeProtegeType(c);
            }
        }
    }

    public void accept(OWLModelVisitor visitor) {
        visitor.visitRDFProperty(this);
    }
}

