/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collections;

public class SynonymSearchTestCase
extends AbstractJenaTestCase {
    public void testSetSynonymSlots() {
        SynonymSearchTestCase.assertSize(0, this.owlModel.getSearchSynonymProperties());
        OWLDatatypeProperty anno = this.owlModel.createAnnotationOWLDatatypeProperty("anno");
        this.owlModel.setSearchSynonymProperties(Collections.singleton(anno));
        SynonymSearchTestCase.assertSize(1, this.owlModel.getSearchSynonymProperties());
        SynonymSearchTestCase.assertEquals((Object)anno, this.owlModel.getSearchSynonymProperties().iterator().next());
        this.owlModel.setSearchSynonymProperties(Collections.EMPTY_LIST);
        SynonymSearchTestCase.assertSize(0, this.owlModel.getSearchSynonymProperties());
    }

    public void testSearchSynonymSlot() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLDatatypeProperty anno = this.owlModel.createAnnotationOWLDatatypeProperty("anno");
        String value = "aldi";
        cls.setPropertyValue(anno, "aldi");
        SynonymSearchTestCase.assertSize(0, this.owlModel.getFrameNameMatches("aldi", 100));
        this.owlModel.setSearchSynonymProperties(Collections.singleton(anno));
        SynonymSearchTestCase.assertSize(1, this.owlModel.getFrameNameMatches("aldi", 100));
        SynonymSearchTestCase.assertEquals((Object)cls, this.owlModel.getFrameNameMatches("aldi", 100).iterator().next());
    }
}

