/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.patcher.tests;

import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class DefaultOWLModelPatcherTestCase
extends AbstractJenaTestCase {
    private static final String IMPORT = "http://www.coop.de/ontology";

    public void testRDFSDomain() throws Exception {
        this.loadRemoteOntology("untypedRDFSDomain.owl");
        RDFProperty property = this.owlModel.getRDFProperty("property");
        DefaultOWLModelPatcherTestCase.assertNotNull((Object)property);
        RDFResource c = this.owlModel.getRDFResource("ns:Class");
        DefaultOWLModelPatcherTestCase.assertTrue((boolean)(c instanceof RDFSNamedClass));
        DefaultOWLModelPatcherTestCase.assertSize(2, this.owlModel.getTripleStoreModel().listUserTripleStores());
        TripleStore ts = this.owlModel.getTripleStoreModel().getTripleStore(2);
        DefaultOWLModelPatcherTestCase.assertEquals((String)IMPORT, (String)ts.getName());
        DefaultOWLModelPatcherTestCase.assertTrue((boolean)ts.contains(c, this.owlModel.getRDFTypeProperty(), this.owlModel.getRDFSNamedClassClass()));
    }

    public void testRDFSRange() throws Exception {
        this.loadRemoteOntology("untypedRDFSRange.owl");
        RDFProperty property = this.owlModel.getRDFProperty("property");
        DefaultOWLModelPatcherTestCase.assertNotNull((Object)property);
        RDFResource c = this.owlModel.getRDFResource("ns:Class");
        DefaultOWLModelPatcherTestCase.assertTrue((boolean)(c instanceof RDFSNamedClass));
        DefaultOWLModelPatcherTestCase.assertSize(2, this.owlModel.getTripleStoreModel().listUserTripleStores());
        TripleStore ts = this.owlModel.getTripleStoreModel().getTripleStore(2);
        DefaultOWLModelPatcherTestCase.assertEquals((String)IMPORT, (String)ts.getName());
        DefaultOWLModelPatcherTestCase.assertTrue((boolean)ts.contains(c, this.owlModel.getRDFTypeProperty(), this.owlModel.getRDFSNamedClassClass()));
    }

    public void testRDFSSubClassOf() throws Exception {
        this.loadRemoteOntology("untypedRDFSSubClassOf.owl");
        RDFSNamedClass subclass = this.owlModel.getRDFSNamedClass("Class");
        DefaultOWLModelPatcherTestCase.assertNotNull((Object)subclass);
        RDFResource c = this.owlModel.getRDFResource("ns:Class");
        DefaultOWLModelPatcherTestCase.assertTrue((boolean)(c instanceof RDFSNamedClass));
        DefaultOWLModelPatcherTestCase.assertSize(2, this.owlModel.getTripleStoreModel().listUserTripleStores());
        TripleStore ts = this.owlModel.getTripleStoreModel().getTripleStore(2);
        DefaultOWLModelPatcherTestCase.assertEquals((String)IMPORT, (String)ts.getName());
        DefaultOWLModelPatcherTestCase.assertTrue((boolean)ts.contains(c, this.owlModel.getRDFTypeProperty(), this.owlModel.getRDFSNamedClassClass()));
        RDFSNamedClass superclass = (RDFSNamedClass)c;
        DefaultOWLModelPatcherTestCase.assertSize(1, superclass.getSuperclasses(false));
        DefaultOWLModelPatcherTestCase.assertContains((Object)this.owlThing, superclass.getSuperclasses(false));
    }

    public void testUntypedPredicate() throws Exception {
        this.loadRemoteOntology("untypedPredicate.owl");
        RDFSNamedClass c = this.owlModel.getRDFSNamedClass("Class");
        DefaultOWLModelPatcherTestCase.assertNotNull((Object)c);
        RDFResource property = this.owlModel.getRDFResource("ns:property");
        DefaultOWLModelPatcherTestCase.assertTrue((boolean)(property instanceof RDFProperty));
        DefaultOWLModelPatcherTestCase.assertSize(2, this.owlModel.getTripleStoreModel().listUserTripleStores());
        TripleStore ts = this.owlModel.getTripleStoreModel().getTripleStore(2);
        DefaultOWLModelPatcherTestCase.assertEquals((String)IMPORT, (String)ts.getName());
        DefaultOWLModelPatcherTestCase.assertTrue((boolean)ts.contains(property, this.owlModel.getRDFTypeProperty(), this.owlModel.getRDFPropertyClass()));
    }
}

