/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.query;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.query.QueryResults;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SPARQLQueryResults
implements QueryResults {
    private OWLModel owlModel;
    private Query query;
    private ResultSet results;

    public SPARQLQueryResults(OWLModel owlModel, Query query, ResultSet results) {
        this.owlModel = owlModel;
        this.query = query;
        this.results = results;
    }

    public static SPARQLQueryResults create(OWLModel owlModel, String queryString) throws Exception {
        Model model = owlModel.getJenaModel();
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);
        ResultSet results = qexec.execSelect();
        return new SPARQLQueryResults(owlModel, query, results);
    }

    public static String createPrefixDeclarations(OWLModel owlModel) {
        String queryString = "";
        String defaultNamespace = owlModel.getNamespaceManager().getDefaultNamespace();
        queryString = defaultNamespace.endsWith("#") ? String.valueOf(queryString) + "BASE <" + defaultNamespace.substring(0, defaultNamespace.length() - 1) + ">\n" : String.valueOf(queryString) + "BASE <" + defaultNamespace + ">\n";
        queryString = String.valueOf(queryString) + "PREFIX :   <" + defaultNamespace + ">\n";
        for (String prefix : owlModel.getNamespaceManager().getPrefixes()) {
            String namespace = owlModel.getNamespaceManager().getNamespaceForPrefix(prefix);
            queryString = String.valueOf(queryString) + "PREFIX " + prefix + ": <" + namespace + ">\n";
        }
        return queryString;
    }

    public List getVariables() {
        return this.query.getResultVars();
    }

    public boolean hasNext() {
        return this.results.hasNext();
    }

    public Map next() {
        HashMap<String, RDFObject> map = new HashMap<String, RDFObject>();
        List vars = this.query.getResultVars();
        QuerySolution soln = this.results.nextSolution();
        int i = 0;
        while (i < vars.size()) {
            String varName = (String)vars.get(i);
            RDFNode varNode = soln.get(varName);
            if (varNode instanceof Literal) {
                Literal literal = (Literal)varNode;
                RDFSDatatype datatype = this.owlModel.getRDFSDatatypeByURI(literal.getDatatypeURI());
                String lexical = literal.getLexicalForm();
                RDFSLiteral protegeLiteral = this.owlModel.createRDFSLiteral(lexical, datatype);
                map.put(varName, protegeLiteral);
            } else {
                String str = varNode.toString();
                String name = null;
                name = this.owlModel.isAnonymousResourceName(str) ? str : ((AbstractOWLModel)this.owlModel).getFrameNameForURI(str, false);
                if (name != null) {
                    RDFResource resource = this.owlModel.getRDFResource(name);
                    if (resource != null) {
                        map.put(varName, resource);
                    } else {
                        map.put(varName, this.owlModel.createRDFSLiteral(str));
                    }
                } else {
                    map.put(varName, this.owlModel.createRDFSLiteral(str));
                }
            }
            ++i;
        }
        return map;
    }
}

