/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl.tests;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.tests.AbstractTripleStoreTestCase;

public class CreateOWLEquivalentClassTestCase
extends AbstractTripleStoreTestCase {
    public void testDefaultSuperclassDespiteRestriction() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        String name = "Class";
        RDFResource c = this.createRDFResource(name);
        RDFResource restriction = this.createRDFResource(null);
        this.ts.add(c, this.owlModel.getOWLEquivalentClassProperty(), restriction);
        this.ts.add(restriction, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass());
        this.ts.add(restriction, this.owlModel.getRDFProperty("owl:cardinality"), new Integer(1));
        this.ts.add(restriction, this.owlModel.getRDFProperty("owl:onProperty"), property);
        this.ts.add(c, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass());
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        OWLNamedClass cls = this.owlModel.getOWLNamedClass(name);
        CreateOWLEquivalentClassTestCase.assertSize(2, cls.getDirectSuperclasses());
        CreateOWLEquivalentClassTestCase.assertContains((Object)this.owlThing, cls.getDirectSuperclasses());
        CreateOWLEquivalentClassTestCase.assertContains((Object)restriction, cls.getDirectSuperclasses());
        Cls r = this.owlModel.getCls(restriction.getName());
        CreateOWLEquivalentClassTestCase.assertSize(1, r.getDirectSuperclasses());
        CreateOWLEquivalentClassTestCase.assertContains((Object)cls, r.getDirectSuperclasses());
    }

    public void testNamedEquivalentClass() {
        RDFResource classA = this.createRDFResource("classA");
        RDFResource classB = this.createRDFResource("classB");
        this.ts.add(classA, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass());
        this.ts.add(classB, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass());
        this.ts.add(classA, this.owlModel.getOWLEquivalentClassProperty(), classB);
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        OWLNamedClass clsA = this.owlModel.getOWLNamedClass(classA.getName());
        OWLNamedClass clsB = this.owlModel.getOWLNamedClass(classB.getName());
        CreateOWLEquivalentClassTestCase.assertSize(2, clsA.getDirectSuperclasses());
        CreateOWLEquivalentClassTestCase.assertContains((Object)this.owlThing, clsA.getDirectSuperclasses());
        CreateOWLEquivalentClassTestCase.assertContains((Object)clsB, clsA.getDirectSuperclasses());
        CreateOWLEquivalentClassTestCase.assertSize(2, clsB.getDirectSuperclasses());
        CreateOWLEquivalentClassTestCase.assertContains((Object)this.owlThing, clsB.getDirectSuperclasses());
        CreateOWLEquivalentClassTestCase.assertContains((Object)clsA, clsB.getDirectSuperclasses());
    }

    public void testMakeNamedClassAnonymous() {
        RDFResource namedClassR = this.createRDFResource("class");
        this.ts.add(namedClassR, this.rdfTypeProperty, this.owlModel.getOWLNamedClassClass());
        this.ts.add(namedClassR, this.owlModel.getRDFProperty("owl:complementOf"), this.owlThing);
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        OWLNamedClass namedClass = this.owlModel.getOWLNamedClass(namedClassR.getName());
        CreateOWLEquivalentClassTestCase.assertSize(1, namedClass.getEquivalentClasses());
        OWLComplementClass complementClass = (OWLComplementClass)namedClass.getEquivalentClasses().iterator().next();
        CreateOWLEquivalentClassTestCase.assertEquals((Object)this.owlThing, (Object)complementClass.getComplement());
    }
}

