/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.tests.AbstractTripleStoreTestCase;

public class CreateOWLLogicalClassesTestCase
extends AbstractTripleStoreTestCase {
    public void testCreateComplementClass1() {
        DefaultRDFProperty c = new DefaultRDFProperty(this.owlModel, this.createFrameID());
        c.setName("test");
        this.ts.add(c, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass());
        this.ts.add(c, this.owlModel.getRDFProperty("owl:complementOf"), this.owlModel.getOWLThingClass());
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        OWLNamedClass namedClass = this.owlModel.getOWLNamedClass(c.getName());
        RDFSClass f = namedClass.getDefinition();
        CreateOWLLogicalClassesTestCase.assertTrue((boolean)(f instanceof OWLComplementClass));
        CreateOWLLogicalClassesTestCase.assertEquals((Object)this.owlModel.getOWLThingClass(), (Object)((OWLComplementClass)f).getComplement());
    }

    public void testCreateComplementClass2() {
        DefaultRDFProperty c = new DefaultRDFProperty(this.owlModel, this.createFrameID());
        String name = "test";
        c.setName(name);
        this.ts.add(c, this.owlModel.getRDFProperty("owl:complementOf"), this.owlModel.getOWLThingClass());
        this.ts.add(c, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass());
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        OWLNamedClass namedClass = this.owlModel.getOWLNamedClass(c.getName());
        RDFSClass f = namedClass.getDefinition();
        CreateOWLLogicalClassesTestCase.assertTrue((boolean)(f instanceof OWLComplementClass));
    }

    public void testCreateIntersectionClass() {
        OWLNamedClass classA = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass classB = this.owlModel.createOWLNamedClass("B");
        DefaultRDFProperty c = new DefaultRDFProperty(this.owlModel, this.createFrameID());
        c.setName("test");
        this.ts.add(c, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass());
        RDFProperty operandsProperty = this.owlModel.getOWLIntersectionOfProperty();
        RDFResource nodeA = this.createRDFResource(null);
        this.ts.add(c, operandsProperty, nodeA);
        this.ts.add(nodeA, this.owlModel.getRDFFirstProperty(), classA);
        RDFResource nodeB = this.createRDFResource(null);
        this.ts.add(nodeA, this.owlModel.getRDFRestProperty(), nodeB);
        this.ts.add(nodeB, this.owlModel.getRDFFirstProperty(), classB);
        this.ts.add(nodeB, this.owlModel.getRDFRestProperty(), this.owlModel.getRDFNil());
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        OWLNamedClass namedClass = this.owlModel.getOWLNamedClass(c.getName());
        RDFSClass f = namedClass.getDefinition();
        CreateOWLLogicalClassesTestCase.assertTrue((boolean)(f instanceof OWLIntersectionClass));
        OWLIntersectionClass intersectionClass = (OWLIntersectionClass)f;
        CreateOWLLogicalClassesTestCase.assertContains((Object)classA, intersectionClass.getOperands());
        CreateOWLLogicalClassesTestCase.assertContains((Object)classB, intersectionClass.getOperands());
    }

    public void testCreateUnionClass() {
        OWLNamedClass classA = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass classB = this.owlModel.createOWLNamedClass("B");
        DefaultRDFProperty c = new DefaultRDFProperty(this.owlModel, this.createFrameID());
        c.setName("test");
        this.ts.add(c, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass());
        RDFProperty operandsProperty = this.owlModel.getOWLUnionOfProperty();
        RDFResource nodeB = this.createRDFResource(null);
        RDFResource nodeA = this.createRDFResource(null);
        this.ts.add(nodeA, this.owlModel.getRDFRestProperty(), nodeB);
        this.ts.add(nodeB, this.owlModel.getRDFFirstProperty(), classB);
        this.ts.add(nodeB, this.owlModel.getRDFRestProperty(), this.owlModel.getRDFNil());
        this.ts.add(c, operandsProperty, nodeA);
        this.ts.add(nodeA, this.owlModel.getRDFFirstProperty(), classA);
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        OWLNamedClass namedClass = this.owlModel.getOWLNamedClass(c.getName());
        RDFSClass f = namedClass.getDefinition();
        CreateOWLLogicalClassesTestCase.assertTrue((boolean)(f instanceof OWLUnionClass));
        OWLUnionClass unionClass = (OWLUnionClass)f;
        CreateOWLLogicalClassesTestCase.assertContains((Object)classA, unionClass.getOperands());
        CreateOWLLogicalClassesTestCase.assertContains((Object)classB, unionClass.getOperands());
    }
}

