/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class XSDVisibility {
    public static Set getDefaultDatatypes(OWLModel owlModel) {
        HashSet<RDFSDatatype> set = new HashSet<RDFSDatatype>();
        set.add(owlModel.getXSDboolean());
        set.add(owlModel.getXSDfloat());
        set.add(owlModel.getXSDint());
        set.add(owlModel.getXSDstring());
        set.add(owlModel.getXSDdate());
        set.add(owlModel.getXSDdateTime());
        set.add(owlModel.getXSDtime());
        return set;
    }

    public static void updateVisibility(OWLModel owlModel) {
        Set defaultDatatypes = XSDVisibility.getDefaultDatatypes(owlModel);
        for (RDFSDatatype datatype : owlModel.getRDFSDatatypes()) {
            if (!datatype.isSystem() || defaultDatatypes.contains(datatype)) continue;
            Collection refs = owlModel.getReferences(datatype, 10);
            boolean visible = refs.size() > 1;
            datatype.setVisible(visible);
        }
    }
}

