/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.impl.FTPRepositoryPasswordProvider;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

public class FTPRepository
implements Repository {
    private URI ftpURI;
    private URI projectDirectory;
    private File localCopy;
    private URI ontologyName;
    private static FTPRepositoryPasswordProvider passwordProvider = new FTPRepositoryPasswordProvider(){

        public String getUserName() {
            return null;
        }

        public String getPassword() {
            JPasswordField pwf = new JPasswordField();
            LabeledComponent lc = new LabeledComponent("FTP Password", (Component)pwf);
            JOptionPane.showMessageDialog(null, lc, "Password", 1);
            return new String(pwf.getPassword());
        }
    };

    public FTPRepository(URI ftpURI, URI projectDirectory) {
        this.ftpURI = ftpURI;
        this.projectDirectory = projectDirectory;
        this.setLocalFile();
    }

    public boolean contains(URI ontologyName) {
        if (this.ontologyName != null) {
            return this.ontologyName.equals(ontologyName);
        }
        return false;
    }

    private void setLocalFile() {
        try {
            File f = new File(this.ftpURI.getPath());
            URI localURI = new URI(new URL(this.projectDirectory.toURL(), f.getName()).toString());
            this.localCopy = new File(localURI);
        }
        catch (URISyntaxException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
        catch (MalformedURLException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void ftpGet() {
        try {
            FTPClient ftpClient = new FTPClient();
            ftpClient.setRemoteHost(this.ftpURI.getHost());
            ftpClient.connect();
            if (passwordProvider != null) {
                ftpClient.login(this.ftpURI.getUserInfo(), passwordProvider.getPassword());
            }
            File f = new File(this.ftpURI.getPath());
            ftpClient.chdir(f.getParentFile().toString());
            FileOutputStream fos = new FileOutputStream(this.localCopy);
            ftpClient.get((OutputStream)fos, f.getName());
            ftpClient.quit();
            FileInputStream fis = new FileInputStream(this.localCopy);
            OntologyNameExtractor extractor = new OntologyNameExtractor(fis, this.localCopy.toURI().toURL());
            this.ontologyName = extractor.getOntologyName();
            System.out.println(extractor.getOntologyName());
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
        catch (FTPException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void ftpPut() {
        try {
            FTPClient ftpClient = new FTPClient();
            ftpClient.setRemoteHost(this.ftpURI.getHost());
            ftpClient.connect();
            if (passwordProvider != null) {
                ftpClient.login(this.ftpURI.getUserInfo(), passwordProvider.getPassword());
            }
            File f = new File(this.ftpURI.getPath());
            ftpClient.chdir(f.getParentFile().toString());
            FileInputStream fis = new FileInputStream(this.localCopy);
            ftpClient.put((InputStream)fis, f.getName());
            ftpClient.quit();
            System.out.println("Put!");
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
        catch (FTPException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void refresh() {
        this.ftpGet();
    }

    public Collection getOntologies() {
        if (this.ontologyName != null) {
            return Collections.singleton(this.ontologyName);
        }
        return Collections.EMPTY_LIST;
    }

    public InputStream getInputStream(URI ontologyName) throws IOException {
        if (this.contains(ontologyName)) {
            if (this.isWritable(ontologyName)) {
                return new FileInputStream(this.localCopy);
            }
            return null;
        }
        return null;
    }

    public boolean isWritable(URI ontologyName) {
        if (this.contains(ontologyName)) {
            return this.localCopy.exists() && this.localCopy.canWrite();
        }
        return false;
    }

    public OutputStream getOutputStream(URI ontologyName) throws IOException {
        if (this.contains(ontologyName)) {
            if (this.isWritable(ontologyName)) {
                return new FileOutputStream(this.localCopy);
            }
            return null;
        }
        return null;
    }

    public boolean isSystem() {
        return false;
    }

    public String getRepositoryDescription() {
        return "FTP Repository (" + this.ftpURI + ")";
    }

    public String getOntologyLocationDescription(URI ontologyName) {
        if (this.localCopy != null) {
            return this.localCopy.toString();
        }
        return "";
    }

    public String getRepositoryDescriptor() {
        return this.ftpURI.toString();
    }

    public static void setFTPRepositoryPasswordProvider(FTPRepositoryPasswordProvider provider) {
        passwordProvider = provider;
    }

    public static void main(String[] args) {
        try {
            FTPRepositoryPasswordProvider pwp = new FTPRepositoryPasswordProvider(){

                public String getUserName() {
                    return null;
                }

                public String getPassword() {
                    JPasswordField pwd = new JPasswordField();
                    JOptionPane.showMessageDialog(null, pwd, "Password", 1);
                    return new String(pwd.getPassword());
                }
            };
            FTPRepository.setFTPRepositoryPasswordProvider(pwp);
            String s = "ftp://horridgm@kiss.cs.man.ac.uk:21/home/M02/cc/horridgm/ontologies/TeachingFlattened.owl";
            URI uri = new URI(s);
            System.out.println("Scheme: " + uri.getScheme());
            System.out.println("Host: " + uri.getHost());
            System.out.println("Port: " + uri.getPort());
            System.out.println("UserInfo: " + uri.getUserInfo());
            System.out.println("Path: " + uri.getPath());
            File f = new File(uri.getPath());
            System.out.println("FileName: " + f.getName());
            System.out.println("FileDirectory: " + f.getParentFile());
            URI pd = new File("/Users/matthewhorridge/Desktop").toURI();
            FTPRepository rep = new FTPRepository(uri, pd);
            rep.ftpGet();
            rep.ftpPut();
        }
        catch (URISyntaxException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }
}

