/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.bridge.AtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.IndividualInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.Info;
import edu.stanford.smi.protegex.owl.swrl.bridge.LiteralInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.VariableInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import java.util.ArrayList;
import java.util.List;

public class BuiltInAtomInfo
extends AtomInfo {
    private List arguments;

    public BuiltInAtomInfo(OWLModel owlModel, SWRLBuiltinAtom builtInAtom) throws SWRLRuleEngineBridgeException {
        super(builtInAtom.getBuiltin().getName());
        this.arguments = this.buildInfoList(owlModel, builtInAtom);
    }

    public List getArguments() {
        return this.arguments;
    }

    public boolean isFirstArgumentAVariable() {
        return !this.arguments.isEmpty() && this.arguments.get(0) instanceof VariableInfo;
    }

    public String getFirstArgumentVariableName() throws SWRLRuleEngineBridgeException {
        if (!this.isFirstArgumentAVariable()) {
            throw new SWRLRuleEngineBridgeException("Expecting a variable as the first parameter of built-in '" + this.getName() + "'");
        }
        return ((VariableInfo)this.arguments.get(0)).getName();
    }

    private List buildInfoList(OWLModel owlModel, SWRLBuiltinAtom builtInAtom) throws SWRLRuleEngineBridgeException {
        ArrayList<Info> result = new ArrayList<Info>();
        RDFList rdfList = builtInAtom.getArguments();
        for (Object o : rdfList.getValues()) {
            if (o instanceof SWRLVariable) {
                SWRLVariable variable = (SWRLVariable)o;
                result.add(new VariableInfo(variable));
                this.addReferencedVariableName(variable.getName());
                continue;
            }
            if (o instanceof OWLIndividual) {
                OWLIndividual individual = (OWLIndividual)o;
                result.add(new IndividualInfo(individual));
                this.addReferencedIndividualName(individual.getName());
                continue;
            }
            if (o instanceof RDFSLiteral) {
                result.add(new LiteralInfo(owlModel, (RDFSLiteral)o));
                continue;
            }
            if (o instanceof Number) {
                result.add(new LiteralInfo((Number)o));
                continue;
            }
            if (o instanceof String) {
                result.add(new LiteralInfo((String)o));
                continue;
            }
            throw new SWRLRuleEngineBridgeException("Unknown type for parameter '" + o + "' to built-in atom '" + builtInAtom.getBrowserText() + "'.");
        }
        return result;
    }
}

