/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.bridge.Argument;
import edu.stanford.smi.protegex.owl.swrl.bridge.Info;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.LiteralConversionException;

public class LiteralInfo
extends Info
implements Argument {
    private Object value;

    public LiteralInfo(OWLModel owlModel, RDFSLiteral literal) throws LiteralConversionException {
        super("<An RDFS-based literal>");
        RDFSDatatype datatype = literal.getDatatype();
        if (datatype == owlModel.getXSDint() || datatype == owlModel.getXSDinteger()) {
            this.value = new Integer(literal.getInt());
        } else if (datatype == owlModel.getXSDshort()) {
            this.value = new Short(literal.getShort());
        } else if (datatype == owlModel.getXSDlong()) {
            this.value = new Long(literal.getLong());
        } else if (datatype == owlModel.getXSDboolean()) {
            this.value = new Boolean(literal.getBoolean());
        } else if (datatype == owlModel.getXSDfloat()) {
            this.value = new Float(literal.getFloat());
        } else if (datatype == owlModel.getXSDdouble()) {
            this.value = new Double(literal.getDouble());
        } else if (datatype == owlModel.getXSDstring()) {
            this.value = new String(literal.getString());
        } else if (datatype == owlModel.getXSDtime()) {
            this.value = new Time(literal.getString());
        } else if (datatype == owlModel.getXSDanyURI()) {
            this.value = new AnyURI(literal.getString());
        } else if (datatype == owlModel.getXSDbase64Binary()) {
            this.value = new Base64Binary(literal.getString());
        } else if (datatype == owlModel.getXSDdecimal()) {
            this.value = new Decimal(literal.getString());
        } else if (datatype == owlModel.getXSDbyte()) {
            this.value = new Byte(literal.getString());
        } else if (datatype == owlModel.getXSDduration()) {
            this.value = new Duration(literal.getString());
        } else if (datatype == owlModel.getXSDdateTime()) {
            this.value = new DateTime(literal.getString());
        } else if (datatype == owlModel.getXSDdate()) {
            this.value = new Date(literal.getString());
        } else {
            throw new LiteralConversionException("Cannot create LiteralInfo object for RDFS literal '" + literal.getString() + "' of type " + datatype + ".");
        }
    }

    public LiteralInfo(String s) {
        super("<A string literal>");
        this.value = s;
    }

    public LiteralInfo(Number n) {
        super("<A number literal>");
        this.value = n;
    }

    public LiteralInfo(boolean b) {
        super("<A boolean literal>");
        this.value = new Boolean(b);
    }

    public LiteralInfo(int i) {
        super("<An integer literal>");
        this.value = new Integer(i);
    }

    public LiteralInfo(float f) {
        super("<A float literal>");
        this.value = new Float(f);
    }

    public LiteralInfo(double d) {
        super("<A double literal>");
        this.value = new Double(d);
    }

    public LiteralInfo(short s) {
        super("<A short literal>");
        this.value = new Short(s);
    }

    public LiteralInfo(ComplexXSDType value) {
        super("<A complex XSD literal>");
        this.value = value;
    }

    public int getInt() {
        return this.isInteger() ? (Integer)this.value : -1;
    }

    public boolean getBoolean() {
        return this.isBoolean() ? (Boolean)this.value : false;
    }

    public long getLong() {
        return this.isLong() ? (Long)this.value : -1L;
    }

    public float getFloat() {
        return this.isFloat() ? ((Float)this.value).floatValue() : -1.0f;
    }

    public double getDouble() {
        return this.isDouble() ? (Double)this.value : -1.0;
    }

    public short getShort() {
        return this.isShort() ? (Short)this.value : (short)-1;
    }

    public String getString() {
        return this.isString() ? (String)this.value : null;
    }

    public Time getTime() {
        return this.isTime() ? (Time)this.value : null;
    }

    public Date getDate() {
        return this.isDate() ? (Date)this.value : null;
    }

    public DateTime getDateTime() {
        return this.isDateTime() ? (DateTime)this.value : null;
    }

    public Duration getDuration() {
        return this.isDuration() ? (Duration)this.value : null;
    }

    public AnyURI getAnyURI() {
        return this.isAnyURI() ? (AnyURI)this.value : null;
    }

    public Base64Binary getBase64Binary() {
        return this.isBase64Binary() ? (Base64Binary)this.value : null;
    }

    public Decimal getDecimal() {
        return this.isDecimal() ? (Decimal)this.value : null;
    }

    public Byte getByte() {
        return this.isByte() ? (Byte)this.value : null;
    }

    public boolean isInteger() {
        return this.value instanceof Integer;
    }

    public boolean isLong() {
        return this.value instanceof Long;
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public boolean isFloat() {
        return this.value instanceof Float;
    }

    public boolean isDouble() {
        return this.value instanceof Double;
    }

    public boolean isShort() {
        return this.value instanceof Short;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public boolean isTime() {
        return this.value instanceof Time;
    }

    public boolean isDate() {
        return this.value instanceof Date;
    }

    public boolean isDateTime() {
        return this.value instanceof DateTime;
    }

    public boolean isDuration() {
        return this.value instanceof Duration;
    }

    public boolean isAnyURI() {
        return this.value instanceof AnyURI;
    }

    public boolean isBase64Binary() {
        return this.value instanceof Base64Binary;
    }

    public boolean isDecimal() {
        return this.value instanceof Decimal;
    }

    public boolean isByte() {
        return this.value instanceof Byte;
    }

    public boolean isNumeric() {
        return this.value instanceof Number;
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LiteralInfo info = (LiteralInfo)obj;
        return (this.getName() == info.getName() || this.getName() != null && this.getName().equals(info.getName())) && this.value != null && info.value != null && this.value.toString().equals(info.value.toString());
    }

    public int hashCode() {
        int hash = 66;
        hash += this.getName() == null ? 0 : this.getName().hashCode();
        return hash += this.value == null ? 0 : this.value.toString().hashCode();
    }

    public abstract class ComplexXSDType {
        private String content;

        public ComplexXSDType(String content) throws LiteralConversionException {
            this.content = content;
            this.validate();
        }

        public String getContent() {
            return this.content;
        }

        protected abstract void validate() throws LiteralConversionException;
    }

    public class Time
    extends ComplexXSDType {
        public Time(String content) throws LiteralConversionException {
            super(content);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for Time literal.");
            }
        }
    }

    public class Date
    extends ComplexXSDType {
        public Date(String content) throws LiteralConversionException {
            super(content);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for Time literal.");
            }
        }
    }

    public class DateTime
    extends ComplexXSDType {
        public DateTime(String content) throws LiteralConversionException {
            super(content);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for DateTime literal.");
            }
        }
    }

    public class Duration
    extends ComplexXSDType {
        public Duration(String content) throws LiteralConversionException {
            super(content);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for Duration literal.");
            }
        }
    }

    public class AnyURI
    extends ComplexXSDType {
        public AnyURI(String content) throws LiteralConversionException {
            super(content);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for AnyURI literal.");
            }
        }
    }

    public class Base64Binary
    extends ComplexXSDType {
        public Base64Binary(String content) throws LiteralConversionException {
            super(content);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for Base64Binary literal.");
            }
        }
    }

    public class Decimal
    extends ComplexXSDType {
        public Decimal(String content) throws LiteralConversionException {
            super(content);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for Decimal literal.");
            }
        }
    }

    public class Byte
    extends ComplexXSDType {
        public Byte(String content) throws LiteralConversionException {
            super(content);
        }

        protected void validate() throws LiteralConversionException {
            if (this.getContent() == null) {
                throw new LiteralConversionException("Null content for Byte literal.");
            }
        }
    }
}

