/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.code;

import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.code.SymbolPanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class SWRLSymbolPanel
extends SymbolPanel {
    private Action andAction;
    private ResourceSelectionAction builtinAction;
    private Action createVariableAction;
    private Action datatypeAction;
    private Action differentFromAction;
    private Action impAction;
    private Action insertVariableAction;
    private JButton insertVariableButton;
    private Action openBracketsAction;
    private Action closeBracketsAction;
    private Action openParenthesisAction;
    private Action closeParenthesisAction;
    private Action sameAsAction;

    public SWRLSymbolPanel(OWLModel owlModel, boolean closeable, boolean draggable) {
        super(owlModel, closeable, draggable, true);
    }

    protected String getDisplayErrorMessage(Throwable ex) {
        if (ex instanceof SWRLParseException) {
            return ((SWRLParseException)ex).getMessage();
        }
        return "" + ex;
    }

    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        return new Dimension(500, pref.height);
    }

    private Collection getUsedVariableNames() {
        String text = this.getSymbolEditor().getText();
        HashSet<String> result = new HashSet<String>();
        int i = 0;
        while (i < text.length()) {
            String varName;
            if (text.charAt(i) == '?' && (varName = this.getVariableName(text, i)).length() > 0) {
                result.add(varName);
            }
            ++i;
        }
        return result;
    }

    private String getVariableName(String text, int beginIndex) {
        int index = beginIndex + 1;
        while (index < text.length() && Character.isJavaIdentifierPart(text.charAt(index))) {
            ++index;
        }
        return text.substring(beginIndex + 1, index);
    }

    protected void initMiddleBar(JToolBar toolBar) {
        this.datatypeAction = new InsertXMLSchemaDatatypeAction();
        this.addButton(toolBar, this.datatypeAction);
        this.andAction = new AbstractAction("Insert conjunction (\u2227)", SWRLIcons.getInsertAndIcon()){

            public void actionPerformed(ActionEvent e) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("  \u2227  ");
            }
        };
        this.addButton(toolBar, this.andAction);
        this.impAction = new AbstractAction("Insert implication (\u2192)", SWRLIcons.getInsertImpIcon()){

            public void actionPerformed(ActionEvent e) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("  \u2192  ");
            }
        };
        this.addButton(toolBar, this.impAction);
        toolBar.addSeparator();
        this.openParenthesisAction = new AbstractAction("Insert open parenthesis: (", SWRLIcons.getOpenParenthesis()){

            public void actionPerformed(ActionEvent e) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("(", 1);
            }
        };
        this.addButton(toolBar, this.openParenthesisAction);
        this.closeParenthesisAction = new AbstractAction("Insert close parenthesis: )", SWRLIcons.getCloseParenthesis()){

            public void actionPerformed(ActionEvent e) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText(")", 1);
            }
        };
        this.addButton(toolBar, this.closeParenthesisAction);
        toolBar.addSeparator();
        this.openBracketsAction = new AbstractAction("Insert open brackets: [", SWRLIcons.getOpenBrackets()){

            public void actionPerformed(ActionEvent e) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("[", 1);
            }
        };
        this.addButton(toolBar, this.openBracketsAction);
        this.closeBracketsAction = new AbstractAction("Insert close brackets: ]", SWRLIcons.getCloseBrackets()){

            public void actionPerformed(ActionEvent e) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("]", 1);
            }
        };
        this.addButton(toolBar, this.closeBracketsAction);
    }

    protected void initTopBar(JToolBar toolBar) {
        this.classAction.activateComboBox(this.addButton(toolBar, this.classAction));
        this.propertyAction.activateComboBox(this.addButton(toolBar, this.propertyAction));
        this.individiualAction.activateComboBox(this.addButton(toolBar, this.individiualAction));
        toolBar.addSeparator();
        this.createVariableAction = new CreateVariableAction();
        this.addButton(toolBar, this.createVariableAction);
        this.insertVariableAction = new InsertVariableAction();
        this.insertVariableButton = this.addButton(toolBar, this.insertVariableAction);
        toolBar.addSeparator();
        this.builtinAction = new InsertBuiltinAction();
        this.builtinAction.activateComboBox(this.addButton(toolBar, this.builtinAction));
        this.differentFromAction = new AbstractAction("Insert differentFrom", SWRLIcons.getDifferentFromIcon()){

            public void actionPerformed(ActionEvent e) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("differentFrom(", 14);
            }
        };
        this.addButton(toolBar, this.differentFromAction);
        this.sameAsAction = new AbstractAction("Insert sameAs", SWRLIcons.getSameAsIcon()){

            public void actionPerformed(ActionEvent e) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("sameAs(", 7);
            }
        };
        this.addButton(toolBar, this.sameAsAction);
        toolBar.addSeparator();
    }

    private void insertVariable(ActionEvent e) {
        HashSet<String> vars = new HashSet<String>(this.getUsedVariableNames());
        Collection instances = this.getOWLModel().getRDFSNamedClass("swrl:Variable").getInstances(true);
        for (RDFResource resource : instances) {
            vars.add(resource.getName());
        }
        Object[] symbols = vars.toArray(new String[0]);
        Arrays.sort(symbols);
        JPopupMenu menu = new JPopupMenu();
        int i = 0;
        while (i < symbols.length) {
            Object symbol = symbols[i];
            final JMenuItem item = new JMenuItem((String)symbol, SWRLIcons.getVariableIcon());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String text = item.getText();
                    SWRLSymbolPanel.this.getSymbolEditor().insertText("?" + text);
                }
            });
            menu.add(item);
            ++i;
        }
        if (menu.getComponentCount() > 0) {
            menu.show(this.insertVariableButton, 0, this.insertVariableButton.getHeight());
        }
    }

    private class InsertBuiltinAction
    extends ResourceSelectionAction {
        InsertBuiltinAction() {
            super("Insert builtin...", SWRLIcons.getBuiltinIcon());
        }

        public void resourceSelected(RDFResource resource) {
            String str = String.valueOf(resource.getBrowserText()) + "(";
            SWRLSymbolPanel.this.getSymbolEditor().insertText(str);
        }

        public Collection getSelectableResources() {
            ArrayList result = new ArrayList(new SWRLFactory(SWRLSymbolPanel.this.getOWLModel()).getBuiltins());
            Collections.sort(result, new FrameComparator());
            return result;
        }

        public RDFResource pickResource() {
            Collection frames = this.getSelectableResources();
            return ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(SWRLSymbolPanel.this, SWRLSymbolPanel.this.getOWLModel(), frames, "Select the builtin to insert");
        }
    }

    private class CreateVariableAction
    extends AbstractAction {
        CreateVariableAction() {
            super("Insert new variable", OWLIcons.getCreateIcon("SWRLVariable", SWRLIcons.class));
        }

        public void actionPerformed(ActionEvent e) {
            String variableName = this.getNextVariableName();
            if (variableName != null) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText("?" + variableName);
            }
        }

        private String getNextVariableName() {
            Collection usedNames = SWRLSymbolPanel.this.getUsedVariableNames();
            ArrayList<String> existingVariableNames = new ArrayList<String>();
            OWLModel owlModel = SWRLSymbolPanel.this.getOWLModel();
            SWRLFactory factory = new SWRLFactory(owlModel);
            Collection variables = factory.getVariables();
            for (SWRLVariable variable : variables) {
                existingVariableNames.add(variable.getName());
            }
            String chars = "xyzabcdefghijklmnopqrstuvwXYZABCDEFGHIJKLMNOPQRSTUVW";
            int i = 0;
            while (i < chars.length()) {
                char c = chars.charAt(i);
                String name = "" + c;
                if (!usedNames.contains(name) && (owlModel.getRDFResource(name) == null || owlModel.getRDFResource(name) instanceof SWRLVariable)) {
                    return name;
                }
                ++i;
            }
            return null;
        }
    }

    private class InsertVariableAction
    extends AbstractAction {
        InsertVariableAction() {
            super("Insert existing variable...", OWLIcons.getAddIcon("SWRLVariable", SWRLIcons.class));
        }

        public void actionPerformed(ActionEvent e) {
            SWRLSymbolPanel.this.insertVariable(e);
        }
    }

    private class InsertXMLSchemaDatatypeAction
    extends AbstractAction {
        InsertXMLSchemaDatatypeAction() {
            super("Insert XML Schema datatype", OWLIcons.getImageIcon("XSDDatatype"));
        }

        public void actionPerformed(ActionEvent e) {
            OWLModel owlModel = SWRLSymbolPanel.this.getOWLModel();
            Collection datatypes = owlModel.getRDFSDatatypes();
            RDFResource datatype = ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(SWRLSymbolPanel.this, owlModel, datatypes, "Select the XML Schema datatype to insert");
            if (datatype != null) {
                SWRLSymbolPanel.this.getSymbolEditor().insertText(datatype.getLocalName());
            }
        }
    }
}

