/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.constraints;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.query.QueryResults;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.query.SPARQLOWLModelAction;
import edu.stanford.smi.protegex.owl.ui.query.SPARQLResultsPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SPARQLAssertTest
extends AbstractOWLTest
implements RDFSClassTest,
RepairableOWLTest {
    public static final String PREFIX = "assert";
    public static final String URI = "http://www.owl-ontologies.com/assert.owl";
    public static final String NAMESPACE = "http://www.owl-ontologies.com/assert.owl#";
    public static final String EMPTY_PROPERTY_URI = "http://www.owl-ontologies.com/assert.owl#empty";
    public static final String NOT_EMPTY_PROPERTY_URI = "http://www.owl-ontologies.com/assert.owl#notEmpty";

    public SPARQLAssertTest() {
        super("Constraints", "SPARQL Asserts");
    }

    public boolean repair(OWLTestResult testResult) {
        SPARQLResultsPanel resultsPanel = SPARQLOWLModelAction.show(testResult.getHost().getOWLModel(), true);
        String queryText = (String)testResult.getUserObject();
        resultsPanel.setQueryText(queryText);
        resultsPanel.executeQuery(queryText);
        return false;
    }

    public List test(RDFSClass aClass) {
        RDFProperty assertMatchesProperty;
        OWLModel owlModel = aClass.getOWLModel();
        String matchesName = owlModel.getResourceNameForURI(NOT_EMPTY_PROPERTY_URI);
        if (matchesName != null && (assertMatchesProperty = owlModel.getRDFProperty(matchesName)) != null) {
            ArrayList results = new ArrayList();
            this.test(aClass, assertMatchesProperty, true, "at least one match", "AssertTrue", results);
            String noMatchesName = owlModel.getResourceNameForURI(EMPTY_PROPERTY_URI);
            RDFProperty assertNoMatchesProperty = owlModel.getRDFProperty(noMatchesName);
            if (assertNoMatchesProperty != null) {
                this.test(aClass, assertNoMatchesProperty, false, "no matches", "AssertFalse", results);
            }
            return results;
        }
        return Collections.EMPTY_LIST;
    }

    private void test(RDFSClass aClass, RDFProperty assertProperty, boolean expected, String expectedString, String iconName, List results) {
        OWLModel owlModel = aClass.getOWLModel();
        Iterator it = aClass.listPropertyValues(assertProperty);
        while (it.hasNext()) {
            Object value = it.next();
            if (!(value instanceof String)) continue;
            String str = (String)value;
            try {
                QueryResults queryResults = owlModel.executeSPARQLQuery(str);
                if (queryResults.hasNext() == expected) continue;
                DefaultOWLTestResult r = new DefaultOWLTestResult("Query asserted to have " + expectedString + ": " + str, aClass, 1, this, OWLIcons.getImageIcon(iconName));
                r.setUserObject(str);
                results.add(r);
            }
            catch (Exception ex) {
                results.add(new DefaultOWLTestResult("Query could not be executed: " + str + ". " + ex.getMessage(), aClass, 2, this));
            }
        }
    }
}

