/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.AutoRepairableOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InverseOfTopLevelPropertyMustBeTopLevelPropertyTest
extends AbstractOWLTest
implements RDFPropertyTest,
AutoRepairableOWLTest {
    public InverseOfTopLevelPropertyMustBeTopLevelPropertyTest() {
        super("Sanity Tests", null);
    }

    public static boolean fails(RDFProperty property) {
        if (property instanceof OWLObjectProperty) {
            RDFProperty inverseSlot = property.getInverseProperty();
            return inverseSlot != null && property.getSuperpropertyCount() == 0 && inverseSlot.getDirectSuperslotCount() > 0;
        }
        return false;
    }

    public boolean repair(OWLTestResult testResult) {
        return InverseOfTopLevelPropertyMustBeTopLevelPropertyTest.repair((OWLProperty)testResult.getHost());
    }

    public static boolean repair(OWLProperty property) {
        RDFProperty inverseSlot;
        if (property instanceof OWLObjectProperty && (inverseSlot = property.getInverseProperty()) != null) {
            for (Slot superSlot : new ArrayList(inverseSlot.getDirectSuperslots())) {
                inverseSlot.removeDirectSuperslot(superSlot);
            }
            return !InverseOfTopLevelPropertyMustBeTopLevelPropertyTest.fails(property);
        }
        return false;
    }

    public List test(RDFProperty property) {
        if (InverseOfTopLevelPropertyMustBeTopLevelPropertyTest.fails(property)) {
            return Collections.singletonList(new DefaultOWLTestResult("The inverse of a top-level property should also be top-level property.", property, 2, this));
        }
        return Collections.EMPTY_LIST;
    }
}

