/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.actions.OWLModelAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;

public class OWLModelActionManager {
    public static void addOWLModelActionsToMenubar(OWLModel owlModel, Adder adder) {
        List actions = OWLModelActionManager.getOWLModelActions();
        ArrayList<OWLModelAction> menubarActions = new ArrayList<OWLModelAction>();
        for (OWLModelAction action : actions) {
            String path = action.getMenubarPath();
            if (path == null) continue;
            menubarActions.add(action);
        }
        Collections.sort(menubarActions, new Comparator(){

            public int compare(Object o, Object o1) {
                OWLModelAction actionA = (OWLModelAction)o;
                OWLModelAction actionB = (OWLModelAction)o1;
                String a = String.valueOf(actionA.getMenubarPath()) + actionA.getName();
                String b = String.valueOf(actionB.getMenubarPath()) + actionB.getName();
                return a.compareTo(b);
            }
        });
        for (OWLModelAction action : menubarActions) {
            adder.addOWLModelAction(action);
        }
    }

    public static void addOWLModelActionsToToolbar(OWLModel owlModel, Adder adder) {
        List actions = OWLModelActionManager.getOWLModelActions();
        ArrayList<OWLModelAction> toolbarActions = new ArrayList<OWLModelAction>();
        for (OWLModelAction action : actions) {
            String path = action.getToolbarPath();
            if (path == null) continue;
            toolbarActions.add(action);
        }
        Collections.sort(toolbarActions, new Comparator(){

            public int compare(Object o, Object o1) {
                OWLModelAction actionA = (OWLModelAction)o;
                OWLModelAction actionB = (OWLModelAction)o1;
                String a = String.valueOf(actionA.getToolbarPath()) + actionA.getName();
                String b = String.valueOf(actionB.getToolbarPath()) + actionB.getName();
                return a.compareTo(b);
            }
        });
        for (OWLModelAction action : toolbarActions) {
            adder.addOWLModelAction(action);
        }
    }

    private static List getOWLModelActions() {
        ArrayList<OWLModelAction> actions = new ArrayList<OWLModelAction>();
        Class[] classes = OWLModelActionManager.getOWLModelActionClasses();
        int i = 0;
        while (i < classes.length) {
            Class aClass = classes[i];
            OWLModelAction action = OWLModelActionManager.getOWLModelAction(aClass);
            actions.add(action);
            ++i;
        }
        return actions;
    }

    public static OWLModelAction getOWLModelAction(Class clazz) {
        try {
            return (OWLModelAction)clazz.newInstance();
        }
        catch (Exception ex) {
            System.err.println("[OWLModelActionManager] Fatal Error: Could not create OWLModelAction for " + clazz);
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            return null;
        }
    }

    public static Class[] getOWLModelActionClasses() {
        ArrayList clses = new ArrayList(PluginUtilities.getClassesWithAttribute((String)"OWLModelAction", (String)"True"));
        return clses.toArray(new Class[0]);
    }

    public static interface Adder {
        public void addOWLModelAction(OWLModelAction var1);
    }
}

