/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreePanel;
import edu.stanford.smi.protegex.owl.ui.cls.OWLSubclassPane;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;

public class CreateSiblingClassAction
extends ResourceAction {
    public static final String TEXT = "Create sibling class";

    public CreateSiblingClassAction() {
        super(TEXT, OWLIcons.getCreateIcon("SiblingClass"));
    }

    public void actionPerformed(ActionEvent e) {
        ClassTreePanel classTreePanel = (ClassTreePanel)((Object)this.getComponent());
        RDFSNamedClass sibling = (RDFSNamedClass)this.getResource();
        CreateSiblingClassAction.performAction(sibling, classTreePanel);
    }

    public boolean isSuitable(Component component, RDFResource resource) {
        return component instanceof OWLSubclassPane && resource instanceof RDFSNamedClass && !resource.equals(resource.getOWLModel().getOWLThingClass());
    }

    public static void performAction(RDFSNamedClass sibling, ClassTreePanel classTreePanel) {
        Collection parents = sibling.getNamedSuperclasses();
        if (!parents.isEmpty()) {
            RDFSNamedClass cls;
            OWLModel owlModel = sibling.getOWLModel();
            owlModel.beginTransaction("Create sibling of class " + sibling.getBrowserText());
            String name = owlModel.createNewResourceName("Class");
            RDFSClass siblingType = sibling.getRDFType();
            if (siblingType == null) {
                siblingType = sibling.getProtegeType();
            }
            if ((cls = owlModel.createRDFSNamedClass(name, parents, siblingType)) instanceof OWLNamedClass) {
                for (RDFSNamedClass s : parents) {
                    ((OWLNamedClass)cls).addInferredSuperclass(s);
                }
            }
            owlModel.endTransaction();
            classTreePanel.setSelectedClass(cls);
        }
    }
}

