/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.ClsesTreeTarget;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SuperclassTraverser;
import edu.stanford.smi.protege.util.Traverser;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTree;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreePanel;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreeRoot;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyManager;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTreeDragSourceListener;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.DefaultClassFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindInDialogAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResourceFinder;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class OWLSubclassPane
extends SelectableContainer
implements ClassTreePanel {
    private HierarchyManager hierarchyManager;
    private OWLModel owlModel;
    private ClassTree tree;
    private ResourceFinder finder;

    public OWLSubclassPane(OWLModel owlModel, Action doubleClickAction, Cls root, Action deleteClsAction) {
        this(owlModel, doubleClickAction, (RDFSNamedClass)root);
    }

    public OWLSubclassPane(OWLModel owlModel, Action doubleClickAction, RDFSNamedClass rootClass) {
        this.owlModel = owlModel;
        this.tree = this.createSelectableTree(doubleClickAction, rootClass);
        this.tree.setLargeModel(true);
        this.tree.setSelectionRow(0);
        this.tree.setAutoscrolls(true);
        this.setSelectable(this.tree);
        this.setLayout(new BorderLayout());
        JScrollPane pane = ComponentFactory.createScrollPane((JComponent)((Object)this.tree));
        this.add("Center", pane);
        FindInDialogAction fAction = new FindInDialogAction(new DefaultClassFind(owlModel, 1), Icons.getFindClsIcon(), this.tree, true);
        this.finder = new ResourceFinder(fAction);
        this.add("South", this.finder);
        this.setupDragAndDrop();
        this.getTree().setCellRenderer((TreeCellRenderer)FrameRenderer.createInstance());
        this.getTree().addMouseListener((MouseListener)new TreePopupMenuMouseListener((JTree)((Object)this.tree)){

            public JPopupMenu getPopupMenu() {
                return OWLSubclassPane.this.getPopupMenu();
            }
        });
        this.owlModel = owlModel;
        Slot directSuperclassesSlot = owlModel.getSlot(":DIRECT-SUPERCLASSES");
        ((JTree)this.getSelectable()).setCellRenderer((TreeCellRenderer)((Object)new ResourceRenderer(directSuperclassesSlot)));
    }

    protected JPopupMenu createPopupMenu() {
        Cls cls;
        Collection sel = this.getSelection();
        if (sel.size() == 1 && (cls = (Cls)sel.iterator().next()) instanceof RDFSNamedClass) {
            JPopupMenu menu = new JPopupMenu();
            ResourceActionManager.addResourceActions(menu, (Component)((Object)this), (RDFResource)cls);
            if (cls instanceof OWLNamedClass && this.hierarchyManager != null) {
                menu.addSeparator();
                menu.add(new ExistentialAction((Component)((Object)this), this.hierarchyManager, (OWLNamedClass)cls));
            }
            return menu;
        }
        return null;
    }

    protected ClassTree createSelectableTree(Action doubleClickAction, Cls rootCls) {
        this.owlModel = (OWLModel)rootCls.getKnowledgeBase();
        ClassTreeRoot root = new ClassTreeRoot(rootCls);
        return new ClassTree(doubleClickAction, root);
    }

    public void extendSelection(Cls cls) {
        ComponentUtilities.extendSelection((JTree)this.getTree(), (Object)cls);
    }

    public JComponent getDropComponent() {
        return this.getTree();
    }

    public ResourceFinder getFinder() {
        return this.finder;
    }

    private JPopupMenu getPopupMenu() {
        return this.createPopupMenu();
    }

    public JTree getTree() {
        return this.tree;
    }

    protected Cls pickConcreteCls(Collection allowedClses, String text) {
        OWLNamedClass owlNamedClassMetaClass = this.owlModel.getOWLNamedClassClass();
        RDFSNamedClass rdfsNamedClassMetaClass = this.owlModel.getRDFSNamedClassClass();
        RDFSNamedClass metaClass = owlNamedClassMetaClass;
        boolean oldNamedVisible = owlNamedClassMetaClass.isVisible();
        boolean oldRDFSVisible = rdfsNamedClassMetaClass.isVisible();
        if (OWLUtil.hasRDFProfile(this.owlModel)) {
            metaClass = rdfsNamedClassMetaClass;
            rdfsNamedClassMetaClass.setVisible(true);
            owlNamedClassMetaClass.setVisible(true);
        }
        RDFSNamedClass result = ProtegeUI.getSelectionDialogFactory().selectClass((Component)((Object)this), this.owlModel, Collections.singleton(metaClass), text);
        rdfsNamedClassMetaClass.setVisible(oldRDFSVisible);
        owlNamedClassMetaClass.setVisible(oldNamedVisible);
        return result;
    }

    public void removeSelection() {
        ComponentUtilities.removeSelection((JTree)this.getTree());
    }

    public void setHierarchyManager(HierarchyManager hierarchyManager) {
        this.hierarchyManager = hierarchyManager;
    }

    public void setSelectedClass(RDFSClass cls) {
        this.setSelectedClassDelegate(cls);
    }

    public void setSelectedCls(Cls cls) {
        this.setSelectedClassDelegate(cls);
    }

    private void setSelectedClassDelegate(Cls cls) {
        if (!this.getSelection().contains(cls)) {
            List path = ModelUtilities.getPathToRoot((Cls)cls);
            this.setSelectedObjectPath(this.getTree(), path);
        }
    }

    public void setSelectedClasses(Collection classes) {
        this.setSelectedClassesDelegate(classes);
    }

    private void setSelectedClassesDelegate(Collection clses) {
        ArrayList<List> paths = new ArrayList<List>();
        for (Cls cls : clses) {
            paths.add(ModelUtilities.getPathToRoot((Cls)cls));
        }
        ComponentUtilities.setSelectedObjectPaths((JTree)this.getTree(), paths);
    }

    public void setSelectedClses(Collection clses) {
        this.setSelectedClassesDelegate(clses);
    }

    private void setSelectedObjectPath(JTree tree, Collection objectPath) {
        TreePath path = ComponentUtilities.getTreePath((JTree)tree, (Collection)objectPath);
        if (path != null) {
            WaitCursor cursor = new WaitCursor((Component)tree);
            tree.scrollPathToVisible(path);
            tree.setSelectionPath(path);
            tree.updateUI();
            cursor.hide();
        }
    }

    protected void setupDragAndDrop() {
        if (OWLUI.isDragAndDropSupported(this.owlModel)) {
            JTree tree = (JTree)this.getSelectable();
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(tree, 3, (DragGestureListener)((Object)new OWLClassesTreeDragSourceListener()));
            new DropTarget(tree, 3, (DropTargetListener)new ClsesTreeTarget());
        }
    }

    public void setExpandedCls(Cls cls, boolean expanded) {
        List path = ModelUtilities.getPathToRoot((Cls)cls);
        ComponentUtilities.setExpanded((JTree)this.getTree(), (Collection)path, (boolean)expanded);
    }

    public void setFinderComponent(JComponent c) {
        this.add(c, "South");
    }

    public void setRenderer(DefaultRenderer renderer) {
        this.getTree().setCellRenderer((TreeCellRenderer)renderer);
    }

    public void setDisplayParent(Cls cls) {
        ComponentUtilities.setDisplayParent((JTree)this.getTree(), (Object)cls, (Traverser)new SuperclassTraverser());
    }

    public String toString() {
        return "SubclassPane";
    }
}

