/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTableModel;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableModel;
import java.util.logging.Level;

public class PropertiesSuperclassesTableModel
extends AbstractOWLTableModel
implements ClassDescriptionTableModel {
    public PropertiesSuperclassesTableModel() {
        super(0);
    }

    public boolean addRow(RDFSClass aClass, int selectedRow) {
        this.getEditedCls().addSuperclass(aClass);
        return true;
    }

    protected int getInsertRowIndex(Cls cls) {
        if (cls instanceof RDFSNamedClass) {
            return 0;
        }
        return this.getRowCount();
    }

    public RDFProperty getPredicate(int row) {
        return null;
    }

    public boolean isDeleteEnabledFor(RDFSClass cls) {
        return cls instanceof OWLAnonymousClass;
    }

    public boolean isRemoveEnabledFor(Cls cls) {
        return cls instanceof RDFSNamedClass && this.getRowCount() > 1 && this.getEditedCls().getNamedSuperclasses().size() > 1;
    }

    protected boolean isSuitable(Cls cls) {
        return cls instanceof RDFSClass && !this.getEditedCls().equals(cls) && this.getEditedCls().isSubclassOf((RDFSClass)cls) && !(cls instanceof OWLRestriction) && (cls instanceof OWLAnonymousClass || cls.isVisible());
    }

    protected void setValueAt(int rowIndex, OWLModel owlModel, String parsableText) throws Exception {
        if (rowIndex >= this.getRowCount()) {
            return;
        }
        try {
            DefaultOWLNamedClass cls = (DefaultOWLNamedClass)this.getEditedCls();
            OWLClassParser parser = owlModel.getOWLClassDisplay().getParser();
            RDFSClass newClass = parser.parseClass(owlModel, parsableText);
            RDFSClass oldClass = this.getClass(rowIndex);
            String newBrowserCls = newClass.getBrowserText();
            if (oldClass == null) {
                Slot directSuperclassesSlot = owlModel.getSlot(":DIRECT-SUPERCLASSES");
                if (cls.hasPropertyValueWithBrowserText(directSuperclassesSlot, newBrowserCls)) {
                    this.displaySemanticError("The class " + newBrowserCls + " is already a superclass of " + cls.getBrowserText() + ".");
                    if (newClass instanceof OWLAnonymousClass) {
                        newClass.delete();
                    }
                } else {
                    cls.addSuperclass(newClass);
                }
            } else if (oldClass.getBrowserText().equals(newBrowserCls)) {
                if (newClass instanceof OWLAnonymousClass) {
                    newClass.delete();
                }
            } else {
                cls.addSuperclass(newClass);
                cls.removeSuperclass(oldClass);
                if (!cls.hasNamedSuperclass()) {
                    cls.addSuperclass(owlModel.getOWLThingClass());
                }
            }
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
        }
    }
}

