/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.rdflist;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.components.AbstractPropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RDFListComponent
extends AbstractPropertyValuesComponent
implements Disposable {
    private ResourceSelectionAction addAction = new ResourceSelectionAction("Add existing value...", OWLIcons.getAddIcon("RDFIndividual")){

        public void resourceSelected(RDFResource resource) {
            RDFListComponent.this.addItem((Frame)resource);
        }

        public Collection getSelectableResources() {
            AbstractCollection values;
            OWLModel owlModel = RDFListComponent.this.getOWLModel();
            if (RDFListComponent.this.getSubject() instanceof OWLNamedClass) {
                values = owlModel.getUserDefinedOWLNamedClasses();
            } else if (RDFListComponent.this.getSubject() instanceof RDFSNamedClass) {
                values = owlModel.getUserDefinedRDFSNamedClasses();
            } else if (RDFListComponent.this.getSubject() instanceof OWLProperty) {
                values = owlModel.getVisibleUserDefinedOWLProperties();
            } else {
                Collection clses = RDFListComponent.this.getListClass().getUnionRangeClasses(RDFListComponent.this.getFirstProperty());
                if (clses.size() > 0) {
                    values = new HashSet();
                    for (Cls cls : clses) {
                        values.addAll(cls.getInstances());
                    }
                } else {
                    values = new ArrayList(owlModel.getOWLIndividuals());
                }
            }
            return values;
        }

        public RDFResource pickResource() {
            if (RDFListComponent.this.getSubject() instanceof RDFSClass) {
                String title = "Select a class to add";
                return ProtegeUI.getSelectionDialogFactory().selectClass((Component)RDFListComponent.this, RDFListComponent.this.getOWLModel(), title);
            }
            if (RDFListComponent.this.getSubject() instanceof OWLProperty) {
                String title = "Select a property to add";
                Collection properties = this.getSelectableResources();
                return ProtegeUI.getSelectionDialogFactory().selectProperty(RDFListComponent.this, RDFListComponent.this.getSubject().getOWLModel(), properties, title);
            }
            OWLModel owlModel = RDFListComponent.this.getOWLModel();
            owlModel.getRDFUntypedResourcesClass().setVisible(true);
            Collection classes = RDFListComponent.this.getListClass().getUnionRangeClasses(RDFListComponent.this.getFirstProperty());
            RDFResource result = ProtegeUI.getSelectionDialogFactory().selectResourceByType(RDFListComponent.this, owlModel, classes);
            owlModel.getRDFUntypedResourcesClass().setVisible(false);
            return result;
        }
    };
    private Action createAction = new AbstractAction("Create new value...", OWLIcons.getCreateIndividualIcon("RDFIndividual")){

        public void actionPerformed(ActionEvent e) {
            RDFListComponent.this.handleCreateAction();
        }
    };
    private Action deleteAction = new AbstractAction("Delete selected values", OWLIcons.getDeleteIcon("RDFIndividual")){

        public void actionPerformed(ActionEvent e) {
            RDFListComponent.this.handleDelete();
        }
    };
    private JList list;
    private DefaultListModel listModel;
    private Action moveDownAction = new AbstractAction("Move selected value down", OWLIcons.getDownIcon()){

        public void actionPerformed(ActionEvent e) {
            int selIndex = RDFListComponent.this.list.getSelectedIndex();
            RDFListComponent.this.swapValues(selIndex, selIndex + 1);
        }

        public void onSelectionChange() {
            int selIndex;
            boolean allowed = false;
            Collection sel = RDFListComponent.this.getSelection();
            if (sel.size() == 1 && (selIndex = RDFListComponent.this.list.getSelectedIndex()) < RDFListComponent.this.list.getModel().getSize() - 1) {
                allowed = true;
            }
        }
    };
    private Action moveUpAction = new AbstractAction("Move selected value up", OWLIcons.getUpIcon()){

        public void actionPerformed(ActionEvent e) {
            int selIndex = RDFListComponent.this.list.getSelectedIndex();
            RDFListComponent.this.swapValues(selIndex, selIndex - 1);
        }

        public void onSelectionChange() {
            int selIndex;
            boolean allowed = false;
            Collection sel = RDFListComponent.this.getSelection();
            if (sel.size() == 1 && (selIndex = RDFListComponent.this.list.getSelectedIndex()) > 0) {
                allowed = true;
            }
        }
    };
    private List registeredTo = new ArrayList();
    private Action removeAction = new AbstractAction("Remove selected value", OWLIcons.getRemoveIcon("RDFIndividual")){

        public void actionPerformed(ActionEvent e) {
            int selIndex = RDFListComponent.this.list.getSelectedIndex();
            RDFListComponent.this.removeListValue(RDFListComponent.this.getSubject(), RDFListComponent.this.getPredicate(), RDFListComponent.this.getListResource(), selIndex);
        }

        public void onSelectionChange() {
        }
    };
    private PropertyValueListener valueListener = new PropertyValueAdapter(){

        public void browserTextChanged(RDFResource resource) {
            RDFListComponent.this.repaint();
        }

        public void propertyValueChanged(RDFResource resource, RDFProperty property, Collection oldValues) {
            RDFListComponent.this.unregisterPropertyValueListener();
            RDFListComponent.this.registerPropertyValueListener();
            RDFListComponent.this.refill();
        }
    };
    private Action viewAction = new AbstractAction("View selected values", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent e) {
            Collection sel = RDFListComponent.this.getSelection();
            for (Object o : sel) {
                if (!(o instanceof RDFResource)) continue;
                RDFListComponent.this.getOWLModel().getProject().show((Instance)((RDFResource)o));
            }
        }
    };

    public RDFListComponent(RDFProperty predicate) {
        super(predicate);
        this.addAction.setEnabled(false);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setCellRenderer(new ResourceRenderer());
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                RDFListComponent.this.updateActions();
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RDFListComponent.this.viewAction.actionPerformed(null);
                }
            }
        });
        OWLLabeledComponent lc = new OWLLabeledComponent(this.getLabel(), new JScrollPane(this.list));
        lc.addHeaderButton(this.createAction);
        lc.addHeaderButton(this.addAction);
        lc.addHeaderButton(this.moveUpAction);
        lc.addHeaderButton(this.moveDownAction);
        lc.addHeaderButton(this.removeAction);
        lc.addHeaderButton(this.deleteAction);
        this.add((Component)((Object)lc));
    }

    private void addItem(Frame frame) {
        if (this.getListResource() == null) {
            RDFSNamedClass type = (RDFSNamedClass)this.getSubject().getProtegeType();
            Cls metaCls = (Cls)type.getUnionRangeClasses(this.getPredicate()).iterator().next();
            Instance newList = metaCls.createDirectInstance(null);
            this.getSubject().setPropertyValue(this.getPredicate(), newList);
        }
        this.appendListValue(this.getListResource(), (Instance)frame);
    }

    public void appendListValue(RDFResource li, Instance value) {
        if (this.getFirst(li) == null) {
            li.setPropertyValue(this.getFirstProperty(), value);
        } else if (this.getRest(li) == null || this.getNil().equals(this.getRest(li))) {
            RDFResource newRest = li.getProtegeType().createInstance(null);
            newRest.setPropertyValue(this.getFirstProperty(), value);
            li.setPropertyValue(this.getRestProperty(), newRest);
        } else {
            this.appendListValue(this.getRest(li), value);
        }
    }

    public void dispose() {
        this.unregisterPropertyValueListener();
    }

    protected Instance getFirst(Instance li) {
        RDFProperty restSlot = this.getFirstProperty();
        Object value = li.getDirectOwnSlotValue((Slot)restSlot);
        if (value instanceof Instance) {
            return (Instance)value;
        }
        return null;
    }

    protected RDFProperty getFirstProperty() {
        return this.getOWLModel().getRDFFirstProperty();
    }

    protected RDFSNamedClass getListClass() {
        Collection clses = ((RDFSNamedClass)this.getSubjectType()).getUnionRangeClasses(this.getPredicate());
        return (RDFSNamedClass)clses.iterator().next();
    }

    private RDFResource getListElement(int index) {
        RDFResource element = this.getListResource();
        int i = 0;
        while (i < index) {
            element = (RDFResource)element.getPropertyValue(this.getRestProperty());
            ++i;
        }
        return element;
    }

    public RDFResource getListResource() {
        return (RDFResource)this.getSubject().getPropertyValue(this.getPredicate());
    }

    protected RDFResource getNil() {
        return this.getOWLModel().getRDFNil();
    }

    protected RDFResource getRest(RDFResource li) {
        return (RDFResource)li.getPropertyValue(this.getRestProperty());
    }

    protected RDFProperty getRestProperty() {
        return this.getOWLModel().getRDFRestProperty();
    }

    public int getRowCount() {
        return this.list.getModel().getSize();
    }

    public Collection getSelection() {
        return Arrays.asList(this.list.getSelectedValues());
    }

    protected void handleCreateAction() {
        RDFSNamedClass listClass = this.getListClass();
        RDFProperty firstProperty = this.getOWLModel().getRDFProperty("rdf:first");
        Collection clses = listClass.getUnionRangeClasses(firstProperty);
        RDFSNamedClass cls = ProtegeUI.getSelectionDialogFactory().selectClass((Component)this, this.getOWLModel(), clses, "Select type of new list element");
        if (cls != null) {
            RDFSClass newclass;
            RDFResource instance = cls.createInstance(null);
            if (instance instanceof RDFSClass && (newclass = (RDFSClass)instance).getSuperclassCount() == 0) {
                newclass.addSuperclass(this.getOWLModel().getOWLThingClass());
            }
            this.getOWLModel().getProject().show((Instance)instance);
            this.addItem((Frame)instance);
        }
    }

    private void handleDelete() {
        HashSet sels = new HashSet(this.getSelection());
        for (Instance instance : sels) {
            instance.delete();
        }
    }

    public boolean isAddEnabled() {
        RDFResource list = this.getListResource();
        if (list == null) {
            return true;
        }
        return this.getOWLModel().getTripleStoreModel().isActiveTriple(this.getSubject(), this.getPredicate(), list);
    }

    public boolean isCreateEnabled() {
        return this.isAddEnabled();
    }

    public boolean isDeleteEnabled() {
        if (this.isRemoveEnabled()) {
            int[] sels = this.list.getSelectedIndices();
            int i = 0;
            while (i < sels.length) {
                RDFResource resource;
                int sel = sels[i];
                Object value = this.listModel.get(sel);
                if (value instanceof RDFResource && !(resource = (RDFResource)value).isEditable()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isMoveDownEnabled() {
        int[] sels;
        if (this.isRemoveEnabled() && (sels = this.list.getSelectedIndices()).length == 1) {
            return sels[0] < this.getRowCount() - 1;
        }
        return false;
    }

    public boolean isMoveUpEnabled() {
        int[] sels;
        if (this.isRemoveEnabled() && (sels = this.list.getSelectedIndices()).length == 1) {
            return sels[0] > 0;
        }
        return false;
    }

    public boolean isRemoveEnabled() {
        RDFResource li = this.getListResource();
        if (li != null && this.getOWLModel().getTripleStoreModel().isEditableTriple(this.getSubject(), this.getPredicate(), li)) {
            int[] sels = this.list.getSelectedIndices();
            return sels.length > 0;
        }
        return false;
    }

    private void refill() {
        this.listModel.removeAllElements();
        RDFResource li = this.getListResource();
        while (li != null && !li.equals(this.getNil())) {
            Instance first = this.getFirst(li);
            if (first != null) {
                this.listModel.addElement(first);
            }
            li = this.getRest(li);
        }
    }

    private void registerPropertyValueListener() {
        RDFResource li = this.getListResource();
        RDFResource nil = this.getNil();
        while (li != null && !nil.equals(li)) {
            li.addPropertyValueListener(this.valueListener);
            this.registeredTo.add(li);
            li = this.getRest(li);
        }
    }

    private void removeListValue(RDFResource resource, RDFProperty property, RDFResource li, int index) {
        if (index == 0) {
            RDFResource rest = this.getRest(li);
            li.setPropertyValue(this.getRestProperty(), null);
            resource.setPropertyValue(property, rest);
            li.delete();
        } else {
            RDFResource pred = null;
            while (index > 0) {
                --index;
                pred = li;
                li = this.getRest(li);
            }
            RDFResource rest = this.getRest(li);
            li.setPropertyValue(this.getRestProperty(), null);
            pred.setPropertyValue(this.getRestProperty(), rest);
            li.delete();
        }
    }

    public void setSelectedRow(int row) {
        this.list.setSelectedIndex(row);
    }

    public void setSubject(RDFResource subject) {
        this.unregisterPropertyValueListener();
        super.setSubject(subject);
        this.registerPropertyValueListener();
        this.updateActions();
    }

    private void swapValues(int a, int b) {
        RDFResource ia = this.getListElement(a);
        RDFResource ib = this.getListElement(b);
        Object ea = ia.getDirectOwnSlotValue(this.getFirstProperty());
        Object eb = ib.getDirectOwnSlotValue(this.getFirstProperty());
        ia.setDirectOwnSlotValue(this.getFirstProperty(), eb);
        ib.setDirectOwnSlotValue(this.getFirstProperty(), ea);
        this.list.setSelectedIndex(b);
    }

    private void updateActions() {
        this.addAction.setEnabled(this.isAddEnabled());
        this.createAction.setEnabled(this.isCreateEnabled());
        this.deleteAction.setEnabled(this.isDeleteEnabled());
        this.moveDownAction.setEnabled(this.isMoveDownEnabled());
        this.moveUpAction.setEnabled(this.isMoveUpEnabled());
        this.removeAction.setEnabled(this.isRemoveEnabled());
    }

    private void unregisterPropertyValueListener() {
        for (RDFResource listInstance : this.registeredTo) {
            listInstance.removePropertyValueListener(this.valueListener);
        }
        this.registeredTo.clear();
    }

    public void valuesChanged() {
        this.unregisterPropertyValueListener();
        this.registerPropertyValueListener();
        this.refill();
        this.updateActions();
    }
}

