/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import edu.stanford.smi.protegex.owl.ui.conditions.tests.AbstractConditionsTableTestCase;

public class FillInheritedTestCase
extends AbstractConditionsTableTestCase {
    public void testInheritedRestrictions() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLMaxCardinality animalRestriction = this.owlModel.createOWLMaxCardinality(property, 100);
        animalCls.addSuperclass(animalRestriction);
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        personCls.addSuperclass(animalCls);
        personCls.removeSuperclass(this.owlModel.getOWLThingClass());
        OWLMaxCardinality personRestriction = this.owlModel.createOWLMaxCardinality(property, 12);
        personCls.addSuperclass(personRestriction);
        OWLNamedClass parentCls = this.owlModel.createOWLNamedClass("Parent");
        parentCls.addSuperclass(personCls);
        parentCls.removeSuperclass(this.owlModel.getOWLThingClass());
        OWLMinCardinality parentRestriction = this.owlModel.createOWLMinCardinality(property, 1);
        parentCls.addSuperclass(parentRestriction);
        ConditionsTableModel tableModel = this.getTableModel(parentCls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, personCls, parentRestriction, INHERITED, personRestriction});
        FillInheritedTestCase.assertEquals((int)-1, (int)tableModel.getType(2));
        FillInheritedTestCase.assertEquals((int)-1, (int)tableModel.getType(3));
        FillInheritedTestCase.assertEquals((Object)personCls, (Object)tableModel.getOriginClass(5));
        FillInheritedTestCase.assertEquals((int)-2, (int)tableModel.getType(5));
    }

    public void testInheritedFromDefinition() {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass maleCls = this.owlModel.createOWLNamedClass("MalePerson");
        maleCls.addSuperclass(personCls);
        maleCls.removeSuperclass(this.owlModel.getOWLThingClass());
        OWLObjectProperty genderProperty = this.owlModel.createOWLObjectProperty("gender");
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(genderProperty, 1);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(animalCls);
        intersectionCls.addOperand(restriction);
        personCls.setDefinition(intersectionCls);
        ConditionsTableModel tableModel = this.getTableModel(maleCls);
        FillInheritedTestCase.assertEquals((int)5, (int)tableModel.getRowCount());
        int i = 2;
        FillInheritedTestCase.assertEquals((Object)personCls, (Object)tableModel.getClass(i));
        FillInheritedTestCase.assertEquals((int)-1, (int)tableModel.getType(i));
        FillInheritedTestCase.assertTrue((boolean)tableModel.isSeparator(++i));
        FillInheritedTestCase.assertEquals((Object)restriction, (Object)tableModel.getClass(++i));
        FillInheritedTestCase.assertEquals((int)-2, (int)tableModel.getType(i));
    }

    public void testDontInheritDuplicatesFromEquivalentCls() {
        OWLNamedClass animalCls = this.owlModel.createOWLNamedClass("Animal");
        OWLNamedClass marsupialCls = this.owlModel.createOWLNamedClass("Marsuipial");
        OWLNamedClass koalaCls = this.owlModel.createOWLNamedClass("Koala");
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        marsupialCls.addSuperclass(animalCls);
        marsupialCls.removeSuperclass(this.owlThing);
        marsupialCls.addEquivalentClass(koalaCls);
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(personCls);
        koalaCls.addSuperclass(complementCls);
        koalaCls.removeSuperclass(this.owlThing);
        ConditionsTableModel tableModel = this.getTableModel(koalaCls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", marsupialCls, NECESSARY, complementCls});
    }

    public void testDontInheritOverloadedAllRestrictions() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass superCls = this.owlModel.createOWLNamedSubclass("Super", this.owlThing);
        superCls.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)property, superCls));
        OWLNamedClass subCls = this.owlModel.createOWLNamedSubclass("Sub", superCls);
        subCls.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)property, subCls));
        ConditionsTableModel tableModel = this.getTableModel(subCls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, superCls, OWLAllValuesFrom.class});
    }

    public void testInheritUnrelatedAllRestrictions() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass clsA = this.owlModel.createOWLNamedSubclass("A", this.owlThing);
        clsA.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)property, clsA));
        OWLNamedClass clsB = this.owlModel.createOWLNamedSubclass("B", this.owlThing);
        clsB.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)property, clsB));
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("C", clsA);
        cls.addSuperclass(clsB);
        ConditionsTableModel tableModel = this.getTableModel(cls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, clsA, clsB, INHERITED, OWLAllValuesFrom.class, OWLAllValuesFrom.class});
    }

    public void testInheritHasRestrictions() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass superCls = this.owlModel.createOWLNamedSubclass("Super", this.owlThing);
        RDFResource superInstance = superCls.createInstance("mySuper");
        superCls.addSuperclass(this.owlModel.createOWLHasValue(property, superInstance));
        OWLNamedClass subCls = this.owlModel.createOWLNamedSubclass("Sub", superCls);
        RDFResource subInstance = superCls.createInstance("mySub");
        subCls.addSuperclass(this.owlModel.createOWLHasValue(property, subInstance));
        ConditionsTableModel tableModel = this.getTableModel(subCls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, superCls, OWLHasValue.class, INHERITED, OWLHasValue.class});
    }

    public void testInheritParallelSomeRestrictions() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("Other");
        OWLNamedClass superCls = this.owlModel.createOWLNamedSubclass("Super", this.owlThing);
        superCls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, otherCls));
        OWLNamedClass subCls = this.owlModel.createOWLNamedSubclass("Sub", superCls);
        subCls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, subCls));
        ConditionsTableModel tableModel = this.getTableModel(subCls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, superCls, OWLSomeValuesFrom.class, INHERITED, OWLSomeValuesFrom.class});
    }

    public void testInheritSpecializingSomeRestrictions() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass superCls = this.owlModel.createOWLNamedSubclass("Super", this.owlThing);
        superCls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, superCls));
        OWLNamedClass subCls = this.owlModel.createOWLNamedSubclass("Sub", superCls);
        subCls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, subCls));
        ConditionsTableModel tableModel = this.getTableModel(subCls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, superCls, OWLSomeValuesFrom.class});
    }

    public void testInheritEqualSomeRestriction() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass superCls = this.owlModel.createOWLNamedSubclass("Super", this.owlThing);
        superCls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, superCls));
        OWLNamedClass subCls = this.owlModel.createOWLNamedSubclass("Sub", superCls);
        subCls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, superCls));
        ConditionsTableModel tableModel = this.getTableModel(subCls);
        this.assertTableModelStructure(tableModel, new Object[]{"SUFFICIENT", NECESSARY, superCls, OWLSomeValuesFrom.class});
    }
}

