/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.dialogs;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.dialogs.AbstractModalDialogFactory;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialog;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialogFactory;
import java.awt.Component;
import javax.swing.JOptionPane;

public class DefaultModalDialogFactory
extends AbstractModalDialogFactory {
    public void attemptDialogClose(int result) {
        ModalDialog.attemptDialogClose(result);
    }

    private Component getParentComponent(OWLModel owlModel) {
        if (owlModel == null) {
            return Application.getMainWindow();
        }
        Object comp = ProtegeUI.getProjectView(owlModel.getProject());
        if (comp == null) {
            comp = Application.getMainWindow();
        }
        return comp;
    }

    public int showConfirmCancelDialog(OWLModel owlModel, String message, String title) {
        Component parentComponent = this.getParentComponent(owlModel);
        return this.showConfirmCancelDialog(parentComponent, message, title);
    }

    public int showConfirmCancelDialog(Component parent, String message, String title) {
        int result = JOptionPane.showConfirmDialog(parent, message, title, 1);
        if (result == 1) {
            return 3;
        }
        if (result == 0) {
            return 2;
        }
        return 4;
    }

    public boolean showConfirmDialog(OWLModel owlModel, String message, String title) {
        Component parentComponent = this.getParentComponent(owlModel);
        return this.showConfirmDialog(parentComponent, message, title);
    }

    public boolean showConfirmDialog(Component parent, String message, String title) {
        return JOptionPane.showConfirmDialog(parent, message, title, 0) == 0;
    }

    public int showDialog(Component parent, Component panel, String title, int mode, ModalDialogFactory.CloseCallback callback, boolean enableCloseButton) {
        return ModalDialog.showDialog(parent, panel, title, mode, callback, enableCloseButton);
    }

    public void showErrorMessageDialog(OWLModel owlModel, String message, String title) {
        Component parentComponent = this.getParentComponent(owlModel);
        this.showErrorMessageDialog(parentComponent, message, title);
    }

    public void showErrorMessageDialog(Component parent, String message, String title) {
        JOptionPane.showMessageDialog(parent, message, title, 0);
    }

    public String showInputDialog(OWLModel owlModel, String message, String initialValue) {
        Component parentComponent = this.getParentComponent(owlModel);
        return this.showInputDialog(parentComponent, message, initialValue);
    }

    public String showInputDialog(Component parent, String message, String initialValue) {
        if (initialValue == null) {
            initialValue = "";
        }
        return JOptionPane.showInputDialog(parent, message, initialValue);
    }

    public void showMessageDialog(OWLModel owlModel, String message, String title) {
        Component parentComponent = this.getParentComponent(owlModel);
        this.showMessageDialog(parentComponent, message, title);
    }

    public void showMessageDialog(Component parent, String message, String title) {
        JOptionPane.showMessageDialog(parent, message, title, 1);
    }
}

