/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.editors;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialogFactory;
import edu.stanford.smi.protegex.owl.ui.editors.DateValueEditor;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.JFormattedTextField;

public class TimeValueEditor
implements PropertyValueEditor {
    public boolean canEdit(RDFResource instance, RDFProperty property, Object value) {
        return DateValueEditor.canEdit(instance.getOWLModel().getXSDtime(), instance, property, value);
    }

    public Object createDefaultValue(RDFResource instance, RDFProperty property) {
        OWLModel owlModel = property.getOWLModel();
        String str = XMLSchemaDatatypes.getTimeString(new Date());
        return this.createRDFSLiteral(owlModel, str);
    }

    private RDFSLiteral createRDFSLiteral(OWLModel owlModel, String str) {
        return owlModel.createRDFSLiteral(str, owlModel.getRDFSDatatypeByURI(XSDDatatype.XSDtime.getURI()));
    }

    public Object editValue(Component parent, RDFResource instance, RDFProperty property, Object value) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        final JFormattedTextField field = new JFormattedTextField(format);
        try {
            Date date = format.parse(value.toString());
            field.setValue(date);
            String name = property.getBrowserText();
            name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
            LabeledComponent lc = new LabeledComponent(name, (Component)field);
            int r = ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(property.getProject()), (Component)lc, "Edit " + property.getBrowserText(), 11, new ModalDialogFactory.CloseCallback(){

                public boolean canClose(int result) {
                    return field.isEditValid();
                }
            });
            if (r == 1) {
                Date newDate = (Date)field.getValue();
                String str = XMLSchemaDatatypes.getTimeString(newDate);
                return this.createRDFSLiteral(property.getOWLModel(), str);
            }
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
        }
        return null;
    }

    public boolean mustEdit(RDFResource subject, RDFProperty predicate, Object value) {
        return this.canEdit(subject, predicate, value);
    }
}

