/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.matrix.AnnotationPropertyMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixFilter;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixTable;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixTableModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JScrollPane;

public class MatrixPanel
extends ResultsPanel {
    private ResourceSelectionAction addAnnotationPropertyAction = new ResourceSelectionAction("Add column for annotation property...", OWLIcons.getAddIcon("AnnotationOWLDatatypeProperty")){

        public void resourceSelected(RDFResource resource) {
            MatrixPanel.this.addAnnotationProperty((RDFProperty)resource);
        }

        public RDFResource pickResource() {
            return ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(MatrixPanel.this, MatrixPanel.this.getOWLModel(), this.getSelectableResources(), "Select annotation property");
        }

        public Collection getSelectableResources() {
            ArrayList results = new ArrayList(MatrixPanel.this.owlModel.getOWLAnnotationProperties());
            results.removeAll(MatrixPanel.this.tableModel.getVisibleAnnotationProperties());
            Iterator it = results.iterator();
            while (it.hasNext()) {
                RDFProperty property = (RDFProperty)it.next();
                if (property instanceof OWLDatatypeProperty) continue;
                it.remove();
            }
            return results;
        }
    };
    private MatrixFilter filter;
    private OWLModel owlModel;
    private MatrixTable table;
    private MatrixTableModel tableModel;

    public MatrixPanel(OWLModel owlModel, MatrixFilter filter, MatrixTableModel tableModel) {
        super(owlModel);
        this.filter = filter;
        this.owlModel = owlModel;
        this.tableModel = tableModel;
        this.table = this.createMatrixTable(tableModel);
        this.addRefreshButton();
        this.addAnnotationButtons();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(this.table.getBackground());
        this.setCenterComponent(scrollPane);
    }

    private void addRefreshButton() {
        AbstractAction refreshAction = new AbstractAction("Refresh", OWLIcons.getImageIcon("Refresh")){

            public void actionPerformed(ActionEvent e) {
                MatrixPanel.this.refresh();
            }
        };
        this.addButton(refreshAction);
    }

    private void addAnnotationButtons() {
        JButton addButton = this.addButton(this.addAnnotationPropertyAction);
        this.addAnnotationPropertyAction.activateComboBox(addButton);
    }

    private void addAnnotationProperty(RDFProperty property) {
        AnnotationPropertyMatrixColumn col = new AnnotationPropertyMatrixColumn(property);
        this.table.addColumn(col);
    }

    protected MatrixTable createMatrixTable(MatrixTableModel tableModel) {
        return new MatrixTable(tableModel);
    }

    public void dispose() {
        super.dispose();
        this.tableModel.dispose();
    }

    public MatrixTable getTable() {
        return this.table;
    }

    public MatrixTableModel getTableModel() {
        return this.tableModel;
    }

    public String getTabName() {
        return this.filter.getName();
    }

    private void refresh() {
        this.tableModel.refill();
    }
}

