/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix.cls;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixFilter;
import edu.stanford.smi.protegex.owl.ui.matrix.cls.ClassMatrixPanel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;

public class ClassMatrixAction
extends AbstractAction {
    private OWLModel owlModel;

    public ClassMatrixAction(OWLModel owlModel) {
        super("Show matrix of all classes", OWLIcons.getImageIcon("ClassMatrix"));
        this.owlModel = owlModel;
    }

    public void actionPerformed(ActionEvent e) {
        if (!OWLUI.isConfirmationNeeded(this.owlModel) || OWLUI.isConfirmed(this.owlModel, this.owlModel.getClsCount() > OWLUI.getConfirmationThreshold(this.owlModel))) {
            this.performAction();
        }
    }

    private void performAction() {
        MatrixFilter filter = new MatrixFilter(){

            public Collection getInitialValues() {
                Collection clses = ClassMatrixAction.this.owlModel.getUserDefinedOWLNamedClasses();
                Iterator it = clses.iterator();
                while (it.hasNext()) {
                    RDFSNamedClass aClass = (RDFSNamedClass)it.next();
                    if (this.isSuitable(aClass)) continue;
                    it.remove();
                }
                return clses;
            }

            public String getName() {
                return "All Classes";
            }

            public boolean isSuitable(RDFResource instance) {
                return instance instanceof RDFSNamedClass && instance.isVisible() && (instance.isEditable() || instance.isIncluded());
            }
        };
        ClassMatrixPanel panel = new ClassMatrixPanel(this.owlModel, filter);
        ResultsPanelManager.addResultsPanel(this.owlModel, panel, true);
    }
}

