/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix.cls;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.matrix.DependentMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.table.TableCellRenderer;

public class ExistentialMatrixColumn
implements DependentMatrixColumn,
MatrixColumn {
    private RDFProperty property;

    public ExistentialMatrixColumn(RDFProperty property) {
        this.property = property;
    }

    public TableCellRenderer getCellRenderer() {
        return new FrameRenderer(){

            protected void loadCls(Cls cls) {
                if (cls instanceof OWLNamedClass) {
                    Collection cs = ExistentialMatrixColumn.this.getMatchingRestrictions((OWLNamedClass)cls);
                    this.setGrayedSecondaryText(false);
                    Iterator it = cs.iterator();
                    while (it.hasNext()) {
                        OWLSomeValuesFrom someRestriction = (OWLSomeValuesFrom)it.next();
                        this.addText(someRestriction.getFillerText());
                        if (!it.hasNext()) continue;
                        this.addText(", ");
                    }
                }
            }
        };
    }

    private Collection getMatchingRestrictions(OWLNamedClass cls) {
        ArrayList<Cls> result = new ArrayList<Cls>();
        if (cls.getDefinition() == null) {
            for (Cls superCls : cls.getSuperclasses(false)) {
                if (!(superCls instanceof OWLSomeValuesFrom) || !this.property.equals(((OWLSomeValuesFrom)superCls).getOnProperty())) continue;
                result.add(superCls);
            }
        }
        return result;
    }

    public String getName() {
        return "\u2203 " + this.property.getBrowserText();
    }

    public RDFProperty getProperty() {
        return this.property;
    }

    public int getWidth() {
        return 200;
    }

    public boolean isDependentOn(RDFResource instance) {
        return this.property.equals(instance);
    }
}

