/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadata;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.PropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.metadata.AnnotationTextAreaWidget;
import edu.stanford.smi.protegex.owl.ui.metadata.NameDocumentationWidget;
import edu.stanford.smi.protegex.owl.ui.metadata.OWLMetadataWidget;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyValuesWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import java.awt.Component;

public class AnnotationsWidget
extends AbstractPropertyValuesWidget {
    protected PropertyValuesComponent createComponent(RDFProperty predicate) {
        return new AnnotationsComponent(predicate){

            protected void handleSelectionChanged() {
                super.handleSelectionChanged();
                this.updateTextAreaWidget();
            }

            private void updateTextAreaWidget() {
                ClsWidget clsWidget = AnnotationsWidget.this.getClsWidget();
                if (clsWidget != null) {
                    OWLModel owlModel = this.getOWLModel();
                    TriplesTableModel tableModel = this.getTableModel();
                    Slot nameSlot = owlModel.getSlot(":NAME");
                    SlotWidget slotWidget = clsWidget.getSlotWidget(nameSlot);
                    if (slotWidget instanceof OWLMetadataWidget) {
                        NameDocumentationWidget ndw = ((OWLMetadataWidget)slotWidget).getNameDocumentationWidget();
                        AnnotationTextAreaWidget ataw = ndw.getAnnotationTextAreaWidget();
                        int row = this.getTable().getSelectedRow();
                        if (row >= 0) {
                            RDFResource range;
                            RDFProperty selectedProperty = tableModel.getPredicate(row);
                            if (selectedProperty instanceof OWLDatatypeProperty && ((range = selectedProperty.getRange()) == null || owlModel.getXSDstring().equals(range) || owlModel.getRDFXMLLiteralType().equals(range))) {
                                OWLDatatypeProperty property = (OWLDatatypeProperty)selectedProperty;
                                String language = tableModel.getLanguage(row);
                                Object v = tableModel.getDisplayValue(row);
                                if (v instanceof String) {
                                    String value = (String)v;
                                    ataw.setEditedValue(property, value, language, tableModel.getValue(row));
                                }
                            }
                        } else {
                            ataw.resetEditedValue();
                        }
                    }
                }
            }
        };
    }

    public static void editAnnotations(Component parent, RDFResource instance) {
        AnnotationsWidget widget = new AnnotationsWidget();
        widget.setup(null, false, instance.getProject());
        widget.initialize();
        widget.setCls(instance.getOWLModel().getOWLThingClass());
        widget.setInstance(instance);
        ProtegeUI.getModalDialogFactory().showDialog(parent, (Component)((Object)widget), "Annotations", 14);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return OWLWidgetMapper.isSuitable(AnnotationsWidget.class, cls, slot);
    }
}

