/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ImportsTableModel
extends AbstractTableModel
implements Disposable {
    public static final int COL_URI = 0;
    public static final int COL_COUNT = 1;
    private PropertyValueListener listener = new PropertyValueAdapter(){

        public void propertyValueChanged(RDFResource resource, RDFProperty property, Collection oldValues) {
            if ("owl:imports".equals(property.getName())) {
                ImportsTableModel.this.refill();
            }
        }
    };
    private OWLOntology ontology;
    private List uris = new ArrayList();

    public ImportsTableModel(OWLOntology ontology) {
        this.ontology = ontology;
        ontology.addPropertyValueListener(this.listener);
        this.uris = new ArrayList(ontology.getImports());
    }

    public void addImport(String uri) {
        this.ontology.addImports(uri);
    }

    public void deleteRow(int row) {
        String uri = this.getURI(row);
        this.ontology.removeImports(uri);
    }

    public void dispose() {
        this.ontology.removePropertyValueListener(this.listener);
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Imported URI";
        }
        return null;
    }

    public NamespaceManager getNamespaceManager() {
        return this.ontology.getOWLModel().getNamespaceManager();
    }

    OWLModel getOWLModel() {
        return this.ontology.getOWLModel();
    }

    public int getRowCount() {
        return this.uris.size();
    }

    public String getURI(int row) {
        return (String)this.uris.get(row);
    }

    public int getURIRow(String uri) {
        return this.uris.indexOf(uri);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.getURI(rowIndex);
        }
        return null;
    }

    private void refill() {
        this.uris = new ArrayList(this.ontology.getImports());
        this.fireTableDataChanged();
    }
}

