/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports.emptyimport;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.repository.impl.LocalFileRepository;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.emptyimport.EmptyImportExplanationPage;
import edu.stanford.smi.protegex.owl.ui.wizard.OWLWizard;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.logging.Level;
import javax.swing.JComponent;

public class EmptyImportWizard
extends OWLWizard {
    private URI ontologyURI;
    private File localFile;
    private OWLModel owlModel;

    public EmptyImportWizard(JComponent parent, OWLModel owlModel) {
        super(parent, "Empty Import");
        this.owlModel = owlModel;
        this.addPage(new EmptyImportExplanationPage(this, owlModel));
    }

    protected void onFinish() {
        super.onFinish();
        try {
            if (this.localFile != null && this.ontologyURI != null) {
                JenaOWLModel model = ProtegeOWL.createJenaOWLModel();
                model.getNamespaceManager().setDefaultNamespace(this.ontologyURI + "#");
                OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(this.localFile));
                OWLModelWriter writer = new OWLModelWriter((OWLModel)model, model.getTripleStoreModel().getActiveTripleStore(), osw);
                writer.write();
                osw.flush();
                osw.close();
                RepositoryManager rm = this.owlModel.getRepositoryManager();
                rm.addProjectRepository(new LocalFileRepository(this.localFile));
                ImportHelper importHelper = new ImportHelper((JenaOWLModel)this.owlModel);
                importHelper.addImport(this.ontologyURI);
                importHelper.importOntologies();
            }
        }
        catch (Exception e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public URI getOntologyURI() {
        return this.ontologyURI;
    }

    public void setOntologyURI(URI ontologyURI) {
        this.ontologyURI = ontologyURI;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(File localFile) {
        this.localFile = localFile;
    }
}

