/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.range;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSDatatype;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.properties.range.ExInclusiveToggleAction;
import edu.stanford.smi.protegex.owl.ui.properties.range.FacetsPanel;
import edu.stanford.smi.protegex.owl.ui.properties.range.OWLRangeWidget;
import edu.stanford.smi.protegex.owl.ui.widget.AssigningTextField;
import java.awt.Component;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class NumericFacetsPanel
extends FacetsPanel
implements ExInclusiveToggleAction.Callback {
    private ExInclusiveToggleAction maxAction;
    private JTextField maxTextField = new AssigningTextField(new AssigningTextField.Assign(){

        public void assign(String value) {
            NumericFacetsPanel.this.assignInterval(false);
        }
    });
    private ExInclusiveToggleAction minAction;
    private JTextField minTextField = new AssigningTextField(new AssigningTextField.Assign(){

        public void assign(String value) {
            NumericFacetsPanel.this.assignInterval(false);
        }
    });

    public NumericFacetsPanel(OWLRangeWidget rangeWidget) {
        super(rangeWidget);
        this.maxTextField.setHorizontalAlignment(4);
        this.minTextField.setHorizontalAlignment(4);
        JToolBar mainPanel = ComponentFactory.createToolBar();
        this.maxAction = new ExInclusiveToggleAction("Toggle between ] and ), which mean <= or <", "XSDMaxExclusive", "XSDMaxInclusive", this);
        this.minAction = new ExInclusiveToggleAction("Toggle between [ and (, which mean >= or >", "XSDMinExclusive", "XSDMinInclusive", this);
        ComponentFactory.addToolBarButton((JToolBar)mainPanel, (Action)this.minAction);
        mainPanel.add(this.minTextField);
        mainPanel.add(new JLabel("  "));
        mainPanel.add(this.maxTextField);
        ComponentFactory.addToolBarButton((JToolBar)mainPanel, (Action)this.maxAction);
        OWLLabeledComponent lc = new OWLLabeledComponent("Range Interval (Min/Max)", mainPanel);
        this.add("Center", (Component)((Object)lc));
    }

    public void assignInterval() {
        this.assignInterval(true);
    }

    public void assignInterval(boolean force) {
        RDFResource range = this.rangeWidget.getEditedProperty().getRange();
        if (range instanceof RDFSDatatype) {
            RDFSDatatype datatype = (RDFSDatatype)range;
            String newMinText = this.minTextField.getText();
            String newMaxText = this.maxTextField.getText();
            if (force || !newMaxText.equals(this.getMaxText(datatype)) || !newMinText.equals(this.getMinText(datatype))) {
                String expression = String.valueOf(this.minAction.isExclusive() ? "(" : "[") + newMinText + "," + newMaxText + (this.maxAction.isExclusive() ? ")" : "]");
                if (datatype.isAnonymous()) {
                    datatype = datatype.getBaseDatatype();
                }
                expression = String.valueOf(datatype.getName()) + expression;
                OWLModel owlModel = this.rangeWidget.getOWLModel();
                Map map = DefaultRDFSDatatype.parse(owlModel, expression);
                if (map.size() > 0) {
                    String name = owlModel.getNextAnonymousResourceName();
                    RDFSDatatype newDatatype = owlModel.createRDFSDatatype(name);
                    for (RDFProperty property : map.keySet()) {
                        Object value = map.get(property);
                        newDatatype.setPropertyValue(property, value);
                    }
                    this.rangeWidget.setRange(newDatatype);
                } else {
                    this.rangeWidget.setRange(datatype);
                }
            }
        }
    }

    private String getMinText(RDFSDatatype datatype) {
        RDFSLiteral min = datatype.getMinInclusive();
        if (min == null) {
            min = datatype.getMinExclusive();
        }
        return min == null ? "" : min.toString();
    }

    private String getMaxText(RDFSDatatype datatype) {
        RDFSLiteral max = datatype.getMaxInclusive();
        if (max == null) {
            max = datatype.getMaxExclusive();
        }
        return max == null ? "" : max.toString();
    }

    public void setEditable(boolean value) {
        this.minAction.setEnabled(value);
        this.maxAction.setEnabled(value);
        this.minTextField.setEditable(value);
        this.maxTextField.setEditable(value);
    }

    public void update(RDFSDatatype datatype) {
        if (datatype.isAnonymous()) {
            String maxText = this.getMaxText(datatype);
            this.maxTextField.setText(maxText);
            String minText = this.getMinText(datatype);
            this.minTextField.setText(minText);
            this.minAction.setExclusive(datatype.getMinExclusive() != null);
            this.maxAction.setExclusive(datatype.getMaxExclusive() != null);
        } else {
            this.minTextField.setText("");
            this.maxTextField.setText("");
        }
    }
}

