/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository.action;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.impl.FTPRepository;
import edu.stanford.smi.protegex.owl.ui.repository.AbstractRepositoriesPanel;
import edu.stanford.smi.protegex.owl.ui.repository.action.RepositoryAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class RepositoryActionManager {
    private static RepositoryActionManager instance;
    private HashSet actions = new HashSet();

    private RepositoryActionManager() {
        this.actions.add(new RepositoryAction(){

            public String getName() {
                return "Refresh repository";
            }

            public boolean isSuitable(Repository repository, OWLModel owlModel) {
                return true;
            }

            public void actionPerformed(Repository repository, AbstractRepositoriesPanel repositoriesPanel, OWLModel model) {
                repository.refresh();
                repositoriesPanel.reloadUI();
            }
        });
        this.actions.add(new RepositoryAction(){

            public String getName() {
                return "Upload using FTP";
            }

            public boolean isSuitable(Repository repository, OWLModel owlModel) {
                return repository instanceof FTPRepository;
            }

            public void actionPerformed(Repository repository, AbstractRepositoriesPanel repositoriesPanel, OWLModel model) {
                FTPRepository rep = (FTPRepository)repository;
                rep.ftpPut();
            }
        });
    }

    public static synchronized RepositoryActionManager getInstance() {
        if (instance == null) {
            instance = new RepositoryActionManager();
        }
        return instance;
    }

    public Collection getActions(Repository repository, OWLModel owlModel) {
        ArrayList<RepositoryAction> suitableActions = new ArrayList<RepositoryAction>();
        for (RepositoryAction curAction : this.actions) {
            if (!curAction.isSuitable(repository, owlModel)) continue;
            suitableActions.add(curAction);
        }
        return suitableActions;
    }
}

