/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourcedisplay;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplayPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JPanel;

public class ResourceDisplayPluginManager {
    private static Map map = new HashMap();
    private static Set userDefinedClasses = new HashSet();

    public static void addInstanceDisplayPluginClass(Class clazz) {
        userDefinedClasses.add(clazz);
    }

    public static ResourceDisplayPlugin getInstanceDisplayPlugin(Class clazz) {
        ResourceDisplayPlugin plugin = (ResourceDisplayPlugin)map.get(clazz);
        if (plugin == null) {
            try {
                plugin = (ResourceDisplayPlugin)clazz.newInstance();
                map.put(clazz, plugin);
            }
            catch (Exception ex) {
                System.err.println("[ResourceDisplayPluginManager] Fatal Error: Could not create Plugin for " + clazz);
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
        }
        return plugin;
    }

    public static Class[] getInstanceDisplayPluginClasses() {
        ArrayList clses = new ArrayList(PluginUtilities.getClassesWithAttribute((String)"ResourceDisplayPlugin", (String)"True"));
        clses.addAll(userDefinedClasses);
        Class[] classes = clses.toArray(new Class[0]);
        Arrays.sort(classes, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof Class && o2 instanceof Class) {
                    return ((Class)o1).getName().compareTo(((Class)o2).getName());
                }
                return 0;
            }
        });
        return classes;
    }

    public static void initInstanceDisplay(RDFResource frame, JPanel hostPanel) {
        Class[] classes = ResourceDisplayPluginManager.getInstanceDisplayPluginClasses();
        int i = 0;
        while (i < classes.length) {
            Class c = classes[i];
            ResourceDisplayPlugin plugin = ResourceDisplayPluginManager.getInstanceDisplayPlugin(c);
            if (plugin != null) {
                plugin.initResourceDisplay(frame, hostPanel);
            }
            ++i;
        }
    }
}

