/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourceselection;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextField;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceIgnoreCaseComparator;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class ResourceFilterListModel
extends AbstractListModel
implements ComboBoxModel {
    private Frame[] frames;
    private String prefix = "";
    private Frame selectedFrame;
    private int validStart = 0;
    private int validCount;

    public ResourceFilterListModel(Collection frames) {
        this.frames = frames.toArray(new Frame[0]);
        Arrays.sort(this.frames, new ResourceIgnoreCaseComparator());
        this.validCount = this.frames.length;
        if (frames.size() > 0) {
            this.selectedFrame = this.frames[0];
        }
    }

    public void addChar(char ch) {
        if (OWLTextField.isIdChar(ch)) {
            this.prefix = String.valueOf(this.prefix) + Character.toLowerCase(ch);
            this.updateList();
        }
    }

    public void backspace() {
        int len = this.prefix.length();
        if (len > 0) {
            this.prefix = this.prefix.substring(0, len - 1);
            this.updateList();
        }
    }

    protected int findFirstMatchingFrame() {
        int i = 0;
        while (i < this.frames.length) {
            Frame frame = this.frames[i];
            String name = frame.getBrowserText();
            if (name.toLowerCase().startsWith(this.prefix)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private int findMatchingFrameCount(int startIndex) {
        int i = startIndex;
        while (i < this.frames.length) {
            Frame frame = this.frames[i];
            String name = frame.getBrowserText();
            if (!name.toLowerCase().startsWith(this.prefix)) {
                return i - startIndex;
            }
            ++i;
        }
        return this.frames.length - startIndex;
    }

    public Object getElementAt(int index) {
        return this.frames[index + this.validStart];
    }

    public int getPrefixLength() {
        return this.prefix.length();
    }

    public Object getSelectedItem() {
        return this.selectedFrame;
    }

    public int getSize() {
        return this.validCount;
    }

    public void setSelectedItem(Object anItem) {
        if (anItem instanceof Frame && (this.selectedFrame != null && this.selectedFrame != anItem || this.selectedFrame == null && anItem != null)) {
            this.selectedFrame = (Frame)anItem;
        }
    }

    private void updateList() {
        this.validCount = 0;
        this.fireIntervalRemoved(this, 0, this.validCount);
        if (this.prefix.length() > 0) {
            this.validStart = this.findFirstMatchingFrame();
            this.validCount = this.findMatchingFrameCount(this.validStart);
        } else {
            this.validStart = 0;
            this.validCount = this.frames.length;
        }
        this.selectedFrame = this.validCount > 0 ? this.frames[this.validStart] : null;
        this.fireIntervalAdded(this, 0, this.validCount);
    }
}

