/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.search.finder.BasicFind;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ThreadedFind
extends BasicFind {
    Thread searchThread;
    DoFind currentfind;

    public ThreadedFind(OWLModel owlModel, int type) {
        super(owlModel, type);
    }

    public void startSearch(String s, int type) {
        this.string = s;
        this.searchType = type;
        this.currentfind = new DoFind();
        this.searchThread = new Thread(this.currentfind);
        this.searchThread.start();
    }

    public void cancelSearch() {
        if (this.searchThread != null && this.searchThread.isAlive()) {
            this.currentfind.stop();
        }
        super.cancelSearch();
    }

    class DoFind
    implements Runnable {
        private boolean allowRun;

        DoFind() {
        }

        public void stop() {
            this.allowRun = false;
        }

        public void run() {
            ThreadedFind.this.results.clear();
            this.allowRun = true;
            ThreadedFind.this.notifySearchStarted();
            if (ThreadedFind.this.string != null && ThreadedFind.this.string.length() > 0) {
                List searchProps = ThreadedFind.this.getSearchProperties();
                Iterator i = searchProps.iterator();
                while (i.hasNext() && this.allowRun) {
                    Map res = ThreadedFind.this.searchOnSlot((Slot)i.next(), ThreadedFind.this.string, null, ThreadedFind.this.searchType);
                    ThreadedFind.this.results.putAll(res);
                    ThreadedFind.this.notifyResultsUpdated();
                }
                String lang = ThreadedFind.this.owlModel.getDefaultLanguage();
                if (lang != null) {
                    Iterator i2 = searchProps.iterator();
                    while (i2.hasNext() && this.allowRun) {
                        Slot slot = (Slot)i2.next();
                        if (slot.equals(ThreadedFind.this.owlModel.getNameSlot())) continue;
                        Map res = ThreadedFind.this.searchOnSlot(slot, ThreadedFind.this.string, lang, ThreadedFind.this.searchType);
                        ThreadedFind.this.results.putAll(res);
                        ThreadedFind.this.notifyResultsUpdated();
                    }
                }
            }
            if (this.allowRun) {
                ThreadedFind.this.notifySearchComplete();
            } else {
                ThreadedFind.this.notifySearchCancelled();
            }
        }
    }
}

