/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.AbstractTriplesComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class HeaderWidget
extends AbstractSlotWidget {
    private AbstractTriplesComponent component;

    public void activate(AbstractTriplesComponent newComponent) {
        if (this.component != null) {
            this.removeAll();
            ComponentUtilities.dispose((Component)this.component);
        }
        this.component = newComponent;
        this.component.setSubject((RDFResource)this.getInstance());
        this.add("Center", this.component);
        this.revalidate();
    }

    public void activateAnnotationsComponent() {
        RDFProperty property = (RDFProperty)this.getSlot();
        this.activate(new AnnotationsComponent(property){

            protected void addButtons(LabeledComponent lc) {
                super.addButtons(lc);
                lc.addHeaderSeparator();
                lc.addHeaderSeparator();
                lc.addHeaderButton((Action)new AbstractAction("Switch to Triples", OWLIcons.getImageIcon("Triples")){

                    public void actionPerformed(ActionEvent e) {
                        HeaderWidget.this.activateTriplesComponent();
                    }
                });
            }
        });
    }

    public void activateTriplesComponent() {
        RDFProperty property = (RDFProperty)this.getSlot();
        this.activate(new TriplesComponent(property){

            protected void addButtons(LabeledComponent lc) {
                super.addButtons(lc);
                lc.addHeaderSeparator();
                lc.addHeaderSeparator();
                lc.addHeaderButton((Action)new AbstractAction("Switch to Annotations", OWLIcons.getImageIcon("AnnotationsTable")){

                    public void actionPerformed(ActionEvent e) {
                        HeaderWidget.this.activateAnnotationsComponent();
                    }
                });
            }
        });
    }

    public void initialize() {
        this.setLayout(new BorderLayout());
        this.activateAnnotationsComponent();
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return OWLWidgetMapper.isSuitable(HeaderWidget.class, cls, slot);
    }

    public void setInstance(Instance newInstance) {
        super.setInstance(newInstance);
        if (newInstance instanceof RDFResource) {
            RDFResource resource = (RDFResource)newInstance;
            this.component.setSubject(resource);
        }
    }
}

