/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.renderer;

import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFExternalResource;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import edu.stanford.smi.protegex.owl.model.visitor.Visitable;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.Util;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;

public class RDFResourceRenderer
extends OWLModelVisitorAdapter {
    private Visitable resource;
    private XMLWriter writer;
    private TripleStore tripleStore;

    public RDFResourceRenderer(Visitable rdfResource, TripleStore tripleStore, XMLWriter writer) {
        this.resource = rdfResource;
        this.tripleStore = tripleStore;
        this.writer = writer;
    }

    public void write() {
        this.resource.accept(this);
    }

    public void visitOWLAllValuesFrom(OWLAllValuesFrom owlAllValuesFrom) {
        this.renderQuantifierRestriction(owlAllValuesFrom, "owl:allValuesFrom");
    }

    public void visitOWLAllDifferent(OWLAllDifferent owlAllDifferent) {
        try {
            this.writer.writeStartElement("owl:AllDifferent");
            this.writer.writeStartElement("owl:distinctMembers");
            this.writer.writeAttribute("rdf:parseType", "Collection");
            for (RDFResource curRes : owlAllDifferent.getDistinctMembers()) {
                curRes.accept(this);
            }
            this.writer.writeEndElement();
            this.insertProperties(owlAllDifferent);
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void visitOWLOntology(OWLOntology owlOntology) {
        try {
            this.writer.writeStartElement("owl:Ontology");
            this.writer.writeAttribute("rdf:about", Util.getResourceAttributeName(owlOntology, this.writer));
            this.insertProperties(owlOntology);
            for (String curImp : owlOntology.getImports()) {
                this.writer.writeStartElement("owl:imports");
                this.writer.writeAttribute("rdf:resource", curImp);
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void visitOWLCardinality(OWLCardinality owlCardinality) {
        this.renderCardinalityRestriction(owlCardinality, "owl:cardinality");
    }

    public void visitOWLComplementClass(OWLComplementClass owlComplementClass) {
        try {
            this.writer.writeStartElement("owl:Class");
            this.writer.writeStartElement("owl:complementOf");
            RDFSClass complement = owlComplementClass.getComplement();
            Util.inlineObject(complement, this.tripleStore, this.writer);
            this.writer.writeEndElement();
            this.insertProperties(owlComplementClass);
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void visitOWLEnumeratedClass(OWLEnumeratedClass owlEnumeratedClass) {
        try {
            this.writer.writeStartElement("owl:Class");
            this.writer.writeStartElement("owl:oneOf");
            this.writer.writeAttribute("rdf:parseType", "Collection");
            TreeSet values = new TreeSet(new FrameComparator());
            values.addAll(owlEnumeratedClass.getOneOf());
            for (RDFResource resource : values) {
                new RDFResourceRenderer(resource, this.tripleStore, this.writer).write();
            }
            this.writer.writeEndElement();
            this.insertProperties(owlEnumeratedClass);
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void visitOWLHasValue(OWLHasValue owlHasValue) {
        try {
            this.writeRestrictionStart(owlHasValue);
            this.writer.writeStartElement("owl:hasValue");
            Object value = owlHasValue.getHasValue();
            if (value instanceof RDFResource) {
                Util.inlineObject((RDFResource)value, this.tripleStore, this.writer);
            } else {
                RDFSLiteral litVal = owlHasValue.getOWLModel().asRDFSLiteral(value);
                if (litVal.getLanguage() == null) {
                    this.writer.writeAttribute("rdf:datatype", litVal.getDatatype().getURI());
                } else {
                    this.writer.writeAttribute("xml:lang", litVal.getLanguage());
                }
                this.writer.writeTextContent(litVal.toString());
            }
            this.writer.writeEndElement();
            this.insertProperties(owlHasValue);
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void visitOWLIndividual(OWLIndividual owlIndividual) {
        try {
            if (!owlIndividual.isAnonymous()) {
                this.writer.writeStartElement("rdf:Description");
                Util.insertAboutAttribute(owlIndividual, this.writer);
            } else {
                this.writer.writeStartElement("rdf:Description");
                Util.renderTypes(owlIndividual, this.tripleStore, owlIndividual.getOWLModel().getOWLThingClass(), this.writer);
                this.insertProperties(owlIndividual);
            }
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void visitOWLIntersectionClass(OWLIntersectionClass owlIntersectionClass) {
        this.renderNAryLogicalClass(owlIntersectionClass, "owl:intersectionOf");
    }

    public void visitOWLMaxCardinality(OWLMaxCardinality owlMaxCardinality) {
        this.renderCardinalityRestriction(owlMaxCardinality, "owl:maxCardinality");
    }

    public void visitOWLMinCardinality(OWLMinCardinality owlMinCardinality) {
        this.renderCardinalityRestriction(owlMinCardinality, "owl:minCardinality");
    }

    public void visitOWLNamedClass(OWLNamedClass owlNamedClass) {
        try {
            this.writer.writeStartElement("owl:Class");
            Util.insertAboutAttribute(owlNamedClass, this.writer);
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void visitOWLSomeValuesFrom(OWLSomeValuesFrom owlSomeValuesFrom) {
        this.renderQuantifierRestriction(owlSomeValuesFrom, "owl:someValuesFrom");
    }

    public void visitOWLUnionClass(OWLUnionClass owlUnionClass) {
        this.renderNAryLogicalClass(owlUnionClass, "owl:unionOf");
    }

    public void visitOWLDataRange(OWLDataRange owlDataRange) {
        try {
            this.writer.writeStartElement("owl:DataRange");
            this.writer.writeStartElement("owl:oneOf");
            this.renderValuesAsRDFList(owlDataRange.getOneOfValueLiterals(), owlDataRange.getOWLModel());
            this.writer.writeEndElement();
            this.insertProperties(owlDataRange);
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void visitRDFExternalResource(RDFExternalResource rdfExternalResource) {
        try {
            this.writer.writeStartElement("rdf:resource");
            this.writer.writeAttribute("rdf:about", rdfExternalResource.getResourceURI());
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void visitRDFDatatype(RDFSDatatype rdfsDatatype) {
        try {
            if (rdfsDatatype.isAnonymous()) {
                this.writer.writeStartElement("rdfs:Datatype");
                Util.insertProperties(rdfsDatatype, this.tripleStore, this.writer);
            } else {
                this.writer.writeAttribute("rdf:resource", rdfsDatatype.getURI());
            }
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void visitRDFIndividual(RDFIndividual rdfIndividual) {
        try {
            Util.insertResourceAsElement(rdfIndividual.getRDFType(), this.writer);
            Util.insertAboutAttribute(rdfIndividual, this.writer);
            this.insertProperties(rdfIndividual);
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void visitRDFList(RDFList rdfList) {
        this.renderValuesAsRDFList(rdfList.getValues(), rdfList.getOWLModel());
    }

    public void visitRDFSNamedClass(RDFSNamedClass rdfsNamedClass) {
        try {
            this.writer.writeStartElement("rdfs:Class");
            Util.insertAboutAttribute(rdfsNamedClass, this.writer);
            this.insertProperties(rdfsNamedClass);
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    private void writeRestrictionStart(OWLRestriction restriction) {
        try {
            this.writer.writeStartElement("owl:Restriction");
            this.writer.writeStartElement("owl:onProperty");
            Util.insertResourceAttribute(restriction.getOnProperty(), this.writer);
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    private void renderCardinalityRestriction(OWLCardinalityBase cardinalityBase, String keyWord) {
        try {
            this.writeRestrictionStart(cardinalityBase);
            this.writer.writeStartElement(keyWord);
            this.writer.writeAttribute("rdf:datatype", "http://www.w3.org/2001/XMLSchema#int");
            this.writer.writeTextContent(Integer.toString(cardinalityBase.getCardinality()));
            this.writer.writeEndElement();
            this.insertProperties(cardinalityBase);
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    private void renderNAryLogicalClass(OWLNAryLogicalClass logicalClass, String keyWord) {
        try {
            this.writer.writeStartElement("owl:Class");
            this.writer.writeStartElement(keyWord);
            this.writer.writeAttribute("rdf:parseType", "Collection");
            TreeSet ops = new TreeSet(new FrameComparator());
            ops.addAll(logicalClass.getOperands());
            for (RDFResource curResource : ops) {
                new RDFResourceRenderer(curResource, this.tripleStore, this.writer).write();
            }
            this.writer.writeEndElement();
            this.insertProperties(logicalClass);
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    private void renderQuantifierRestriction(OWLQuantifierRestriction quantifierRestriction, String keyWord) {
        try {
            this.writeRestrictionStart(quantifierRestriction);
            RDFResource filler = quantifierRestriction.getFiller();
            this.writer.writeStartElement(keyWord);
            Util.inlineObject(filler, this.tripleStore, this.writer);
            this.writer.writeEndElement();
            this.insertProperties(quantifierRestriction);
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    private void renderValuesAsRDFList(Collection values, OWLModel model) {
        try {
            int counter = 0;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                this.writer.writeStartElement("rdf:List");
                this.writer.writeStartElement("rdf:first");
                Object curVal = it.next();
                if (curVal instanceof RDFResource) {
                    Util.inlineObject((RDFResource)curVal, this.tripleStore, this.writer);
                } else {
                    RDFSLiteral curLiteral = model.asRDFSLiteral(curVal);
                    this.writer.writeAttribute("rdf:datatype", curLiteral.getDatatype().getURI());
                    this.writer.writeTextContent(curLiteral.getPlainValue().toString());
                }
                this.writer.writeEndElement();
                this.writer.writeStartElement("rdf:rest");
                if (!it.hasNext()) {
                    this.writer.writeAttribute("rdf:resource", model.getRDFNil().getURI());
                }
                ++counter;
            }
            int i = 0;
            while (i < counter) {
                this.writer.writeEndElement();
                this.writer.writeEndElement();
                ++i;
            }
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    private void insertProperties(RDFResource resource) throws IOException {
        Util.insertProperties(resource, this.tripleStore, this.writer);
    }
}

