/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owlx.examples;

import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.io.File;
import java.util.ArrayList;

public class LoadTravelOntology {
    public static void main(String[] args) throws Exception {
        String uri = "http://www.owl-ontologies.com/travel.owl";
        JenaOWLModel owlModel = ProtegeOWL.createJenaOWLModelFromURI(uri);
        OWLNamedClass destinationClass = owlModel.getOWLNamedClass("Destination");
        System.out.println("Destination has " + destinationClass.getInstanceCount(true) + " instances:");
        for (OWLIndividual individual : destinationClass.getInstances(true)) {
            RDFSClass type = individual.getProtegeType();
            System.out.println("- " + individual.getBrowserText() + " (" + type.getBrowserText() + ")");
        }
        OWLObjectProperty hasContactProperty = owlModel.getOWLObjectProperty("hasContact");
        OWLDatatypeProperty hasZipCodeProperty = owlModel.getOWLDatatypeProperty("hasZipCode");
        OWLIndividual sydney = owlModel.getOWLIndividual("Sydney");
        String fileName = "travel-saved.owl";
        ArrayList errors = new ArrayList();
        owlModel.save(new File(fileName).toURI(), "RDF/XML-ABBREV", errors);
        System.out.println("File saved with " + errors.size() + " errors.");
    }
}

