/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owlx.examples;

import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import java.util.Collection;

public class QueryClassesExample {
    public static void main(String[] args) throws Exception {
        String uri = "http://www.owl-ontologies.com/travel.owl";
        JenaOWLModel owlModel = ProtegeOWL.createJenaOWLModelFromURI(uri);
        Collection classes = owlModel.getUserDefinedOWLNamedClasses();
        for (OWLNamedClass cls : classes) {
            Collection instances = cls.getInstances(false);
            System.out.println("Class " + cls.getBrowserText() + " (" + instances.size() + ")");
            for (OWLIndividual individual : instances) {
                System.out.println(" - " + individual.getBrowserText());
            }
        }
        RDFProperty subClassOfProperty = owlModel.getRDFProperty("rdfs:subClassOf");
        OWLNamedClass owlThingClass = owlModel.getOWLThingClass();
        Collection results = owlModel.getRDFResourcesWithPropertyValue(subClassOfProperty, owlThingClass);
        System.out.println("Subclasses of owl:Thing:");
        for (RDFResource resource : results) {
            System.out.println(" - " + resource.getBrowserText());
        }
    }
}

