/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.tests;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ReasonerManager;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collection;
import java.util.logging.Level;

public class SubsumptionTests
extends AbstractJenaTestCase {
    public void testSubsumptionQuery() {
        try {
            OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
            OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
            clsB.addEquivalentClass(clsA);
            ProtegeOWLReasoner reasoner = ReasonerManager.getInstance().createReasoner(this.owlModel);
            SubsumptionTests.assertTrue((boolean)reasoner.isSubsumedBy(clsA, clsB, null));
        }
        catch (Exception e) {
            SubsumptionTests.fail((String)e.getMessage());
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void testSuperclassesQuery() {
        try {
            OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
            OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
            clsB.addSuperclass(clsA);
            ProtegeOWLReasoner reasoner = ReasonerManager.getInstance().createReasoner(this.owlModel);
            SubsumptionTests.assertTrue((boolean)reasoner.getSuperclasses(clsB, null).contains(clsA));
        }
        catch (DIGReasonerException e) {
            SubsumptionTests.fail((String)e.getMessage());
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void testAncestorClassesQuery() {
        try {
            OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
            OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
            OWLNamedClass clsC = this.owlModel.createOWLNamedClass("C");
            clsB.addSuperclass(clsA);
            clsC.addSuperclass(clsB);
            ProtegeOWLReasoner reasoner = ReasonerManager.getInstance().createReasoner(this.owlModel);
            Collection ancestorClasses = reasoner.getAncestorClasses(clsC, null);
            SubsumptionTests.assertTrue((boolean)ancestorClasses.contains(clsA));
            SubsumptionTests.assertTrue((boolean)ancestorClasses.contains(clsB));
            SubsumptionTests.assertTrue((boolean)ancestorClasses.contains(this.owlModel.getOWLThingClass()));
        }
        catch (DIGReasonerException e) {
            SubsumptionTests.fail((String)e.getMessage());
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void testSubclassesQuery() {
        try {
            OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
            OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
            clsB.addSuperclass(clsA);
            ProtegeOWLReasoner reasoner = ReasonerManager.getInstance().createReasoner(this.owlModel);
            SubsumptionTests.assertTrue((boolean)reasoner.getSubclasses(clsA, null).contains(clsB));
        }
        catch (DIGReasonerException e) {
            SubsumptionTests.fail((String)e.getMessage());
            e.printStackTrace();
        }
    }

    public void testDescendantClassesQuery() {
        try {
            OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
            OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
            OWLNamedClass clsC = this.owlModel.createOWLNamedClass("C");
            clsB.addSuperclass(clsA);
            clsC.addSuperclass(clsB);
            ProtegeOWLReasoner reasoner = ReasonerManager.getInstance().createReasoner(this.owlModel);
            Collection descendantClasses = reasoner.getDescendantClasses(this.owlModel.getOWLThingClass(), null);
            SubsumptionTests.assertTrue((boolean)descendantClasses.contains(clsA));
            SubsumptionTests.assertTrue((boolean)descendantClasses.contains(clsB));
            SubsumptionTests.assertTrue((boolean)descendantClasses.contains(clsC));
        }
        catch (DIGReasonerException e) {
            SubsumptionTests.fail((String)e.getMessage());
            e.printStackTrace();
        }
    }

    public void testSumbsumptionRelationshipQuery() {
        try {
            OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
            OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
            OWLNamedClass clsC = this.owlModel.createOWLNamedClass("C");
            clsB.addSuperclass(clsA);
            ProtegeOWLReasoner reasoner = ReasonerManager.getInstance().createReasoner(this.owlModel);
            int relationship = reasoner.getSubsumptionRelationship(clsA, clsB, null);
            SubsumptionTests.assertEquals((int)relationship, (int)1);
            relationship = reasoner.getSubsumptionRelationship(clsB, clsA, null);
            SubsumptionTests.assertEquals((int)relationship, (int)2);
            clsA.addSuperclass(clsB);
            relationship = reasoner.getSubsumptionRelationship(clsA, clsB, null);
            SubsumptionTests.assertEquals((int)relationship, (int)3);
            relationship = reasoner.getSubsumptionRelationship(clsC, clsA, null);
            SubsumptionTests.assertEquals((int)relationship, (int)0);
        }
        catch (DIGReasonerException e) {
            SubsumptionTests.fail((String)e.getMessage());
            e.printStackTrace();
        }
    }

    public void testGetSuperclassesOfIntersection() {
        try {
            OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
            OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
            ProtegeOWLReasoner reasoner = ReasonerManager.getInstance().createReasoner(this.owlModel);
            Collection superClses = reasoner.getSuperclassesOfIntersection(new OWLClass[]{clsA, clsB}, null);
            SubsumptionTests.assertTrue((boolean)superClses.contains(clsA));
            SubsumptionTests.assertTrue((boolean)superClses.contains(clsB));
        }
        catch (DIGReasonerException e) {
            SubsumptionTests.fail((String)e.getMessage());
            e.printStackTrace();
        }
    }
}

