/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerIdentity;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ReasonerManager;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogger;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLoggerListener;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLoggerUtil;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.WarningMessageLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskEvent;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskListener;
import edu.stanford.smi.protegex.owl.inference.ui.ReasonerProgressModalDialog;
import edu.stanford.smi.protegex.owl.inference.ui.ReasonerWarningPanel;
import edu.stanford.smi.protegex.owl.inference.ui.RunnableReasonerAction;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerPreferences;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class ReasonerActionRunner {
    private static transient Logger log = Log.getLogger(ReasonerActionRunner.class);
    private boolean showClassifierResults;
    private RunnableReasonerAction runner;
    private boolean journalingEnabled;

    public ReasonerActionRunner(RunnableReasonerAction runner, boolean showClassifierResults) {
        this.showClassifierResults = showClassifierResults;
        this.runner = runner;
    }

    public void execute() {
        final Project project = this.runner.getOWLModel().getProject();
        if (project != null) {
            this.journalingEnabled = project.isJournalingEnabled();
        }
        ProtegeOWLReasoner reasoner = ReasonerManager.getInstance().getReasoner(this.runner.getOWLModel());
        String prefURL = ReasonerPreferences.getInstance().getReasonerURL();
        String actualURL = reasoner.getDIGReasoner().getReasonerURL();
        if (!actualURL.equals(prefURL)) {
            reasoner.setURL(prefURL);
        }
        DIGReasonerIdentity id = reasoner.getIdentity();
        Component appWindow = ProtegeUI.getTopLevelContainer(project);
        Frame appFrame = null;
        if (appWindow instanceof Frame) {
            appFrame = (Frame)appWindow;
        }
        String dlgTitle = id != null ? "Connected to " + id.getName() + " " + id.getVersion() : "Could not obtain reasoner identity";
        final ReasonerProgressModalDialog dlg = new ReasonerProgressModalDialog(appFrame, dlgTitle);
        ReasonerLoggerListenerBridge logLoggerListenerBridge = new ReasonerLoggerListenerBridge(dlg);
        ReasonerLogger.getInstance().addListener(logLoggerListenerBridge);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ReasonerActionRunner.this.showClassifierResults) {
                    ReasonerActionRunner.this.showInferredHierarchy(false);
                }
            }
        });
        Runnable r = new Runnable(){

            public void run() {
                block7: {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            dlg.show();
                        }
                    });
                    try {
                        final ArrayList warnings = new ArrayList();
                        boolean showWarningResultsPanel = ReasonerPreferences.getInstance().isShowWarningResultsPanel();
                        ReasonerLoggerListener loggerListener = null;
                        ReasonerLogger logger = ReasonerLogger.getInstance();
                        if (showWarningResultsPanel) {
                            loggerListener = new ReasonerLoggerListener(){

                                public void logRecordPosted(ReasonerLogRecord logRecord) {
                                    if (logRecord instanceof WarningMessageLogRecord) {
                                        warnings.add(ReasonerLoggerUtil.convertToOWLTestResult((WarningMessageLogRecord)logRecord));
                                    }
                                }
                            };
                            logger.addListener(loggerListener);
                        }
                        ReasonerActionRunner.this.runner.executeReasonerActions(new ReasonerTaskListenerBridge(dlg));
                        if (project != null) {
                            project.setJournalingEnabled(ReasonerActionRunner.this.journalingEnabled);
                        }
                        if (showWarningResultsPanel && warnings.size() > 0) {
                            logger.removeListener(loggerListener);
                            loggerListener = null;
                            ReasonerWarningPanel testResultsPanel = new ReasonerWarningPanel(ReasonerActionRunner.this.runner.getOWLModel(), warnings);
                            ResultsPanelManager.addResultsPanel(ReasonerActionRunner.this.runner.getOWLModel(), testResultsPanel, true);
                        }
                        if (ReasonerActionRunner.this.showClassifierResults) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    ReasonerActionRunner.this.showInferredHierarchy(true);
                                }
                            });
                        }
                    }
                    catch (DIGReasonerException e1) {
                        final DIGReasonerException ex = e1;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                dlg.setOKButtonEnabled(true);
                                dlg.setProgressIndeterminate(false);
                                ReasonerLogger logger = ReasonerLogger.getInstance();
                                ReasonerLogRecordFactory factory = ReasonerLogRecordFactory.getInstance();
                                ReasonerLogRecord log = factory.createDIGReasonerExceptionLogRecord(ex, null);
                                logger.postLogRecord(log);
                            }
                        });
                        if (!ReasonerActionRunner.this.runner.getOWLModel().getGenerateEventsEnabled()) {
                            ReasonerActionRunner.this.runner.getOWLModel().setGenerateEventsEnabled(true);
                        }
                        if (project == null) break block7;
                        project.setJournalingEnabled(ReasonerActionRunner.this.journalingEnabled);
                    }
                }
            }
        };
        try {
            Thread t = new Thread(r);
            t.start();
        }
        catch (Exception e) {
            dlg.setOKButtonEnabled(true);
            dlg.setProgressIndeterminate(false);
            Log.emptyCatchBlock((Throwable)e);
        }
    }

    protected void showInferredHierarchy(boolean visible) {
        ProjectView projectView = ProtegeUI.getProjectView(this.runner.getOWLModel().getProject());
        OWLClassesTab classesTab = (OWLClassesTab)projectView.getTabByClassName(OWLClassesTab.class.getName());
        if (classesTab != null) {
            if (visible) {
                ReasonerPreferences reasonerPreferences = ReasonerPreferences.getInstance();
                if (reasonerPreferences.isAutomaticallyShowInferredHierarchy()) {
                    classesTab.setInferredClsesVisible(true);
                }
                if (reasonerPreferences.isShowReasonerResultsPanel()) {
                    classesTab.refreshChangedClses();
                    classesTab.requestFocusInWindow();
                }
            } else {
                classesTab.setInferredClsesVisible(false);
            }
        }
    }

    private class ReasonerLoggerListenerBridge
    implements ReasonerLoggerListener {
        private ReasonerProgressModalDialog dlg;

        public ReasonerLoggerListenerBridge(ReasonerProgressModalDialog dlg) {
            this.dlg = dlg;
        }

        public void logRecordPosted(final ReasonerLogRecord logRecord) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ReasonerLoggerListenerBridge.this.dlg.postLogRecord(logRecord);
                }
            });
        }
    }

    private class ReasonerTaskListenerBridge
    implements ReasonerTaskListener {
        private ReasonerProgressModalDialog dlg;

        public ReasonerTaskListenerBridge(ReasonerProgressModalDialog dlg) {
            this.dlg = dlg;
        }

        public void addedToTask(final ReasonerTaskEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int taskSize = event.getSource().getTaskSize();
                    ReasonerTaskListenerBridge.this.dlg.setTask(event.getSource());
                    ReasonerTaskListenerBridge.this.dlg.setProgressIndeterminate(false);
                    ReasonerTaskListenerBridge.this.dlg.setProgressBarMaxValue(taskSize);
                    ReasonerTaskListenerBridge.this.dlg.setCancelButtonEnabled(true);
                    ReasonerTaskListenerBridge.this.dlg.setOKButtonEnabled(false);
                }
            });
        }

        public void progressChanged(final ReasonerTaskEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int progress = event.getSource().getProgress();
                    ReasonerTaskListenerBridge.this.dlg.setProgress(progress);
                }
            });
        }

        public void progressIndeterminateChanged(final ReasonerTaskEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    boolean b = event.getSource().isProgressIndeterminate();
                    ReasonerTaskListenerBridge.this.dlg.setProgressIndeterminate(b);
                }
            });
        }

        public void descriptionChanged(final ReasonerTaskEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String description = event.getSource().getDescription();
                    ReasonerTaskListenerBridge.this.dlg.setDescription(description);
                }
            });
        }

        public void messageChanged(final ReasonerTaskEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String message = event.getSource().getMessage();
                    ReasonerTaskListenerBridge.this.dlg.setMessage(message);
                }
            });
        }

        public void taskFailed(ReasonerTaskEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ReasonerTaskListenerBridge.this.dlg.setOKButtonEnabled(true);
                    ReasonerTaskListenerBridge.this.dlg.setCancelButtonEnabled(false);
                    ReasonerTaskListenerBridge.this.dlg.setProgressIndeterminate(false);
                }
            });
        }

        public void taskCompleted(ReasonerTaskEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ReasonerTaskListenerBridge.this.dlg.setOKButtonEnabled(true);
                    ReasonerTaskListenerBridge.this.dlg.setCancelButtonEnabled(false);
                }
            });
        }
    }
}

