/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.triplestore;

import edu.stanford.smi.protege.model.framestore.InMemoryFrameDb;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.triplestore.JenaTripleStore;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AbstractTripleStoreModel;
import java.util.ArrayList;
import java.util.Collection;

public class JenaTripleStoreModel
extends AbstractTripleStoreModel {
    private JenaOWLModel owlModel;

    public JenaTripleStoreModel(JenaOWLModel owlModel) {
        super(owlModel);
        this.owlModel = owlModel;
        this.initTripleStores();
    }

    public TripleStore createTripleStore(String name) {
        InMemoryFrameDb frameStore = new InMemoryFrameDb(name);
        String parentName = this.getActiveTripleStore().getName();
        this.mnfs.addActiveChildFrameStore((NarrowFrameStore)frameStore, parentName);
        JenaTripleStore tripleStore = new JenaTripleStore((OWLModel)this.owlModel, (NarrowFrameStore)frameStore, this);
        this.ts.add(tripleStore);
        this.updateRemoveFrameStores();
        return tripleStore;
    }

    public void deleteTripleStore(TripleStore tripleStore) {
        this.ts.remove(tripleStore);
    }

    public static void ensureActiveTripleStore(RDFResource resource) {
        TripleStoreUtil.ensureActiveTripleStore(resource);
    }

    public TripleStore getTripleStoreByDefaultNamespace(String namespace) {
        for (TripleStore tripleStore : this.ts) {
            if (!namespace.equals(tripleStore.getDefaultNamespace())) continue;
            return tripleStore;
        }
        return null;
    }

    private void initTripleStores() {
        this.ts = new ArrayList();
        NarrowFrameStore[] ss = this.mnfs.getAvailableFrameStores().toArray(new NarrowFrameStore[0]);
        int i = 0;
        while (i < ss.length) {
            NarrowFrameStore s = ss[i];
            this.ts.add(new JenaTripleStore((OWLModel)this.owlModel, s, this));
            ++i;
        }
        this.updateRemoveFrameStores();
    }

    private void updateRemoveFrameStores() {
        Collection allFrameStores = this.mnfs.getAvailableFrameStores();
        this.mnfs.setRemoveFrameStores(allFrameStores);
        this.owlModel.resetJenaModel();
    }
}

