/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.FacetEvent;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.InstanceEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.SlotEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.framestore.ReferenceImpl;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNames;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class OWLFrameFactoryInvocationHandler
extends AbstractFrameStoreInvocationHandler {
    private OWLJavaFactory ff;
    private OWLNamedClass owlNamedClassClass;
    private static OWLFrameFactoryInvocationHandler recentInstance;
    private static Set systemClses;
    private Cls thingCls;
    private OWLJavaFactoryUpdater updater;

    static {
        systemClses = new HashSet();
        systemClses.add(":THING");
        systemClses.add(":CLASS");
        systemClses.add(":META-CLASS");
        systemClses.add(":STANDARD-CLASS");
        systemClses.add(":SYSTEM-CLASS");
    }

    public OWLFrameFactoryInvocationHandler() {
        recentInstance = this;
    }

    private Object convert(Object o) {
        if (o instanceof Collection) {
            return this.convertCollection((Collection)o);
        }
        if (o instanceof Instance) {
            return this.convertInstance((Instance)o);
        }
        if (o instanceof Reference) {
            return this.convertReference((Reference)o);
        }
        if (o instanceof AbstractEvent) {
            return this.convertEvent((AbstractEvent)o);
        }
        return o;
    }

    public Collection convertCollection(Collection values) {
        if (values.size() == 0) {
            return values;
        }
        AbstractCollection result = null;
        result = values instanceof Set ? new HashSet(values.size()) : new ArrayList(values.size());
        Iterator it = values.iterator();
        while (it.hasNext()) {
            result.add(this.convert(it.next()));
        }
        return result;
    }

    private AbstractEvent convertEvent(AbstractEvent event) {
        if (event instanceof ClsEvent) {
            return new ClsEvent((Cls)this.convert(event.getSource()), event.getEventType(), this.convert(event.getArgument1()), this.convert(event.getArgument2()));
        }
        if (event instanceof FacetEvent) {
            return new FacetEvent((Facet)this.convert(event.getSource()), event.getEventType(), (Frame)this.convert(((FacetEvent)event).getFrame()), (Slot)this.convert(((FacetEvent)event).getSlot()));
        }
        if (event instanceof FrameEvent) {
            return new FrameEvent((Frame)this.convert(event.getSource()), event.getEventType(), this.convert(event.getArgument1()), this.convert(event.getArgument2()));
        }
        if (event instanceof InstanceEvent) {
            return new InstanceEvent((Instance)this.convert(event.getSource()), event.getEventType(), this.convert(event.getArgument()));
        }
        if (event instanceof KnowledgeBaseEvent) {
            KnowledgeBaseEvent old = (KnowledgeBaseEvent)event;
            Frame frame = (Frame)this.convert(old.getFrame());
            KnowledgeBase source = (KnowledgeBase)old.getSource();
            if (source == null) {
                source = frame.getKnowledgeBase();
            }
            return new KnowledgeBaseEvent(source, old.getEventType(), frame, this.convert(old.getArgument2()), this.convert(old.getArgument3()));
        }
        if (event instanceof SlotEvent) {
            SlotEvent old = (SlotEvent)event;
            return new SlotEvent((Slot)this.convert(old.getSlot()), old.getEventType(), (Frame)this.convert(old.getFrame()));
        }
        return event;
    }

    public Instance convertInstance(Instance instance) {
        Collection directTypes;
        if (this.ff == null) {
            AbstractOWLModel owlModel = (AbstractOWLModel)instance.getKnowledgeBase();
            this.ff = new OWLJavaFactory(owlModel);
            this.owlNamedClassClass = new DefaultOWLNamedClass(owlModel, OWLNames.ClsID.NAMED_CLASS);
            this.thingCls = new DefaultOWLNamedClass(owlModel, Model.ClsID.THING);
        }
        if (instance instanceof Cls) {
            if (Model.ClsID.THING.equals((Object)instance.getFrameID())) {
                return this.thingCls;
            }
            if (instance.isSystem() && instance.getFrameID().getLocalPart() < 9000 && !Model.ClsID.DIRECTED_BINARY_RELATION.equals((Object)instance.getFrameID()) || instance instanceof RDFSClass) {
                if (this.owlNamedClassClass.equals(instance)) {
                    return this.owlNamedClassClass;
                }
                return instance;
            }
            if (this.isDefaultNamedCls(instance)) {
                return new DefaultOWLNamedClass(instance.getKnowledgeBase(), instance.getFrameID());
            }
            return this.ff.createCls(instance.getFrameID(), instance.getDirectTypes());
        }
        if (instance instanceof Slot) {
            directTypes = instance.getDirectTypes();
            Slot slot = this.ff.createSlot(instance.getFrameID(), directTypes);
            if (!(slot instanceof RDFProperty || slot.isSystem() || directTypes.isEmpty())) {
                if (this.updater == null) {
                    this.updater = new OWLJavaFactoryUpdater(slot.getKnowledgeBase(), Collections.singleton(slot));
                }
                return this.updater.createNewFrame((Instance)slot);
            }
            return slot;
        }
        if (instance instanceof Facet) {
            return this.ff.createFacet(instance.getFrameID(), instance.getDirectTypes());
        }
        if (instance == null) {
            return null;
        }
        directTypes = instance.getDirectTypes();
        if (directTypes.isEmpty() && instance instanceof RDFList) {
            return instance;
        }
        return this.ff.createSimpleInstance(instance.getFrameID(), directTypes);
    }

    private Reference convertReference(Reference reference) {
        Instance frame = this.convertInstance((Instance)reference.getFrame());
        Slot slot = (Slot)this.convertInstance((Instance)reference.getSlot());
        Facet facet = (Facet)this.convertInstance((Instance)reference.getFacet());
        return new ReferenceImpl((Frame)frame, slot, facet, reference.isTemplate());
    }

    protected Object handleInvoke(Method method, Object[] args) {
        Object result = this.invoke(method, args);
        return this.convert(result);
    }

    private boolean isDefaultNamedCls(Instance instance) {
        FrameID id = instance.getFrameID();
        return OWLNames.ClsID.NAMED_CLASS.equals((Object)id) || RDFNames.ClsID.PROPERTY.equals((Object)id) || RDFSNames.ClsID.NAMED_CLASS.equals((Object)id);
    }

    public static final void setFrameFactory(OWLJavaFactory ff) {
        OWLFrameFactoryInvocationHandler.recentInstance.ff = ff;
    }
}

