/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class RDFSDomainTestCase
extends AbstractJenaTestCase {
    public void testSimpleDomain() {
        RDFProperty property = this.owlModel.createRDFProperty("property");
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        property.setDomain(cls);
        RDFSDomainTestCase.assertSize(1, property.getDomains(false));
        RDFSDomainTestCase.assertContains((Object)cls, property.getDomains(false));
        RDFSDomainTestCase.assertSize(1, property.getDirectDomain());
        RDFSDomainTestCase.assertContains((Object)cls, property.getDirectDomain());
    }

    public void testChangeTemplateSlots() {
        RDFProperty property = this.owlModel.createRDFProperty("property");
        RDFSNamedClass clsA = this.owlModel.createRDFSNamedClass("ClassA");
        RDFSNamedClass clsB = this.owlModel.createRDFSNamedClass("ClassB");
        this.owlThing.removeDirectTemplateSlot(property);
        clsA.addDirectTemplateSlot(property);
        RDFSDomainTestCase.assertEquals((Object)clsA, (Object)property.getDomain(false));
        clsB.addDirectTemplateSlot(property);
        RDFSDomainTestCase.assertTrue((boolean)(property.getDomain(false) instanceof OWLUnionClass));
    }

    public void testDomainCorrectOnDeletingClass() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass owlThing = this.owlModel.getOWLThingClass();
        OWLObjectProperty p = this.owlModel.createOWLObjectProperty("p");
        RDFSDomainTestCase.assertSame((Object)p.getDomain(false), (Object)owlThing);
        p.setDomain(a);
        RDFSDomainTestCase.assertSame((Object)p.getDomain(false), (Object)a);
        a.delete();
        RDFSDomainTestCase.assertSame((Object)p.getDomain(false), (Object)owlThing);
    }
}

