/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.datatypes.xsd.impl.XSDDateTimeType;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import junit.framework.Assert;

public class XMLSchemaDatatypes {
    public static final String XML_LITERAL = "XMLLiteral";
    public static final XSDDatatype[] floatTypes = new XSDDatatype[]{XSDDatatype.XSDfloat, XSDDatatype.XSDdecimal, XSDDatatype.XSDdouble};
    public static final XSDDatatype[] integerTypes = new XSDDatatype[]{XSDDatatype.XSDint, XSDDatatype.XSDpositiveInteger, XSDDatatype.XSDnegativeInteger, XSDDatatype.XSDnonPositiveInteger, XSDDatatype.XSDnonNegativeInteger, XSDDatatype.XSDlong, XSDDatatype.XSDinteger, XSDDatatype.XSDshort, XSDDatatype.XSDbyte, XSDDatatype.XSDunsignedLong, XSDDatatype.XSDunsignedInt, XSDDatatype.XSDunsignedShort, XSDDatatype.XSDunsignedByte};
    public static final XSDDatatype[] stringTypes = new XSDDatatype[]{XSDDatatype.XSDstring, XSDDatatype.XSDanyURI, XSDDatatype.XSDdate, XSDDatatype.XSDdateTime, XSDDatatype.XSDduration, XSDDatatype.XSDgDay, XSDDatatype.XSDgMonth, XSDDatatype.XSDgMonthDay, XSDDatatype.XSDgYear, XSDDatatype.XSDgYearMonth, XSDDatatype.XSDtime, XSDDatatype.XSDnormalizedString, XSDDatatype.XSDtoken, XSDDatatype.XSDlanguage, XSDDatatype.XSDName, XSDDatatype.XSDNCName, XSDDatatype.XSDNMTOKEN, XSDDatatype.XSDID, XSDDatatype.XSDIDREF, XSDDatatype.XSDENTITY};
    private static final Hashtable alias2XSDDatatype = new Hashtable();
    private static final Hashtable uri2ValueTypeHashtable = new Hashtable();
    private static final Hashtable valueType2URIHashtable = new Hashtable();

    static {
        XMLSchemaDatatypes.initHashtables(ValueType.BOOLEAN, XSDDatatype.XSDboolean);
        XMLSchemaDatatypes.initHashtables(ValueType.FLOAT, floatTypes);
        XMLSchemaDatatypes.initHashtables(ValueType.INTEGER, integerTypes);
        XMLSchemaDatatypes.initHashtables(ValueType.STRING, stringTypes);
        XMLSchemaDatatypes.initHashtables(ValueType.SYMBOL, XSDDatatype.XSDstring);
        XMLSchemaDatatypes.initHashtables(null, XSDDatatype.XSDbase64Binary);
    }

    public static XSDDatatype[] getAllTypes() {
        ArrayList<XSDDatatype> list = new ArrayList<XSDDatatype>();
        list.addAll((Collection)Arrays.asList(stringTypes));
        list.add(XSDDatatype.XSDboolean);
        list.addAll((Collection)Arrays.asList(floatTypes));
        list.addAll((Collection)Arrays.asList(integerTypes));
        return list.toArray(new XSDDatatype[0]);
    }

    public static Date getDate(String value) {
        XSDDateTime dt = (XSDDateTime)new XSDDateTimeType("dateTime").parse(value);
        Calendar dateCal = dt.asCalendar();
        dateCal.setTimeZone(new GregorianCalendar().getTimeZone());
        return dateCal.getTime();
    }

    public static String getDateString(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int offset = cal.get(15) + cal.get(16);
        cal.add(14, offset);
        DateXSDDateTime dt = new DateXSDDateTime(cal);
        return dt.toString();
    }

    public static String getDateTimeString(Date date) {
        return String.valueOf(XMLSchemaDatatypes.getDateString(date)) + "T" + XMLSchemaDatatypes.getTimeString(date);
    }

    public static String getDefaultAlias(ValueType valueType) {
        return XMLSchemaDatatypes.getXSDDatatypeAlias(XMLSchemaDatatypes.getValueTypeURI(valueType));
    }

    public static String getDefaultDateValue() {
        return XMLSchemaDatatypes.getDateString(new Date());
    }

    public static String getDefaultDateTimeValue() {
        return XMLSchemaDatatypes.getDateTimeString(new Date());
    }

    public static String getDefaultTimeValue() {
        return XMLSchemaDatatypes.getTimeString(new Date());
    }

    public static XSDDatatype getDefaultXSDDatatype(ValueType valueType) {
        String alias = XMLSchemaDatatypes.getDefaultAlias(valueType);
        return XMLSchemaDatatypes.getXSDDatatype(alias);
    }

    public static List getSlotSymbols() {
        ArrayList<String> values = new ArrayList<String>();
        Enumeration enu = uri2ValueTypeHashtable.keys();
        while (enu.hasMoreElements()) {
            String str = (String)enu.nextElement();
            values.add(str);
        }
        return values;
    }

    public static String getTimeString(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        return format.format(date);
    }

    public static String getTimeString(int hours, int minutes, int seconds) {
        String str = "";
        str = String.valueOf(str) + (hours < 10 ? "0" + hours : "" + hours);
        str = String.valueOf(str) + ":";
        str = String.valueOf(str) + (minutes < 10 ? "0" + minutes : "" + minutes);
        str = String.valueOf(str) + ":";
        str = String.valueOf(str) + (seconds < 10 ? "0" + seconds : "" + seconds);
        return str;
    }

    public static ValueType getValueType(String uri) {
        ValueType result;
        if (uri.equals(OWL.Class.getURI())) {
            return ValueType.CLS;
        }
        if (uri.equals(RDFS.Literal.getURI())) {
            return ValueType.ANY;
        }
        if (uri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral")) {
            return ValueType.STRING;
        }
        int index = uri.lastIndexOf(35);
        if (index >= 0) {
            uri = uri.substring(index + 1);
        }
        if ((result = (ValueType)uri2ValueTypeHashtable.get(uri)) == null) {
            return ValueType.ANY;
        }
        return result;
    }

    public static String getValueTypeURI(ValueType valueType) {
        Assert.assertTrue((valueType != null && valueType != ValueType.INSTANCE && valueType != ValueType.CLS ? 1 : 0) != 0);
        if (valueType == ValueType.ANY) {
            System.err.println("Warning: Replaced illegal value type \"Any\" with \"String\"");
            valueType = ValueType.STRING;
        }
        return "http://www.w3.org/2001/XMLSchema#" + valueType2URIHashtable.get(valueType);
    }

    public static XSDDatatype getXSDDatatype(String alias) {
        return (XSDDatatype)alias2XSDDatatype.get(alias);
    }

    public static RDFDatatype getRDFDatatype(RDFSDatatype datatype) {
        if (datatype.equals(datatype.getOWLModel().getRDFXMLLiteralType())) {
            return XMLLiteralType.theXMLLiteralType;
        }
        return XMLSchemaDatatypes.getXSDDatatype(datatype);
    }

    public static XSDDatatype getXSDDatatype(RDFSDatatype datatype) {
        if (datatype.isSystem()) {
            return (XSDDatatype)alias2XSDDatatype.get(datatype.getLocalName());
        }
        return XMLSchemaDatatypes.getXSDDatatype(datatype.getBaseDatatype());
    }

    public static String getXSDDatatypeAlias(XSDDatatype datatype) {
        String uri = datatype.getURI();
        return XMLSchemaDatatypes.getXSDDatatypeAlias(uri);
    }

    public static String getXSDDatatypeAlias(String uri) {
        int index = uri.lastIndexOf(35);
        return uri.substring(index + 1);
    }

    private static void initHashtables(ValueType valueType, String uri) {
        if (valueType2URIHashtable.get(valueType) == null) {
            valueType2URIHashtable.put(valueType, uri);
        }
        if (uri2ValueTypeHashtable.get(uri) == null) {
            uri2ValueTypeHashtable.put(uri, valueType);
        }
    }

    private static void initHashtables(ValueType valueType, XSDDatatype xsd) {
        String fullURI = xsd.getURI();
        int index = fullURI.lastIndexOf(35);
        String uri = fullURI.substring(index + 1);
        if (valueType != null) {
            XMLSchemaDatatypes.initHashtables(valueType, uri);
        }
        alias2XSDDatatype.put(uri, xsd);
    }

    private static void initHashtables(ValueType valueType, XSDDatatype[] xsds) {
        int i = 0;
        while (i < xsds.length) {
            XSDDatatype xsd = xsds[i];
            XMLSchemaDatatypes.initHashtables(valueType, xsd);
            ++i;
        }
    }

    public static boolean isDateSlot(RDFProperty property) {
        return XMLSchemaDatatypes.isXMLSchemaSlot(property, XSDDatatype.XSDdate);
    }

    public static boolean isDateTimeSlot(RDFProperty property) {
        return XMLSchemaDatatypes.isXMLSchemaSlot(property, XSDDatatype.XSDdateTime);
    }

    public static boolean isTimeSlot(RDFProperty property) {
        return XMLSchemaDatatypes.isXMLSchemaSlot(property, XSDDatatype.XSDtime);
    }

    public static boolean isXMLLiteralSlot(Slot slot) {
        if (slot instanceof RDFProperty) {
            RDFProperty rdfProperty = (RDFProperty)slot;
            RDFResource range = rdfProperty.getRange();
            return rdfProperty.getOWLModel().getRDFXMLLiteralType().equals(range);
        }
        return false;
    }

    public static boolean isValidAlias(String alias, ValueType valueType) {
        XSDDatatype xsd = XMLSchemaDatatypes.getXSDDatatype(alias);
        if (xsd != null) {
            if (valueType == ValueType.INTEGER) {
                return Arrays.asList(integerTypes).contains(xsd);
            }
            if (valueType == ValueType.STRING) {
                return Arrays.asList(stringTypes).contains(xsd);
            }
            if (valueType == ValueType.FLOAT) {
                return Arrays.asList(floatTypes).contains(xsd);
            }
            if (valueType == ValueType.BOOLEAN) {
                return xsd.equals(XSDDatatype.XSDboolean);
            }
        }
        return false;
    }

    public static boolean isStringAlias(String alias) {
        return Arrays.asList(stringTypes).contains(XMLSchemaDatatypes.getXSDDatatype(alias));
    }

    public static boolean isXMLSchemaSlot(RDFProperty property, XSDDatatype datatype) {
        RDFResource range = property.getRange(true);
        return property.getOWLModel().getRDFSDatatypeByURI(datatype.getURI()).equals(range);
    }

    public static boolean isNumericDatatype(String uri) {
        XSDDatatype datatype;
        int i = 0;
        while (i < floatTypes.length) {
            datatype = floatTypes[i];
            if (datatype.getURI().equals(uri)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < integerTypes.length) {
            datatype = integerTypes[i];
            if (datatype.getURI().equals(uri)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static class DateXSDDateTime
    extends XSDDateTime {
        DateXSDDateTime(Calendar cal) {
            super(cal);
            this.mask = (short)7;
        }
    }
}

