/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model;

import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDataRangeAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDifferentIndividualsAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLSameIndividualAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.swrl.model.factory.SWRLJavaFactory;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class SWRLFactory {
    private OWLNamedClass atomListCls;
    private OWLNamedClass builtinAtomCls;
    private OWLNamedClass classAtomCls;
    private OWLNamedClass dataRangeAtomCls;
    private OWLNamedClass dataValuedPropertyAtomCls;
    private OWLNamedClass differentIndividualsAtomCls;
    private OWLNamedClass impCls;
    private OWLNamedClass individualPropertyAtom;
    private OWLModel owlModel;
    private OWLNamedClass sameIndividualAtomCls;

    public SWRLFactory(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.atomListCls = owlModel.getOWLNamedClass("swrl:AtomList");
        this.builtinAtomCls = owlModel.getOWLNamedClass("swrl:BuiltinAtom");
        this.classAtomCls = owlModel.getOWLNamedClass("swrl:ClassAtom");
        this.dataRangeAtomCls = owlModel.getOWLNamedClass("swrl:DataRangeAtom");
        this.dataValuedPropertyAtomCls = owlModel.getOWLNamedClass("swrl:DatavaluedPropertyAtom");
        this.differentIndividualsAtomCls = owlModel.getOWLNamedClass("swrl:DifferentIndividualsAtom");
        this.impCls = owlModel.getOWLNamedClass("swrl:Imp");
        this.individualPropertyAtom = owlModel.getOWLNamedClass("swrl:IndividualPropertyAtom");
        this.sameIndividualAtomCls = owlModel.getOWLNamedClass("swrl:SameIndividualAtom");
        SWRLJavaFactory factory = new SWRLJavaFactory(owlModel);
        owlModel.setOWLJavaFactory(factory);
        if (owlModel instanceof JenaOWLModel) {
            OWLJavaFactoryUpdater.run((JenaOWLModel)owlModel);
        }
    }

    public SWRLImp createImp() {
        String name = this.getNewImpName();
        return (SWRLImp)this.impCls.createInstance(name);
    }

    public SWRLImp createImp(String expression) throws SWRLParseException {
        SWRLParser parser = new SWRLParser(this.owlModel);
        parser.setParseOnly(false);
        return parser.parse(expression);
    }

    public SWRLImp createImp(SWRLAtom headAtom, Collection bodyAtoms) {
        SWRLAtomList head = this.createAtomList(Collections.singleton(headAtom));
        SWRLAtomList body = this.createAtomList(bodyAtoms);
        return this.createImp(head, body);
    }

    public SWRLImp createImp(SWRLAtomList head, SWRLAtomList body) {
        SWRLImp swrlImp = this.createImp();
        swrlImp.setHead(head);
        swrlImp.setBody(body);
        return swrlImp;
    }

    public SWRLAtomList createAtomList() {
        return (SWRLAtomList)this.atomListCls.createAnonymousInstance();
    }

    public SWRLAtomList createAtomList(Collection atoms) {
        SWRLAtomList list = this.createAtomList();
        for (Object o : atoms) {
            list.append(o);
        }
        return list;
    }

    public SWRLBuiltinAtom createBuiltinAtom(SWRLBuiltin swrlBuiltin, Iterator arguments) {
        RDFList li = this.owlModel.createRDFList(arguments);
        return this.createBuiltinAtom(swrlBuiltin, li);
    }

    public SWRLBuiltinAtom createBuiltinAtom(SWRLBuiltin swrlBuiltin, RDFList arguments) {
        SWRLBuiltinAtom swrlBuiltinAtom = (SWRLBuiltinAtom)this.builtinAtomCls.createAnonymousInstance();
        swrlBuiltinAtom.setBuiltin(swrlBuiltin);
        swrlBuiltinAtom.setArguments(arguments);
        return swrlBuiltinAtom;
    }

    public SWRLClassAtom createClassAtom(RDFSNamedClass aClass, RDFResource iObject) {
        SWRLClassAtom swrlClassAtom = (SWRLClassAtom)this.classAtomCls.createAnonymousInstance();
        swrlClassAtom.setClassPredicate(aClass);
        swrlClassAtom.setArgument1(iObject);
        return swrlClassAtom;
    }

    public SWRLDataRangeAtom createDataRangeAtom(RDFResource dataRange, RDFObject dObject) {
        SWRLDataRangeAtom swrlDataRangeAtom = (SWRLDataRangeAtom)this.dataRangeAtomCls.createAnonymousInstance();
        swrlDataRangeAtom.setArgument1(dObject);
        swrlDataRangeAtom.setDataRange(dataRange);
        return swrlDataRangeAtom;
    }

    public SWRLDatavaluedPropertyAtom createDatavaluedPropertyAtom(OWLDatatypeProperty datatypeSlot, RDFResource iObject, RDFObject dObject) {
        SWRLDatavaluedPropertyAtom swrlDatavaluedPropertyAtom = (SWRLDatavaluedPropertyAtom)this.dataValuedPropertyAtomCls.createAnonymousInstance();
        swrlDatavaluedPropertyAtom.setPropertyPredicate(datatypeSlot);
        swrlDatavaluedPropertyAtom.setArgument1(iObject);
        swrlDatavaluedPropertyAtom.setArgument2(dObject);
        return swrlDatavaluedPropertyAtom;
    }

    public SWRLIndividualPropertyAtom createIndividualPropertyAtom(OWLObjectProperty objectSlot, RDFResource iObject1, RDFResource iObject2) {
        SWRLIndividualPropertyAtom swrlIndividualPropertyAtom = (SWRLIndividualPropertyAtom)this.individualPropertyAtom.createAnonymousInstance();
        swrlIndividualPropertyAtom.setPropertyPredicate(objectSlot);
        swrlIndividualPropertyAtom.setArgument1(iObject1);
        swrlIndividualPropertyAtom.setArgument2(iObject2);
        return swrlIndividualPropertyAtom;
    }

    public SWRLDifferentIndividualsAtom createDifferentIndividualsAtom(RDFResource argument1, RDFResource argument2) {
        SWRLDifferentIndividualsAtom swrlDifferentIndividualsAtom = (SWRLDifferentIndividualsAtom)this.differentIndividualsAtomCls.createAnonymousInstance();
        swrlDifferentIndividualsAtom.setArgument1(argument1);
        swrlDifferentIndividualsAtom.setArgument2(argument2);
        return swrlDifferentIndividualsAtom;
    }

    public SWRLSameIndividualAtom createSameIndividualAtom(RDFResource argument1, RDFResource argument2) {
        SWRLSameIndividualAtom swrlSameIndividualAtom = (SWRLSameIndividualAtom)this.sameIndividualAtomCls.createAnonymousInstance();
        swrlSameIndividualAtom.setArgument1(argument1);
        swrlSameIndividualAtom.setArgument2(argument2);
        return swrlSameIndividualAtom;
    }

    public SWRLVariable createVariable(String name) {
        return (SWRLVariable)this.owlModel.getRDFSNamedClass("swrl:Variable").createInstance(name);
    }

    public SWRLBuiltin createBuiltin(String name) {
        return (SWRLBuiltin)this.owlModel.getRDFSNamedClass("swrl:Builtin").createInstance(name);
    }

    public SWRLBuiltin getBuiltin(String name) {
        RDFResource resource = this.owlModel.getRDFResource(name);
        if (resource instanceof SWRLBuiltin) {
            return (SWRLBuiltin)resource;
        }
        System.err.println("[SWRLFactory]  Invalid attempt to cast " + name + " into SWRLBuiltin (real type is " + resource.getProtegeType() + ")");
        return null;
    }

    public Collection getBuiltins() {
        RDFSNamedClass builtinCls = this.owlModel.getRDFSNamedClass("swrl:Builtin");
        return builtinCls.getInstances(true);
    }

    public Collection getImps() {
        RDFSNamedClass impCls = this.owlModel.getRDFSNamedClass("swrl:Imp");
        return impCls.getInstances(true);
    }

    public String getNewImpName() {
        String base = "Rule-";
        int i = Math.max(1, this.impCls.getInstances(false).size());
        while (this.owlModel.getRDFResource(String.valueOf(base) + i) != null) {
            ++i;
        }
        return String.valueOf(base) + i;
    }

    public SWRLVariable getVariable(String name) {
        return (SWRLVariable)this.owlModel.getRDFResource(name);
    }

    public Collection getVariables() {
        RDFSNamedClass variableCls = this.owlModel.getRDFSNamedClass("swrl:Variable");
        return variableCls.getInstances(true);
    }
}

